/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.helper;

import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringHelper {
    public static String pad(String text, int len, char ch) {
        int l = text.length();
        StringBuffer res = new StringBuffer(text);
        for (int i = l; i < len; ++i) {
            res.insert(0, ch);
        }
        return res.toString();
    }

    public static String escape(String text) {
        StringBuffer res = new StringBuffer(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch < ' ') {
                res.append('^').append((char)(ch + 65 - 1));
                continue;
            }
            if (ch == '\n') {
                res.append("^J");
                continue;
            }
            if (ch == '\t') {
                res.append("^I");
                continue;
            }
            res.append(ch);
        }
        return res.toString();
    }

    public static String entities(String text) {
        StringBuffer res = new StringBuffer(text.length());
        block10: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '!': {
                    res.append("&#33;");
                    continue block10;
                }
                case '[': {
                    res.append("&#91;");
                    continue block10;
                }
                case ']': {
                    res.append("&#93;");
                    continue block10;
                }
                case ' ': {
                    res.append("&#32;");
                    continue block10;
                }
                case '&': {
                    res.append("&amp;");
                    continue block10;
                }
                case '\t': {
                    res.append("&#9;");
                    continue block10;
                }
                case '\n': {
                    res.append("&#10;");
                    continue block10;
                }
                case '\r': {
                    res.append("&#13;");
                    continue block10;
                }
                default: {
                    res.append(ch);
                }
            }
        }
        return res.toString();
    }

    public static String unentities(String text) {
        StringBuffer res = new StringBuffer(text.length());
        block3: for (int i = 0; i < text.length(); ++i) {
            int ch = text.charAt(i);
            switch (ch) {
                case 38: {
                    int semi = text.indexOf(59, i);
                    if (semi > i) {
                        int newch = ch;
                        String entity = text.substring(i, semi + 1);
                        if (entity.equals("&#32;")) {
                            newch = 32;
                        } else if (entity.equals("&#33;")) {
                            newch = 33;
                            i = semi;
                        } else if (entity.equals("&#91;")) {
                            newch = 91;
                            i = semi;
                        } else if (entity.equals("&#93;")) {
                            newch = 93;
                            i = semi;
                        } else if (entity.equals("&amp;")) {
                            newch = 38;
                            i = semi;
                        } else if (entity.equals("&#9;")) {
                            newch = 9;
                        } else if (entity.equals("&#10;")) {
                            newch = 10;
                        } else if (entity.equals("&#13;")) {
                            newch = 13;
                        }
                        if (newch != ch) {
                            ch = newch;
                            i = semi;
                        }
                    }
                    res.append((char)ch);
                    continue block3;
                }
                default: {
                    res.append((char)ch);
                }
            }
        }
        return res.toString();
    }

    public static List<KeyStroke> stringToKeys(String str) {
        ArrayList<KeyStroke> res = new ArrayList<KeyStroke>();
        for (int i = 0; i < str.length(); ++i) {
            res.add(KeyStroke.getKeyStroke(str.charAt(i)));
        }
        return res;
    }

    public static String keysToString(List<KeyStroke> keys) {
        StringBuffer res = new StringBuffer();
        block5: for (KeyStroke key : keys) {
            if (key.getKeyChar() != '\uffff') {
                res.append(key.getKeyChar());
                continue;
            }
            switch (key.getKeyCode()) {
                case 9: {
                    res.append("\t");
                    continue block5;
                }
                case 10: {
                    res.append("\n");
                    continue block5;
                }
                case 8: {
                    res.append("\b");
                    continue block5;
                }
            }
            res.append('<');
            res.append(StringHelper.getModifiersText(key.getModifiers()));
            res.append(KeyEvent.getKeyText(key.getKeyCode()));
            res.append('>');
        }
        return res.toString();
    }

    public static String getModifiersText(int modifiers) {
        StringBuffer buf = new StringBuffer();
        if ((modifiers & 4) != 0) {
            buf.append("M-");
        }
        if ((modifiers & 2) != 0) {
            buf.append("C-");
        }
        if ((modifiers & 8) != 0) {
            buf.append("A-");
        }
        if ((modifiers & 1) != 0) {
            buf.append("S-");
        }
        if ((modifiers & 0x20) != 0) {
            buf.append("G-");
        }
        return buf.toString();
    }

    public static boolean containsUpperCase(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (!Character.isUpperCase(text.charAt(i)) || i != 0 && text.charAt(i - 1) != '\\') continue;
            return true;
        }
        return false;
    }

    private StringHelper() {
    }
}

