/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.key;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyConflict {
    private KeyStroke keyStroke;
    private boolean pluginWins;
    private HashMap<String, Integer> ideaActions = new HashMap();
    private List<String> pluginActions = new ArrayList<String>();

    public KeyConflict(KeyStroke keyStroke) {
        this.keyStroke = keyStroke;
        this.pluginWins = true;
    }

    public KeyStroke getKeyStroke() {
        return this.keyStroke;
    }

    public boolean hasConflict() {
        return this.ideaActions.size() > 0 && this.pluginActions.size() > 0;
    }

    public boolean isPluginWins() {
        return this.pluginWins;
    }

    public void setPluginWins(boolean pluginWins) {
        this.pluginWins = pluginWins;
    }

    public HashMap<String, Integer> getIdeaActions() {
        return this.ideaActions;
    }

    public void addIdeaAction(String action) {
        this.putIdeaAction(action, -1);
    }

    public void resetIdeaAction(String action) {
        this.putIdeaAction(action, -1);
    }

    public void putIdeaAction(String action, int pos) {
        this.ideaActions.put(action, pos);
    }

    public int removeIdeaAction(String action) {
        return this.ideaActions.remove(action);
    }

    public List<String> getPluginActions() {
        return this.pluginActions;
    }

    public void addPluginAction(String action) {
        this.pluginActions.add(action);
    }

    public boolean removePluginAction(String action) {
        return this.pluginActions.remove(action);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyConflict that = (KeyConflict)o;
        if (this.pluginWins != that.pluginWins) {
            return false;
        }
        if (!this.ideaActions.equals(that.ideaActions)) {
            return false;
        }
        if (!this.keyStroke.equals(that.keyStroke)) {
            return false;
        }
        return ((Object)this.pluginActions).equals(that.pluginActions);
    }

    public int hashCode() {
        int result = this.keyStroke.hashCode();
        result = 29 * result + (this.pluginWins ? 1 : 0);
        result = 29 * result + this.ideaActions.hashCode();
        result = 29 * result + ((Object)this.pluginActions).hashCode();
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("KeyConflict");
        sb.append("{keyStroke=").append(this.keyStroke);
        sb.append(", pluginWins=").append(this.pluginWins);
        sb.append(", ideaActions=").append(this.ideaActions);
        sb.append(", pluginActions=").append(this.pluginActions);
        sb.append('}');
        return sb.toString();
    }
}

