/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.key;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.maddyhome.idea.vim.action.DelegateAction;
import com.maddyhome.idea.vim.action.PassThruDelegateAction;
import com.maddyhome.idea.vim.action.PassThruDelegateEditorAction;
import com.maddyhome.idea.vim.handler.key.EditorKeyHandler;
import com.maddyhome.idea.vim.key.ArgumentNode;
import com.maddyhome.idea.vim.key.BranchNode;
import com.maddyhome.idea.vim.key.CommandNode;
import com.maddyhome.idea.vim.key.Node;
import com.maddyhome.idea.vim.key.ParentNode;
import com.maddyhome.idea.vim.key.RootNode;
import com.maddyhome.idea.vim.key.Shortcut;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.KeyStroke;

public class KeyParser {
    public static final int MAPPING_NORMAL = 1;
    public static final int MAPPING_VISUAL = 2;
    public static final int MAPPING_OP_PEND = 4;
    public static final int MAPPING_INSERT = 8;
    public static final int MAPPING_CMD_LINE = 16;
    private static final int MAPPING_CNT = 5;
    public static final int MAPPING_NVO = 7;
    public static final int MAPPING_ALL = 31;
    private HashMap<Integer, RootNode> keyRoots = new HashMap();
    private static KeyParser instance;
    private static Logger logger;

    public static KeyParser getInstance() {
        if (instance == null) {
            instance = new KeyParser();
        }
        return instance;
    }

    public void setupActionHandler(String ideaActName, String vimActName) {
        ActionManager amgr;
        AnAction vaction;
        if (logger.isDebugEnabled()) {
            logger.debug("vimActName=" + vimActName);
        }
        if ((vaction = (amgr = ActionManager.getInstance()).getAction(vimActName)) instanceof DelegateAction) {
            amgr.unregisterAction(vimActName);
        }
        this.setupActionHandler(ideaActName, vaction);
    }

    public void setupActionHandler(String ideaActName, AnAction vaction) {
        if (logger.isDebugEnabled()) {
            logger.debug("ideaActName=" + ideaActName);
        }
        ActionManager amgr = ActionManager.getInstance();
        AnAction iaction = amgr.getAction(ideaActName);
        if (vaction instanceof DelegateAction) {
            DelegateAction daction = (DelegateAction)vaction;
            daction.setOrigAction(iaction);
            amgr.unregisterAction(ideaActName);
            amgr.registerAction(ideaActName, vaction);
        }
        amgr.registerAction("Orig" + ideaActName, iaction);
    }

    public void setupActionHandler(String ideaActName, String vimActName, KeyStroke stroke) {
        this.setupActionHandler(ideaActName, vimActName, stroke, false);
    }

    public void setupActionHandler(String ideaActName, String vimActName, KeyStroke stroke, boolean special) {
        ActionManager amgr;
        AnAction action;
        if (logger.isDebugEnabled()) {
            logger.debug("setupActionHandler for " + ideaActName + " and " + vimActName + " for " + stroke);
        }
        if ((action = (amgr = ActionManager.getInstance()).getAction(ideaActName)) instanceof EditorAction) {
            if (logger.isDebugEnabled()) {
                logger.debug(ideaActName + " is an EditorAction");
            }
            EditorAction iaction = (EditorAction)action;
            EditorActionHandler handler = iaction.getHandler();
            if (vimActName != null) {
                EditorAction vaction = (EditorAction)amgr.getAction(vimActName);
                vaction.setupHandler(handler);
            }
            iaction.setupHandler((EditorActionHandler)new EditorKeyHandler(handler, stroke, special));
        }
    }

    private KeyParser() {
        logger.debug("KeyParser ctr");
    }

    public RootNode getKeyRoot(int mode) {
        RootNode res = this.keyRoots.get(new Integer(mode));
        if (res == null) {
            res = new RootNode();
            this.keyRoots.put(mode, res);
        }
        return res;
    }

    public void registerAction(int mapping, String actName, int cmdType) {
        this.registerAction(mapping, actName, cmdType, 0);
    }

    public void registerAction(int mapping, String actName, int cmdType, int cmdFlags) {
        String ideaName = actName.substring(3);
        ActionManager amgr = ActionManager.getInstance();
        if (amgr.getAction(ideaName) == null) {
            logger.info("No registered action " + ideaName);
            return;
        }
        Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
        com.intellij.openapi.actionSystem.Shortcut[] cuts = keymap.getShortcuts(ideaName);
        ArrayList<Shortcut> shortcuts = new ArrayList<Shortcut>();
        for (com.intellij.openapi.actionSystem.Shortcut cut : cuts) {
            if (!(cut instanceof KeyboardShortcut)) continue;
            KeyStroke keyStroke = ((KeyboardShortcut)cut).getFirstKeyStroke();
            Shortcut shortcut = new Shortcut(keyStroke);
            shortcuts.add(shortcut);
        }
        this.registerAction(mapping, actName, cmdType, cmdFlags, shortcuts.toArray(new Shortcut[0]));
        KeyStroke firstStroke = null;
        for (int i = 0; i < shortcuts.size(); ++i) {
            Shortcut cut = (Shortcut)shortcuts.get(i);
            if (i != 0) continue;
            firstStroke = cut.getKeys()[0];
        }
        AnAction iaction = amgr.getAction(ideaName);
        AnAction vaction = amgr.getAction(actName);
        if (vaction instanceof DelegateAction) {
            DelegateAction daction = (DelegateAction)vaction;
            daction.setOrigAction(iaction);
        }
        if (iaction instanceof EditorAction) {
            EditorAction ea = (EditorAction)iaction;
            this.setupActionHandler(ideaName, (AnAction)new PassThruDelegateEditorAction(firstStroke, ea.getHandler()));
        } else {
            this.setupActionHandler(ideaName, new PassThruDelegateAction(firstStroke));
        }
    }

    public void registerAction(int mapping, String actName, int cmdType, Shortcut shortcut) {
        this.registerAction(mapping, actName, cmdType, new Shortcut[]{shortcut});
    }

    public void registerAction(int mapping, String actName, int cmdType, int cmdFlags, Shortcut shortcut) {
        this.registerAction(mapping, actName, cmdType, cmdFlags, new Shortcut[]{shortcut});
    }

    public void registerAction(int mapping, String actName, int cmdType, Shortcut shortcut, int argType) {
        this.registerAction(mapping, actName, cmdType, new Shortcut[]{shortcut}, argType);
    }

    public void registerAction(int mapping, String actName, int cmdType, int cmdFlags, Shortcut shortcut, int argType) {
        this.registerAction(mapping, actName, cmdType, cmdFlags, new Shortcut[]{shortcut}, argType);
    }

    public void registerAction(int mapping, String actName, int cmdType, Shortcut[] shortcuts) {
        this.registerAction(mapping, actName, cmdType, 0, shortcuts);
    }

    public void registerAction(int mapping, String actName, int cmdType, Shortcut[] shortcuts, int argType) {
        this.registerAction(mapping, actName, cmdType, 0, shortcuts, argType);
    }

    public void registerAction(int mapping, String actName, int cmdType, int cmdFlags, Shortcut[] shortcuts) {
        this.registerAction(mapping, actName, cmdType, cmdFlags, shortcuts, 0);
    }

    public void registerAction(int mapping, String actName, int cmdType, int cmdFlags, Shortcut[] shortcuts, int argType) {
        for (Shortcut shortcut : shortcuts) {
            this.registerAction(mapping, actName, cmdType, cmdFlags, shortcut.getKeys(), argType);
        }
    }

    private void registerAction(int mapping, String actName, int cmdType, int cmdFlags, KeyStroke[] keys, int argType) {
        int map = 1;
        for (int m = 0; m < 5; ++m) {
            if ((mapping & map) != 0) {
                Node node = this.getKeyRoot(map);
                int len = keys.length;
                for (int i = 0; i < len; ++i) {
                    if (!(node instanceof ParentNode)) continue;
                    ParentNode base = node;
                    node = this.addNode(base, actName, cmdType, cmdFlags, keys[i], argType, i == len - 1);
                }
            }
            map <<= 1;
        }
    }

    private Node addNode(ParentNode base, String actName, int cmdType, int cmdFlags, KeyStroke key, int argType, boolean last) {
        Node node;
        ActionManager aMgr = ActionManager.getInstance();
        AnAction action = aMgr.getAction(actName);
        if (action == null) {
            logger.error("Unknown action " + actName);
        }
        if ((node = base.getChild(key)) == null) {
            node = last && argType == 0 ? new CommandNode(key, actName, action, cmdType, cmdFlags) : new BranchNode(key, cmdFlags);
            base.addChild(node, key);
        }
        if (last && node instanceof BranchNode && argType != 0) {
            ArgumentNode arg = new ArgumentNode(actName, action, cmdType, argType, cmdFlags);
            ((BranchNode)node).addChild(arg, "argument");
        }
        return node;
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("KeyParser=[");
        res.append("roots=[");
        res.append(this.keyRoots);
        res.append("]");
        return res.toString();
    }

    static {
        logger = Logger.getInstance((String)KeyParser.class.getName());
    }

    private class KeyChangeListener
    implements Keymap.Listener {
        private KeyChangeListener() {
        }

        public void onShortcutChanged(String actionId) {
        }
    }
}

