/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.option;

import com.maddyhome.idea.vim.option.TextOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListOption
extends TextOption {
    protected List<String> dflt;
    protected List<String> value;
    protected String pattern;

    ListOption(String name, String abbrev, String[] dflt, String pattern) {
        super(name, abbrev);
        this.dflt = new ArrayList<String>(Arrays.asList(dflt));
        this.value = new ArrayList<String>(this.dflt);
        this.pattern = pattern;
    }

    @Override
    public String getValue() {
        StringBuffer res = new StringBuffer();
        int cnt = 0;
        for (String s : this.value) {
            if (cnt > 0) {
                res.append(",");
            }
            res.append(s);
            ++cnt;
        }
        return res.toString();
    }

    public List<String> values() {
        return this.value;
    }

    public boolean contains(String val) {
        return this.value.containsAll(this.parseVals(val));
    }

    @Override
    public boolean set(String val) {
        return this.set(this.parseVals(val));
    }

    @Override
    public boolean append(String val) {
        return this.append(this.parseVals(val));
    }

    @Override
    public boolean prepend(String val) {
        return this.prepend(this.parseVals(val));
    }

    @Override
    public boolean remove(String val) {
        return this.remove(this.parseVals(val));
    }

    protected boolean set(List<String> vals) {
        if (vals == null) {
            return false;
        }
        this.value = vals;
        this.fireOptionChangeEvent();
        return true;
    }

    protected boolean append(List<String> vals) {
        if (vals == null) {
            return false;
        }
        this.value.addAll(vals);
        this.fireOptionChangeEvent();
        return true;
    }

    protected boolean prepend(List<String> vals) {
        if (vals == null) {
            return false;
        }
        this.value.addAll(0, vals);
        this.fireOptionChangeEvent();
        return true;
    }

    protected boolean remove(List<String> vals) {
        if (vals == null) {
            return false;
        }
        this.value.removeAll(vals);
        this.fireOptionChangeEvent();
        return true;
    }

    protected List<String> parseVals(String val) {
        ArrayList<String> res = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(val, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (this.pattern == null || token.matches(this.pattern)) {
                res.add(token);
                continue;
            }
            return null;
        }
        return res;
    }

    @Override
    public boolean isDefault() {
        return ((Object)this.dflt).equals(this.value);
    }

    @Override
    public void resetDefault() {
        if (!((Object)this.dflt).equals(this.value)) {
            this.value = new ArrayList<String>(this.dflt);
            this.fireOptionChangeEvent();
        }
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("  ");
        res.append(this.getName());
        res.append("=");
        res.append(this.getValue());
        return res.toString();
    }
}

