/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.option;

import com.maddyhome.idea.vim.option.TextOption;

public class NumberOption
extends TextOption {
    private int dflt;
    private int value;
    private int min;
    private int max;

    NumberOption(String name, String abbrev, int dflt) {
        this(name, abbrev, dflt, 0, Integer.MAX_VALUE);
    }

    NumberOption(String name, String abbrev, int dflt, int min, int max) {
        super(name, abbrev);
        this.dflt = dflt;
        this.value = dflt;
        this.min = min;
        this.max = max;
    }

    public String getValue() {
        return Integer.toString(this.value);
    }

    public int value() {
        return this.value;
    }

    public boolean set(int val) {
        return this.set(Integer.toString(val));
    }

    public boolean set(String val) {
        Integer num = this.asNumber(val);
        if (num == null) {
            return false;
        }
        if (this.inRange(num)) {
            this.value = num;
            this.fireOptionChangeEvent();
            return true;
        }
        return false;
    }

    public boolean append(String val) {
        Integer num = this.asNumber(val);
        if (num == null) {
            return false;
        }
        if (this.inRange(this.value + num)) {
            this.value += num.intValue();
            this.fireOptionChangeEvent();
            return true;
        }
        return false;
    }

    public boolean prepend(String val) {
        Integer num = this.asNumber(val);
        if (num == null) {
            return false;
        }
        if (this.inRange(this.value * num)) {
            this.value *= num.intValue();
            this.fireOptionChangeEvent();
            return true;
        }
        return false;
    }

    public boolean remove(String val) {
        Integer num = this.asNumber(val);
        if (num == null) {
            return false;
        }
        if (this.inRange(this.value - num)) {
            this.value -= num.intValue();
            this.fireOptionChangeEvent();
            return true;
        }
        return false;
    }

    public boolean isDefault() {
        return this.value == this.dflt;
    }

    public void resetDefault() {
        if (this.dflt != this.value) {
            this.value = this.dflt;
            this.fireOptionChangeEvent();
        }
    }

    protected Integer asNumber(String val) {
        try {
            return Integer.decode(val);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    protected boolean inRange(int val) {
        return val >= this.min && val <= this.max;
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("  ");
        res.append(this.getName());
        res.append("=");
        res.append(this.value);
        return res.toString();
    }
}

