/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.option;

import com.maddyhome.idea.vim.option.OptionChangeEvent;
import com.maddyhome.idea.vim.option.OptionChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public abstract class Option {
    protected String name;
    protected String abbrev;
    protected List<OptionChangeListener> listeners = new ArrayList<OptionChangeListener>();

    protected Option(String name, String abbrev) {
        this.name = name;
        this.abbrev = abbrev;
    }

    public void addOptionChangeListener(OptionChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeOptionChangeListener(OptionChangeListener listener) {
        this.listeners.remove(listener);
    }

    public String getName() {
        return this.name;
    }

    public String getAbbreviation() {
        return this.abbrev;
    }

    public abstract boolean isDefault();

    public abstract void resetDefault();

    protected void fireOptionChangeEvent() {
        OptionChangeEvent event = new OptionChangeEvent(this);
        for (OptionChangeListener listener : this.listeners) {
            listener.valueChange(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NameSorter<V>
    implements Comparator<V> {
        NameSorter() {
        }

        @Override
        public int compare(V o1, V o2) {
            return ((Option)o1).name.compareTo(((Option)o2).name);
        }
    }
}

