/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.option;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.helper.ApiHelper;
import com.maddyhome.idea.vim.helper.MessageHelper;
import com.maddyhome.idea.vim.option.BoundListOption;
import com.maddyhome.idea.vim.option.BoundStringOption;
import com.maddyhome.idea.vim.option.ListOption;
import com.maddyhome.idea.vim.option.NumberOption;
import com.maddyhome.idea.vim.option.Option;
import com.maddyhome.idea.vim.option.TextOption;
import com.maddyhome.idea.vim.option.ToggleOption;
import com.maddyhome.idea.vim.ui.MorePanel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Options {
    private HashMap<String, Option> options = new HashMap();
    private HashMap<String, Option> abbrevs = new HashMap();
    private static Options ourInstance;
    private static Logger logger;

    public static synchronized Options getInstance() {
        if (ourInstance == null) {
            ourInstance = new Options();
        }
        return ourInstance;
    }

    public boolean isSet(String name) {
        Option opt = this.getOption(name);
        if (opt != null && opt instanceof ToggleOption) {
            return ((ToggleOption)opt).getValue();
        }
        return false;
    }

    public Option getOption(String name) {
        Option res = this.options.get(name);
        if (res == null) {
            res = this.abbrevs.get(name);
        }
        return res;
    }

    Collection<Option> allOptions() {
        return this.options.values();
    }

    Collection<Option> changedOptions() {
        ArrayList<Option> res = new ArrayList<Option>();
        for (Option option : this.options.values()) {
            if (option.isDefault()) continue;
            res.add(option);
        }
        return res;
    }

    public boolean parseOptionLine(Editor editor, String args, boolean failOnBad) {
        if (args.length() == 0) {
            this.showOptions(editor, this.changedOptions(), true);
            return true;
        }
        if (args.equals("all")) {
            this.showOptions(editor, this.allOptions(), true);
            return true;
        }
        if (args.equals("all&")) {
            this.resetAllOptions();
            return true;
        }
        String error = null;
        String token = null;
        StringTokenizer tokenizer = new StringTokenizer(args);
        ArrayList<Option> toShow = new ArrayList<Option>();
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            while (token.endsWith("\\")) {
                token = token.substring(0, token.length() - 1) + ' ';
                if (!tokenizer.hasMoreTokens()) continue;
                token = token + tokenizer.nextToken();
            }
            if (token.endsWith("?")) {
                String option = token.substring(0, token.length() - 1);
                Option opt = this.getOption(option);
                if (opt != null) {
                    toShow.add(opt);
                } else {
                    error = "unkopt";
                }
            } else if (token.startsWith("no")) {
                String option = token.substring(2);
                Option opt = this.getOption(option);
                if (opt != null) {
                    if (opt instanceof ToggleOption) {
                        ((ToggleOption)opt).reset();
                    } else {
                        error = "e_invarg";
                    }
                } else {
                    error = "unkopt";
                }
            } else if (token.startsWith("inv")) {
                String option = token.substring(3);
                Option opt = this.getOption(option);
                if (opt != null) {
                    if (opt instanceof ToggleOption) {
                        ((ToggleOption)opt).toggle();
                    } else {
                        error = "e_invarg";
                    }
                } else {
                    error = "unkopt";
                }
            } else if (token.endsWith("!")) {
                String option = token.substring(0, token.length() - 1);
                Option opt = this.getOption(option);
                if (opt != null) {
                    if (opt instanceof ToggleOption) {
                        ((ToggleOption)opt).toggle();
                    } else {
                        error = "e_invarg";
                    }
                } else {
                    error = "unkopt";
                }
            } else if (token.endsWith("&")) {
                String option = token.substring(0, token.length() - 1);
                Option opt = this.getOption(option);
                if (opt != null) {
                    opt.resetDefault();
                } else {
                    error = "unkopt";
                }
            } else {
                int eq = token.indexOf(61);
                if (eq == -1) {
                    eq = token.indexOf(58);
                }
                if (eq == -1) {
                    Option opt = this.getOption(token);
                    if (opt != null) {
                        if (opt instanceof ToggleOption) {
                            ((ToggleOption)opt).set();
                        } else {
                            toShow.add(opt);
                        }
                    } else {
                        error = "unkopt";
                    }
                } else if (eq > 0) {
                    char op = token.charAt(eq - 1);
                    int end = eq;
                    if ("+-^".indexOf(op) != -1) {
                        --end;
                    }
                    String option = token.substring(0, end);
                    String value = token.substring(eq + 1);
                    Option opt = this.getOption(option);
                    if (opt != null) {
                        if (opt instanceof TextOption) {
                            boolean res;
                            TextOption to = (TextOption)opt;
                            switch (op) {
                                case '+': {
                                    res = to.append(value);
                                    break;
                                }
                                case '-': {
                                    res = to.remove(value);
                                    break;
                                }
                                case '^': {
                                    res = to.prepend(value);
                                    break;
                                }
                                default: {
                                    res = to.set(value);
                                }
                            }
                            if (!res) {
                                error = "e_invarg";
                            }
                        } else {
                            error = "e_invarg";
                        }
                    } else {
                        error = "unkopt";
                    }
                } else {
                    error = "unkopt";
                }
            }
            if (!failOnBad || error == null) continue;
        }
        if (toShow.size() > 0) {
            this.showOptions(editor, toShow, false);
        }
        if (editor != null && error != null) {
            VimPlugin.showMessage(MessageHelper.getMsg(error, token));
            VimPlugin.indicateError();
        }
        return error == null;
    }

    private void resetAllOptions() {
        Collection<Option> opts = this.allOptions();
        for (Option option : opts) {
            option.resetDefault();
        }
    }

    private void showOptions(Editor editor, Collection<Option> opts, boolean showIntro) {
        if (editor == null) {
            return;
        }
        ArrayList<Option> cols = new ArrayList<Option>();
        ArrayList<Option> extra = new ArrayList<Option>();
        for (Option option : opts) {
            if (option.toString().length() > 19) {
                extra.add(option);
                continue;
            }
            cols.add(option);
        }
        Collections.sort(cols, new Option.NameSorter());
        Collections.sort(extra, new Option.NameSorter());
        String pad = "                    ";
        MorePanel panel = MorePanel.getInstance(editor);
        int width = panel.getDisplayWidth();
        if (width < 20) {
            width = 80;
        }
        int colCount = width / 20;
        int height = (int)Math.ceil((double)cols.size() / (double)colCount);
        int empty = cols.size() % colCount;
        int n = empty = empty == 0 ? colCount : empty;
        if (logger.isDebugEnabled()) {
            logger.debug("width=" + width);
            logger.debug("colCount=" + colCount);
            logger.debug("height=" + height);
        }
        StringBuffer res = new StringBuffer();
        if (showIntro) {
            res.append("--- Options ---\n");
        }
        for (int h = 0; h < height; ++h) {
            for (int c = 0; c < colCount && (h != height - 1 || c < empty); ++c) {
                int pos = c * height + h;
                if (c > empty) {
                    pos -= c - empty;
                }
                Option opt = (Option)cols.get(pos);
                String val = opt.toString();
                res.append(val);
                res.append(pad.substring(0, 20 - val.length()));
            }
            res.append("\n");
        }
        for (Option opt : extra) {
            String val = opt.toString();
            int seg = (val.length() - 1) / width;
            for (int j = 0; j <= seg; ++j) {
                res.append(val.substring(j * width, Math.min(j * width + width, val.length())));
                res.append("\n");
            }
        }
        panel.setText(res.toString());
    }

    private Options() {
        this.createDefaultOptions();
        this.loadVimrc();
    }

    private void loadVimrc() {
        String home = System.getProperty("user.home");
        if (home != null) {
            File rc = new File(home, ".vimrc");
            if (!rc.exists() && !(rc = new File(home, "_vimrc")).exists()) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("found vimrc at " + rc);
            }
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(rc));
                while ((line = br.readLine()) != null) {
                    if (!line.startsWith(":set") && !line.startsWith("set")) continue;
                    int pos = line.indexOf(32);
                    this.parseOptionLine(null, line.substring(pos).trim(), false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void createDefaultOptions() {
        this.addOption(new ToggleOption("digraph", "dg", false));
        this.addOption(new ToggleOption("gdefault", "gd", false));
        this.addOption(new NumberOption("history", "hi", 20, 1, Integer.MAX_VALUE));
        if (ApiHelper.supportsColorSchemes()) {
            this.addOption(new ToggleOption("hlsearch", "hls", false));
        }
        this.addOption(new ToggleOption("ignorecase", "ic", false));
        this.addOption(new ListOption("matchpairs", "mps", new String[]{"(:)", "{:}", "[:]"}, ".:."));
        this.addOption(new ToggleOption("more", "more", true));
        this.addOption(new BoundListOption("nrformats", "nf", new String[]{"octal", "hex"}, new String[]{"octal", "hex", "alpha"}));
        this.addOption(new NumberOption("scroll", "scr", 0));
        this.addOption(new NumberOption("scrolljump", "sj", 1));
        this.addOption(new NumberOption("scrolloff", "so", 0));
        this.addOption(new BoundStringOption("selection", "sel", "inclusive", new String[]{"old", "inclusive", "exclusive"}));
        this.addOption(new ToggleOption("showmode", "smd", false));
        this.addOption(new NumberOption("sidescroll", "ss", 0));
        this.addOption(new NumberOption("sidescrolloff", "siso", 0));
        this.addOption(new ToggleOption("smartcase", "scs", false));
        this.addOption(new NumberOption("undolevels", "ul", 1000, -1, Integer.MAX_VALUE));
        this.addOption(new ToggleOption("visualbell", "vb", false));
        this.addOption(new ToggleOption("wrapscan", "ws", true));
    }

    private void addOption(Option option) {
        this.options.put(option.getName(), option);
        this.abbrevs.put(option.getAbbreviation(), option);
    }

    static {
        logger = Logger.getInstance((String)Options.class.getName());
    }
}

