/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.option;

import com.maddyhome.idea.vim.option.TextOption;

public class StringOption
extends TextOption {
    protected String dflt;
    protected String value;

    StringOption(String name, String abbrev, String dflt) {
        super(name, abbrev);
        this.dflt = dflt;
        this.value = dflt;
    }

    public String getValue() {
        return this.value;
    }

    public boolean set(String val) {
        this.value = val;
        this.fireOptionChangeEvent();
        return true;
    }

    public boolean append(String val) {
        this.value = this.value + val;
        this.fireOptionChangeEvent();
        return true;
    }

    public boolean prepend(String val) {
        this.value = val + this.value;
        this.fireOptionChangeEvent();
        return true;
    }

    public boolean remove(String val) {
        int pos = this.value.indexOf(val);
        if (pos != -1) {
            this.value = this.value.substring(0, pos) + this.value.substring(pos + val.length());
            this.fireOptionChangeEvent();
            return true;
        }
        return false;
    }

    public boolean isDefault() {
        return this.dflt.equals(this.value);
    }

    public void resetDefault() {
        if (!this.dflt.equals(this.value)) {
            this.value = this.dflt;
            this.fireOptionChangeEvent();
        }
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("  ");
        res.append(this.getName());
        res.append("=");
        res.append(this.value);
        return res.toString();
    }
}

