/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.regexp;

import java.nio.CharBuffer;

public class CharPointer {
    public static final CharPointer INIT = new CharPointer();
    private CharSequence seq;
    private int pointer;
    private boolean readonly = true;

    public CharPointer(String text) {
        this.seq = text;
        this.readonly = true;
    }

    public CharPointer(CharBuffer text) {
        this.seq = text;
        this.readonly = true;
    }

    public CharPointer(StringBuffer text) {
        this.seq = text;
        this.readonly = false;
    }

    private CharPointer(CharPointer ptr, int offset) {
        this.seq = ptr.seq;
        this.readonly = ptr.readonly;
        this.pointer = ptr.pointer + offset;
    }

    private CharPointer() {
        this.seq = null;
        this.pointer = -1;
        this.readonly = true;
    }

    public int pointer() {
        return this.pointer;
    }

    public boolean isInit() {
        return this.seq == null && this.pointer == -1;
    }

    public CharPointer set(char ch) {
        return this.set(ch, 0);
    }

    public CharPointer set(char ch, int offset) {
        if (this.seq == null) {
            return this;
        }
        if (this.readonly) {
            throw new IllegalStateException("readonly string");
        }
        StringBuffer data = (StringBuffer)this.seq;
        while (this.pointer + offset >= data.length()) {
            data.append('\u0000');
        }
        data.setCharAt(this.pointer + offset, ch);
        return this;
    }

    public char charAtInc() {
        char res = this.charAt(0);
        this.inc();
        return res;
    }

    public char charAt() {
        return this.charAt(0);
    }

    public char charAt(int offset) {
        if (this.end(offset)) {
            return '\u0000';
        }
        return this.seq.charAt(this.pointer + offset);
    }

    public CharPointer inc() {
        return this.inc(1);
    }

    public CharPointer inc(int cnt) {
        this.pointer += cnt;
        return this;
    }

    public CharPointer dec() {
        return this.dec(1);
    }

    public CharPointer dec(int cnt) {
        this.pointer -= cnt;
        return this;
    }

    public CharPointer assign(CharPointer ptr) {
        this.seq = ptr.seq;
        this.pointer = ptr.pointer;
        this.readonly = ptr.readonly;
        return this;
    }

    public CharPointer ref(int offset) {
        if (this.equals(INIT)) {
            return INIT;
        }
        return new CharPointer(this, offset);
    }

    public String substring(int len) {
        if (this.end()) {
            return "";
        }
        int start = this.pointer;
        int end = this.normalize(this.pointer + len);
        int slen = this.seq.length();
        return CharBuffer.wrap(this.seq, start, end).toString();
    }

    public int strlen() {
        if (this.end()) {
            return 0;
        }
        for (int i = this.pointer; i < this.seq.length(); ++i) {
            if (this.seq.charAt(i) != '\u0000') continue;
            return i - this.pointer;
        }
        return this.seq.length() - this.pointer;
    }

    public int strncmp(String str, int len) {
        if (this.end()) {
            return -1;
        }
        String s = CharBuffer.wrap(this.seq, this.pointer, this.normalize(this.pointer + len)).toString();
        if (len > str.length()) {
            len = str.length();
        }
        return s.compareTo(str.substring(0, len));
    }

    public int strncmp(CharPointer str, int len) {
        if (this.end()) {
            return -1;
        }
        CharBuffer cs1 = CharBuffer.wrap(this.seq, this.pointer, this.normalize(this.pointer + len));
        CharBuffer cs2 = CharBuffer.wrap(str.seq, str.pointer, str.normalize(str.pointer + len));
        int l = cs1.length();
        if (l != cs2.length()) {
            return 1;
        }
        for (int i = 0; i < l; ++i) {
            char c2;
            char c1 = cs1.charAt(i);
            if (c1 == (c2 = cs2.charAt(i))) continue;
            return 1;
        }
        return 0;
    }

    public int strnicmp(CharPointer str, int len) {
        if (this.end()) {
            return -1;
        }
        CharBuffer cs1 = CharBuffer.wrap(this.seq, this.pointer, this.normalize(this.pointer + len));
        CharBuffer cs2 = CharBuffer.wrap(str.seq, str.pointer, str.normalize(str.pointer + len));
        int l = cs1.length();
        if (l != cs2.length()) {
            return 1;
        }
        for (int i = 0; i < l; ++i) {
            char c1 = cs1.charAt(i);
            char c2 = cs2.charAt(i);
            if (Character.toLowerCase(c1) == Character.toLowerCase(c2) || Character.toUpperCase(c1) == Character.toUpperCase(c2)) continue;
            return 1;
        }
        return 0;
    }

    public CharPointer strchr(char c) {
        if (this.end()) {
            return null;
        }
        int len = this.seq.length();
        for (int i = this.pointer; i < len; ++i) {
            if (this.seq.charAt(i) != c) continue;
            return this.ref(i - this.pointer);
        }
        return null;
    }

    public CharPointer istrchr(char c) {
        if (this.end()) {
            return null;
        }
        int len = this.seq.length();
        char cc = Character.toUpperCase(c);
        c = Character.toLowerCase(c);
        for (int i = this.pointer; i < len; ++i) {
            char ch = this.seq.charAt(i);
            if (ch != c && ch != cc) continue;
            return this.ref(i - this.pointer);
        }
        return null;
    }

    public boolean isNul() {
        return this.charAt() == '\u0000';
    }

    public boolean end() {
        return this.end(0);
    }

    public boolean end(int offset) {
        if (this.seq == null) {
            return true;
        }
        return this.pointer + offset >= this.seq.length();
    }

    public int OP() {
        return this.charAt();
    }

    public CharPointer OPERAND() {
        return this.ref(3);
    }

    public int NEXT() {
        return ((this.seq.charAt(this.pointer + 1) & 0xFF) << 8) + (this.seq.charAt(this.pointer + 2) & 0xFF);
    }

    public int OPERAND_MIN() {
        return (this.seq.charAt(this.pointer + 3) << 24) + (this.seq.charAt(this.pointer + 4) << 16) + (this.seq.charAt(this.pointer + 5) << 8) + this.seq.charAt(this.pointer + 6);
    }

    public int OPERAND_MAX() {
        return (this.seq.charAt(this.pointer + 7) << 24) + (this.seq.charAt(this.pointer + 8) << 16) + (this.seq.charAt(this.pointer + 9) << 8) + this.seq.charAt(this.pointer + 10);
    }

    public char OPERAND_CMP() {
        return this.seq.charAt(this.pointer + 7);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CharPointer) {
            CharPointer ptr = (CharPointer)obj;
            if (ptr.seq == this.seq && ptr.pointer == this.pointer) {
                return true;
            }
        }
        return false;
    }

    private int normalize(int pos) {
        return Math.min(this.seq.length(), pos);
    }

    public String toString() {
        return this.substring(this.strlen());
    }
}

