/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.regexp;

public abstract class CharacterClasses {
    public static final String[] CLASS_NAMES = new String[]{"alnum:]", "alpha:]", "blank:]", "cntrl:]", "digit:]", "graph:]", "lower:]", "print:]", "punct:]", "space:]", "upper:]", "xdigit:]", "tab:]", "return:]", "backspace:]", "escape:]"};
    public static final int RI_DIGIT = 1;
    public static final int RI_HEX = 2;
    public static final int RI_OCTAL = 4;
    public static final int RI_WORD = 8;
    public static final int RI_HEAD = 16;
    public static final int RI_ALPHA = 32;
    public static final int RI_LOWER = 64;
    public static final int RI_UPPER = 128;
    public static final int RI_WHITE = 256;
    public static final int CLASS_ALNUM = 0;
    public static final int CLASS_ALPHA = 1;
    public static final int CLASS_BLANK = 2;
    public static final int CLASS_CNTRL = 3;
    public static final int CLASS_DIGIT = 4;
    public static final int CLASS_GRAPH = 5;
    public static final int CLASS_LOWER = 6;
    public static final int CLASS_PRINT = 7;
    public static final int CLASS_PUNCT = 8;
    public static final int CLASS_SPACE = 9;
    public static final int CLASS_UPPER = 10;
    public static final int CLASS_XDIGIT = 11;
    public static final int CLASS_TAB = 12;
    public static final int CLASS_RETURN = 13;
    public static final int CLASS_BACKSPACE = 14;
    public static final int CLASS_ESCAPE = 15;
    public static final int CLASS_NONE = 99;

    public static boolean isMask(char ch, int mask, int test) {
        boolean res = false;
        switch (mask) {
            case 1: {
                res = CharacterClasses.isDigit(ch);
                break;
            }
            case 2: {
                res = CharacterClasses.isHex(ch);
                break;
            }
            case 4: {
                res = CharacterClasses.isOctal(ch);
                break;
            }
            case 8: {
                res = CharacterClasses.isWord(ch);
                break;
            }
            case 16: {
                res = CharacterClasses.isHead(ch);
                break;
            }
            case 32: {
                res = CharacterClasses.isAlpha(ch);
                break;
            }
            case 64: {
                res = CharacterClasses.isLower(ch);
                break;
            }
            case 128: {
                res = CharacterClasses.isUpper(ch);
                break;
            }
            case 256: {
                res = CharacterClasses.isWhite(ch);
            }
        }
        return res == test > 0;
    }

    public static boolean isDigit(char ch) {
        return Character.isDigit(ch);
    }

    public static boolean isHex(char ch) {
        return Character.digit(ch, 16) != -1;
    }

    public static boolean isOctal(char ch) {
        return Character.digit(ch, 8) != -1;
    }

    public static boolean isWord(char ch) {
        return Character.isLetterOrDigit(ch) || ch == '_';
    }

    public static boolean isHead(char ch) {
        return Character.isLetter(ch) || ch == '_';
    }

    public static boolean isAlpha(char ch) {
        return Character.isLetter(ch);
    }

    public static boolean isLower(char ch) {
        return Character.isLowerCase(ch);
    }

    public static boolean isUpper(char ch) {
        return Character.isUpperCase(ch);
    }

    public static boolean isWhite(char ch) {
        return Character.isWhitespace(ch);
    }

    public static boolean isGraph(char ch) {
        return ch >= '!' && ch <= '~';
    }

    public static boolean isPrint(char ch) {
        return ch >= ' ' && ch <= '~' || ch > '\u00ff';
    }

    public static boolean isPunct(char ch) {
        return ch >= '!' && ch <= '/' || ch >= ':' && ch <= '@' || ch >= '[' && ch <= '\'' || ch >= '{' && ch <= '~';
    }

    public static boolean isFile(char ch) {
        return CharacterClasses.isWord(ch) || "/.-+,#$%~=".indexOf(ch) != -1;
    }
}

