/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.regexp;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.maddyhome.idea.vim.helper.EditorHelper;
import com.maddyhome.idea.vim.helper.MessageHelper;
import com.maddyhome.idea.vim.regexp.CharPointer;
import com.maddyhome.idea.vim.regexp.CharacterClasses;
import com.maddyhome.idea.vim.regexp.Flags;
import com.maddyhome.idea.vim.regexp.Magic;

public class RegExp {
    public static reg_extmatch_T re_extmatch_out = null;
    public static reg_extmatch_T re_extmatch_in = null;
    private static final int END = 0;
    private static final int BOL = 1;
    private static final int EOL = 2;
    private static final int BRANCH = 3;
    private static final int BACK = 4;
    private static final int EXACTLY = 5;
    private static final int NOTHING = 6;
    private static final int STAR = 7;
    private static final int PLUS = 8;
    private static final int MATCH = 9;
    private static final int NOMATCH = 10;
    private static final int BEHIND = 11;
    private static final int NOBEHIND = 12;
    private static final int SUBPAT = 13;
    private static final int BRACE_SIMPLE = 14;
    private static final int BOW = 15;
    private static final int EOW = 16;
    private static final int BRACE_LIMITS = 17;
    private static final int NEWL = 18;
    private static final int BHPOS = 19;
    private static final int ADD_NL = 30;
    private static final int ANY = 20;
    private static final int FIRST_NL = 50;
    private static final int ANYOF = 21;
    private static final int ANYBUT = 22;
    private static final int IDENT = 23;
    private static final int SIDENT = 24;
    private static final int KWORD = 25;
    private static final int SKWORD = 26;
    private static final int FNAME = 27;
    private static final int SFNAME = 28;
    private static final int PRINT = 29;
    private static final int SPRINT = 30;
    private static final int WHITE = 31;
    private static final int NWHITE = 32;
    private static final int DIGIT = 33;
    private static final int NDIGIT = 34;
    private static final int HEX = 35;
    private static final int NHEX = 36;
    private static final int OCTAL = 37;
    private static final int NOCTAL = 38;
    private static final int WORD = 39;
    private static final int NWORD = 40;
    private static final int HEAD = 41;
    private static final int NHEAD = 42;
    private static final int ALPHA = 43;
    private static final int NALPHA = 44;
    private static final int LOWER = 45;
    private static final int NLOWER = 46;
    private static final int UPPER = 47;
    private static final int NUPPER = 48;
    private static final int LAST_NL = 78;
    private static final int MOPEN = 80;
    private static final int MCLOSE = 90;
    private static final int BACKREF = 100;
    private static final int ZOPEN = 110;
    private static final int ZCLOSE = 120;
    private static final int ZREF = 130;
    private static final int BRACE_COMPLEX = 140;
    private static final int NOPEN = 150;
    private static final int NCLOSE = 151;
    private static final int RE_BOF = 201;
    private static final int RE_EOF = 202;
    private static final int CURSOR = 203;
    private static final int RE_LNUM = 204;
    private static final int RE_COL = 205;
    private static final int RE_VCOL = 206;
    private static final int REGMAGIC = 156;
    private static final int REX_SET = 1;
    private static final int REX_USE = 2;
    private static final int MAX_LIMIT = Integer.MAX_VALUE;
    private static final int NOT_MULTI = 0;
    private static final int MULTI_ONE = 1;
    private static final int MULTI_MULT = 2;
    private static final int HASWIDTH = 1;
    private static final int SIMPLE = 2;
    private static final int SPSTART = 4;
    private static final int HASNL = 8;
    private static final int WORST = 0;
    private static final String REGEXP_INRANGE = "]^-n\\";
    private static final String REGEXP_ABBR = "nrteb";
    private static final int RF_ICASE = 1;
    private static final int RF_NOICASE = 2;
    private static final int RF_HASNL = 4;
    private static final int NSUBEXP = 10;
    private static final int MAGIC_NONE = 1;
    private static final int MAGIC_OFF = 2;
    private static final int MAGIC_ON = 3;
    private static final int MAGIC_ALL = 4;
    private static final int[] META_flags = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 0, 1, 1, 1, 0, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1};
    private static final int REG_NOPAREN = 0;
    private static final int REG_PAREN = 1;
    private static final int REG_ZPAREN = 2;
    private static final int REG_NPAREN = 3;
    private int reg_do_extmatch = 0;
    private CharPointer reg_prev_sub = null;
    private CharPointer regparse;
    private int prevchr_len;
    private int num_complex_braces;
    private int regnpar;
    private int regnzpar;
    private char re_has_z;
    private CharPointer regcode;
    private boolean[] had_endbrace = new boolean[10];
    private int regflags;
    private int[] brace_min = new int[10];
    private int[] brace_max = new int[10];
    private int[] brace_count = new int[10];
    private boolean had_eol;
    private boolean one_exactly = false;
    private int reg_magic;
    private int curchr;
    private int prevprevchr;
    private int prevchr;
    private int nextchr;
    private boolean at_start;
    private boolean prev_at_start;
    private int reglnum;
    private CharPointer regline;
    private CharPointer reginput;
    private boolean need_clear_subexpr;
    private boolean need_clear_zsubexpr = false;
    private boolean out_of_stack;
    private boolean ireg_ic;
    private CharPointer reg_tofree;
    private regmatch_T reg_match;
    private regmmatch_T reg_mmatch;
    private CharPointer[] reg_startp = new CharPointer[10];
    private CharPointer[] reg_endp = new CharPointer[10];
    private lpos_T[] reg_startpos = new lpos_T[10];
    private lpos_T[] reg_endpos = new lpos_T[10];
    private Editor reg_buf;
    private int reg_firstlnum;
    private int reg_maxline;
    private regsave_T behind_pos;
    private CharPointer[] reg_startzp = new CharPointer[10];
    private CharPointer[] reg_endzp = new CharPointer[10];
    private lpos_T[] reg_startzpos = new lpos_T[10];
    private lpos_T[] reg_endzpos = new lpos_T[10];
    private boolean got_int = false;
    private int bl_minval;
    private int bl_maxval;
    private static Logger logger = Logger.getInstance((String)RegExp.class.getName());

    private static boolean WITH_NL(int op) {
        return op >= 50 && op <= 78;
    }

    private void EMSG_RET_null(String key) {
        MessageHelper.EMSG(key);
    }

    private void EMSG_M_RET_null(String key, boolean isMagic) {
        MessageHelper.EMSG(key, isMagic ? "" : "\\");
    }

    private void EMSG_ONE_RET_null() {
        this.EMSG_M_RET_null("E369", this.reg_magic == 4);
    }

    private int re_multi_type(int c) {
        if (c == -192 || c == -195 || c == -193) {
            return 1;
        }
        if (c == -214 || c == -213 || c == -133) {
            return 2;
        }
        return 0;
    }

    private int backslash_trans(int c) {
        switch (c) {
            case 114: {
                return 13;
            }
            case 116: {
                return 9;
            }
            case 101: {
                return 27;
            }
            case 98: {
                return 8;
            }
        }
        return c;
    }

    private static int skip_class_name(CharPointer pp) {
        if (pp.charAt(1) == ':') {
            for (int i = 0; i < CharacterClasses.CLASS_NAMES.length; ++i) {
                if (pp.ref(2).strncmp(CharacterClasses.CLASS_NAMES[i], CharacterClasses.CLASS_NAMES[i].length()) != 0) continue;
                pp.inc(CharacterClasses.CLASS_NAMES[i].length() + 2);
                return i;
            }
        }
        return 99;
    }

    private static CharPointer skip_anyof(CharPointer p) {
        if (p.charAt() == '^') {
            p.inc();
        }
        if (p.charAt() == ']' || p.charAt() == '-') {
            p.inc();
        }
        while (!p.end() && p.charAt() != ']') {
            if (p.charAt() == '-') {
                p.inc();
                if (p.end() || p.charAt() == ']') continue;
                p.inc();
                continue;
            }
            if (p.charAt() == '\\' && (REGEXP_INRANGE.indexOf(p.charAt(1)) != -1 || REGEXP_ABBR.indexOf(p.charAt(1)) != -1)) {
                p.inc(2);
                continue;
            }
            if (p.charAt() == '[') {
                if (RegExp.skip_class_name(p) != 99) continue;
                p.inc();
                continue;
            }
            p.inc();
        }
        return p;
    }

    public int re_multiline(regprog_T prog) {
        return prog.regflags & 4;
    }

    public static CharPointer skip_regexp(CharPointer p, char dirc, boolean magic) {
        int mymagic = magic ? 3 : 2;
        while (!p.end() && p.charAt() != dirc) {
            if (p.charAt() == '[' && mymagic >= 3 || p.charAt() == '\\' && p.charAt(1) == '[' && mymagic <= 2) {
                if ((p = RegExp.skip_anyof(p.ref(1))).end()) {
                    break;
                }
            } else if (p.charAt() == '\\' && p.charAt(1) != '\u0000') {
                p.inc();
                if (p.charAt() == 'v') {
                    mymagic = 4;
                } else if (p.charAt() == 'V') {
                    mymagic = 1;
                }
            }
            p.inc();
        }
        return p;
    }

    public regprog_T vim_regcomp(String expr, int magic) {
        Flags flags = new Flags();
        if (expr == null) {
            MessageHelper.EMSG("e_null");
            return null;
        }
        regprog_T r = new regprog_T();
        r.program = new StringBuffer();
        this.regcomp_start(expr, magic);
        this.regcode = new CharPointer(r.program);
        this.regc(156);
        if (this.reg(0, flags) == null) {
            return null;
        }
        r.regstart = '\u0000';
        r.reganch = '\u0000';
        r.regmust = null;
        r.regmlen = 0;
        r.regflags = this.regflags;
        if (flags.isSet(8)) {
            r.regflags |= 4;
        }
        r.reghasz = this.re_has_z;
        CharPointer scan = new CharPointer(r.program).ref(1);
        if (this.regnext(scan).OP() == 0) {
            if ((scan = scan.OPERAND()).OP() == 1 || scan.OP() == 201) {
                r.reganch = (char)(r.reganch + '\u0001');
                scan = this.regnext(scan);
            }
            if (scan.OP() == 5) {
                r.regstart = scan.OPERAND().charAt();
            } else if ((scan.OP() == 15 || scan.OP() == 16 || scan.OP() == 6 || scan.OP() == 80 || scan.OP() == 150 || scan.OP() == 90 || scan.OP() == 151) && this.regnext(scan).OP() == 5) {
                r.regstart = this.regnext(scan).OPERAND().charAt();
            }
            if ((flags.isSet(4) || scan.OP() == 15 || scan.OP() == 16) && !flags.isSet(8)) {
                CharPointer longest = null;
                int len = 0;
                while (scan != null) {
                    CharPointer so = scan.OPERAND();
                    if (scan.OP() == 5 && so.strlen() >= len) {
                        longest = so.ref(0);
                        len = so.strlen();
                    }
                    scan = this.regnext(scan);
                }
                if (longest != null) {
                    r.regmust = longest.ref(0);
                }
                r.regmlen = len;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.regdump(expr, r));
        }
        return r;
    }

    private void regcomp_start(String expr, int magic) {
        this.initchr(expr);
        this.reg_magic = magic != 0 ? 3 : 2;
        this.num_complex_braces = 0;
        this.regnpar = 1;
        for (int i = 0; i < this.had_endbrace.length; ++i) {
            this.had_endbrace[i] = false;
        }
        this.regnzpar = 1;
        this.re_has_z = '\u0000';
        this.regflags = 0;
        this.had_eol = false;
    }

    public boolean vim_regcomp_had_eol() {
        return this.had_eol;
    }

    private CharPointer reg(int paren, Flags flagp) {
        CharPointer ret;
        int parno = 0;
        Flags flags = new Flags();
        flagp.init(1);
        if (paren == 2) {
            if (this.regnzpar >= 10) {
                MessageHelper.EMSG("E50");
                return null;
            }
            parno = this.regnzpar++;
            ret = this.regnode(110 + parno);
        } else if (paren == 1) {
            if (this.regnpar >= 10) {
                this.EMSG_M_RET_null("E51", this.reg_magic == 4);
                return null;
            }
            parno = this.regnpar++;
            ret = this.regnode(80 + parno);
        } else {
            ret = paren == 3 ? this.regnode(150) : null;
        }
        CharPointer br = this.regbranch(flags);
        if (br == null) {
            return null;
        }
        if (ret != null) {
            this.regtail(ret, br);
        } else {
            ret = br.ref(0);
        }
        if (!flags.isSet(1)) {
            flagp.unset(1);
        }
        flagp.set(flags.get() & 0xC);
        while (this.peekchr() == -132) {
            this.skipchr();
            br = this.regbranch(flags);
            if (br == null) {
                return null;
            }
            this.regtail(ret, br);
            if (!flags.isSet(1)) {
                flagp.unset(1);
            }
            flagp.set(flags.get() & 0xC);
        }
        CharPointer ender = this.regnode(paren == 2 ? 120 + parno : (paren == 1 ? 90 + parno : (paren == 3 ? 151 : 0)));
        this.regtail(ret, ender);
        br = ret.ref(0);
        while (br != null) {
            this.regoptail(br, ender);
            br = this.regnext(br);
        }
        if (paren != 0 && this.getchr() != -215) {
            if (paren == 2) {
                MessageHelper.EMSG("E52");
                return null;
            }
            if (paren == 3) {
                this.EMSG_M_RET_null("E53", this.reg_magic == 4);
                return null;
            }
            this.EMSG_M_RET_null("E54", this.reg_magic == 4);
            return null;
        }
        if (paren == 0 && this.peekchr() != 0) {
            if (this.curchr == -216) {
                this.EMSG_M_RET_null("E55", this.reg_magic == 4);
                return null;
            }
            MessageHelper.EMSG("e_trailing");
            return null;
        }
        if (paren == 1) {
            this.had_endbrace[parno] = true;
        }
        return ret;
    }

    private CharPointer regbranch(Flags flagp) {
        CharPointer chain = null;
        Flags flags = new Flags();
        flagp.init(8);
        CharPointer ret = this.regnode(3);
        while (true) {
            CharPointer latest;
            if ((latest = this.regconcat(flags)) == null) {
                return null;
            }
            flagp.set(flags.get() & 5);
            flagp.set(flagp.get() & (0xFFFFFFF7 | flags.get() & 8));
            if (chain != null) {
                this.regtail(chain, latest);
            }
            if (this.peekchr() != -218) break;
            this.skipchr();
            this.regtail(latest, this.regnode(0));
            this.reginsert(9, latest.ref(0));
            chain = latest.ref(0);
        }
        return ret;
    }

    private CharPointer regconcat(Flags flagp) {
        CharPointer first = null;
        CharPointer chain = null;
        Flags flags = new Flags();
        boolean cont = true;
        flagp.init(0);
        block9: while (cont) {
            switch (this.peekchr()) {
                case -218: 
                case -215: 
                case -132: 
                case 0: {
                    cont = false;
                    continue block9;
                }
                case -157: {
                    this.regflags |= 1;
                    this.skipchr_keepstart();
                    continue block9;
                }
                case -189: {
                    this.regflags |= 2;
                    this.skipchr_keepstart();
                    continue block9;
                }
                case -138: {
                    this.reg_magic = 4;
                    this.skipchr_keepstart();
                    this.curchr = -1;
                    continue block9;
                }
                case -147: {
                    this.reg_magic = 3;
                    this.skipchr_keepstart();
                    this.curchr = -1;
                    continue block9;
                }
                case -179: {
                    this.reg_magic = 2;
                    this.skipchr_keepstart();
                    this.curchr = -1;
                    continue block9;
                }
                case -170: {
                    this.reg_magic = 1;
                    this.skipchr_keepstart();
                    this.curchr = -1;
                    continue block9;
                }
            }
            CharPointer latest = this.regpiece(flags);
            if (latest == null) {
                return null;
            }
            flagp.set(flags.get() & 9);
            if (chain == null) {
                flagp.set(flags.get() & 4);
            } else {
                this.regtail(chain, latest);
            }
            chain = latest.ref(0);
            if (first != null) continue;
            first = latest.ref(0);
        }
        if (first == null) {
            first = this.regnode(6);
        }
        return first;
    }

    private CharPointer regpiece(Flags flagp) {
        Flags flags = new Flags();
        CharPointer ret = this.regatom(flags);
        if (ret == null) {
            return null;
        }
        int op = this.peekchr();
        if (this.re_multi_type(op) == 0) {
            flagp.init(flags.get());
            return ret;
        }
        if (!flags.isSet(1) && this.re_multi_type(op) == 2) {
            if (op == -214) {
                this.EMSG_M_RET_null("E56", this.reg_magic >= 3);
                return null;
            }
            if (op == -213) {
                this.EMSG_M_RET_null("E57", this.reg_magic == 4);
                return null;
            }
        }
        flagp.init(4 | flags.get() & 8);
        this.skipchr();
        switch (op) {
            case -214: {
                if (flags.isSet(2)) {
                    this.reginsert(7, ret.ref(0));
                    break;
                }
                this.reginsert(3, ret.ref(0));
                this.regoptail(ret, this.regnode(4));
                this.regoptail(ret, ret);
                this.regtail(ret, this.regnode(3));
                this.regtail(ret, this.regnode(6));
                break;
            }
            case -213: {
                if (flags.isSet(2)) {
                    this.reginsert(8, ret.ref(0));
                } else {
                    CharPointer next = this.regnode(3);
                    this.regtail(ret, next);
                    this.regtail(this.regnode(4), ret);
                    this.regtail(next, this.regnode(3));
                    this.regtail(ret, this.regnode(6));
                }
                flagp.init(1 | flags.get() & 8);
                break;
            }
            case -192: {
                int lop = 0;
                block7 : switch (Magic.no_Magic(this.getchr())) {
                    case 61: {
                        lop = 9;
                        break;
                    }
                    case 33: {
                        lop = 10;
                        break;
                    }
                    case 62: {
                        lop = 13;
                        break;
                    }
                    case 60: {
                        switch (Magic.no_Magic(this.getchr())) {
                            case 61: {
                                lop = 11;
                                break block7;
                            }
                            case 33: {
                                lop = 12;
                            }
                        }
                    }
                }
                if (lop == 0) {
                    this.EMSG_M_RET_null("E59", this.reg_magic == 4);
                    return null;
                }
                if (lop == 11 || lop == 12) {
                    this.regtail(ret, this.regnode(19));
                }
                this.regtail(ret, this.regnode(0));
                this.reginsert(lop, ret.ref(0));
                break;
            }
            case -195: 
            case -193: {
                this.reginsert(3, ret.ref(0));
                this.regtail(ret, this.regnode(3));
                CharPointer next = this.regnode(6);
                this.regtail(ret, next);
                this.regoptail(ret, next);
                break;
            }
            case -133: {
                MinMax limits = this.read_limits();
                if (limits == null) {
                    return null;
                }
                int maxval = limits.maxvalue;
                int minval = limits.minvalue;
                if (!flags.isSet(1) && (maxval > minval ? maxval >= Integer.MAX_VALUE : minval >= Integer.MAX_VALUE)) {
                    this.EMSG_M_RET_null("E58", this.reg_magic == 4);
                    return null;
                }
                if (flags.isSet(2)) {
                    this.reginsert(14, ret.ref(0));
                    this.reginsert_limits(17, minval, maxval, ret.ref(0));
                } else {
                    if (this.num_complex_braces >= 10) {
                        this.EMSG_M_RET_null("E60", this.reg_magic == 4);
                        return null;
                    }
                    this.reginsert(140 + this.num_complex_braces, ret.ref(0));
                    this.regoptail(ret, this.regnode(4));
                    this.regoptail(ret, ret);
                    this.reginsert_limits(17, minval, maxval, ret.ref(0));
                    ++this.num_complex_braces;
                }
                if (minval <= 0 || maxval <= 0) break;
                flagp.init(1 | flags.get() & 8);
            }
        }
        if (this.re_multi_type(this.peekchr()) != 0) {
            if (this.peekchr() == -214) {
                MessageHelper.EMSG("E61", this.reg_magic >= 3 ? "" : "\\");
            } else {
                MessageHelper.EMSG("E62", this.reg_magic >= 3 ? "" : "\\", Character.toString((char)Magic.no_Magic(this.peekchr())));
            }
            return null;
        }
        return ret;
    }

    private CharPointer regatom(Flags flagp) {
        CharPointer ret = null;
        Flags flags = new Flags();
        boolean cpo_lit = false;
        String classchars = ".iIkKfFpPsSdDxXoOwWhHaAlLuU";
        int[] classcodes = new int[]{20, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48};
        int extra = 0;
        flagp.init(0);
        int c = this.getchr();
        boolean doCollection = false;
        boolean doDefault = false;
        block0 : switch (c) {
            case -162: {
                ret = this.regnode(1);
                break;
            }
            case -220: {
                ret = this.regnode(2);
                this.had_eol = true;
                break;
            }
            case -196: {
                ret = this.regnode(15);
                break;
            }
            case -194: {
                ret = this.regnode(16);
                break;
            }
            case -161: {
                c = Magic.no_Magic(this.getchr());
                if (c == 94) {
                    ret = this.regnode(1);
                    break;
                }
                if (c == 36) {
                    ret = this.regnode(2);
                    this.had_eol = true;
                    break;
                }
                extra = 30;
                flagp.set(8);
                if (c == 91) {
                    doCollection = true;
                }
            }
            case -210: 
            case -191: 
            case -188: 
            case -186: 
            case -184: 
            case -183: 
            case -181: 
            case -180: 
            case -177: 
            case -176: 
            case -173: 
            case -171: 
            case -169: 
            case -168: 
            case -159: 
            case -156: 
            case -154: 
            case -152: 
            case -151: 
            case -149: 
            case -148: 
            case -145: 
            case -144: 
            case -141: 
            case -139: 
            case -137: 
            case -136: {
                int i = classchars.indexOf(Magic.no_Magic(c));
                if (i == -1) {
                    MessageHelper.EMSG("E63");
                    return null;
                }
                ret = this.regnode(classcodes[i] + extra);
                flagp.set(3);
                break;
            }
            case -146: {
                ret = this.regnode(18);
                flagp.set(9);
                break;
            }
            case -216: {
                if (this.one_exactly) {
                    this.EMSG_ONE_RET_null();
                    return null;
                }
                ret = this.reg(1, flags);
                if (ret == null) {
                    return null;
                }
                flagp.set(flags.get() & 0xD);
                break;
            }
            case -218: 
            case -215: 
            case -132: 
            case 0: {
                this.EMSG_RET_null("e_internal");
                return null;
            }
            case -214: 
            case -213: 
            case -195: 
            case -193: 
            case -192: 
            case -133: {
                c = Magic.no_Magic(c);
                MessageHelper.EMSG("E64", (c == 42 ? this.reg_magic >= 3 : this.reg_magic == 4) ? "" : "\\", Character.toString((char)c));
                return null;
            }
            case -130: {
                if (this.reg_prev_sub != null) {
                    ret = this.regnode(5);
                    CharPointer lp = this.reg_prev_sub.ref(0);
                    while (!lp.isNul()) {
                        this.regc(lp.charAt());
                    }
                    lp.inc();
                    this.regc(0);
                    if (this.reg_prev_sub.isNul()) break;
                    flagp.set(1);
                    if (lp.pointer() - this.reg_prev_sub.pointer() != 1) break;
                    flagp.set(2);
                    break;
                }
                MessageHelper.EMSG("e_nopresub");
                return null;
            }
            case -207: 
            case -206: 
            case -205: 
            case -204: 
            case -203: 
            case -202: 
            case -201: 
            case -200: 
            case -199: {
                int refnum = c - -208;
                if (!this.had_endbrace[refnum]) {
                    CharPointer p = this.regparse.ref(0);
                    while (!p.isNul() && (p.charAt(0) != '@' || p.charAt(1) != '<' || p.charAt(2) != '!' && p.charAt(2) != '=')) {
                        p.inc();
                    }
                    if (p.isNul()) {
                        this.EMSG_RET_null("E65");
                        return null;
                    }
                }
                ret = this.regnode(100 + refnum);
                break;
            }
            case -134: {
                c = Magic.no_Magic(this.getchr());
                switch (c) {
                    case 40: {
                        if (this.reg_do_extmatch != 1) {
                            MessageHelper.EMSG("E66");
                            return null;
                        }
                        if (this.one_exactly) {
                            this.EMSG_ONE_RET_null();
                            return null;
                        }
                        ret = this.reg(2, flags);
                        if (ret == null) {
                            return null;
                        }
                        flagp.set(flags.get() & 0xD);
                        this.re_has_z = '\u0001';
                        break block0;
                    }
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        if (this.reg_do_extmatch != 2) {
                            MessageHelper.EMSG("E67");
                            return null;
                        }
                        ret = this.regnode(130 + c - 48);
                        this.re_has_z = (char)2;
                        break block0;
                    }
                    case 115: {
                        ret = this.regnode(80);
                        break block0;
                    }
                    case 101: {
                        ret = this.regnode(90);
                        break block0;
                    }
                }
                MessageHelper.EMSG("E68");
                return null;
            }
            case -219: {
                c = Magic.no_Magic(this.getchr());
                switch (c) {
                    case 40: {
                        if (this.one_exactly) {
                            this.EMSG_ONE_RET_null();
                            return null;
                        }
                        ret = this.reg(3, flags);
                        if (ret == null) {
                            return null;
                        }
                        flagp.set(flags.get() & 0xD);
                        break block0;
                    }
                    case 94: {
                        ret = this.regnode(201);
                        break block0;
                    }
                    case 36: {
                        ret = this.regnode(202);
                        break block0;
                    }
                    case 35: {
                        ret = this.regnode(203);
                        break block0;
                    }
                    case 91: {
                        CharPointer br;
                        if (this.one_exactly) {
                            this.EMSG_ONE_RET_null();
                            return null;
                        }
                        CharPointer lastnode = null;
                        ret = null;
                        while ((c = this.getchr()) != 93) {
                            if (c == 0) {
                                this.EMSG_M_RET_null("E69", this.reg_magic == 4);
                                return null;
                            }
                            br = this.regnode(3);
                            if (ret == null) {
                                ret = br.ref(0);
                            } else {
                                this.regtail(lastnode, br);
                            }
                            this.ungetchr();
                            this.one_exactly = true;
                            lastnode = this.regatom(flagp);
                            this.one_exactly = false;
                            if (lastnode != null) continue;
                            return null;
                        }
                        if (ret == null) {
                            this.EMSG_M_RET_null("E70", this.reg_magic == 4);
                            return null;
                        }
                        CharPointer lastbranch = this.regnode(3);
                        br = this.regnode(6);
                        this.regtail(lastnode, br);
                        this.regtail(lastbranch, br);
                        br = ret.ref(0);
                        while (br != lastnode) {
                            if (br.OP() == 3) {
                                this.regtail(br, lastbranch);
                                br = br.OPERAND();
                                continue;
                            }
                            br = this.regnext(br);
                        }
                        flagp.unset(1);
                        break block0;
                    }
                }
                if (Character.isDigit((char)c) || c == 60 || c == 62) {
                    int n = 0;
                    int cmp = c;
                    if (cmp == 60 || cmp == 62) {
                        c = this.getchr();
                    }
                    while (Character.isDigit((char)c)) {
                        n = n * 10 + (c - 48);
                        c = this.getchr();
                    }
                    if (c == 108 || c == 99 || c == 118) {
                        ret = c == 108 ? this.regnode(204) : (c == 99 ? this.regnode(205) : this.regnode(206));
                        this.regcode = this.re_put_long(this.regcode.ref(0), n);
                        this.regcode.set((char)cmp).inc();
                        break;
                    }
                }
                this.EMSG_M_RET_null("E71", this.reg_magic == 4);
                return null;
            }
            case -165: {
                doCollection = true;
                break;
            }
            default: {
                doDefault = true;
            }
        }
        if (doCollection) {
            CharPointer lp = RegExp.skip_anyof(this.regparse.ref(0));
            if (lp.charAt() == ']') {
                int startc = -1;
                if (this.regparse.charAt() == '^') {
                    ret = this.regnode(22 + extra);
                    this.regparse.inc();
                } else {
                    ret = this.regnode(21 + extra);
                }
                if (this.regparse.charAt() == ']' || this.regparse.charAt() == '-') {
                    this.regc(this.regparse.charAt());
                    this.regparse.inc();
                }
                while (!this.regparse.isNul() && this.regparse.charAt() != ']') {
                    if (this.regparse.charAt() == '-') {
                        this.regparse.inc();
                        if (this.regparse.isNul() || this.regparse.charAt() == ']' || startc == -1 || this.regparse.charAt(0) == '\\' && this.regparse.charAt(1) == 'n') {
                            this.regc(45);
                            startc = 45;
                            continue;
                        }
                        int endc = this.regparse.charAt();
                        this.regparse.inc();
                        if (startc > endc) {
                            MessageHelper.EMSG("e_invrange");
                            return null;
                        }
                        while (++startc <= endc) {
                            this.regc(startc);
                        }
                        startc = -1;
                        continue;
                    }
                    if (this.regparse.charAt() == '\\' && (REGEXP_INRANGE.indexOf(this.regparse.charAt(1)) != -1 || !cpo_lit && REGEXP_ABBR.indexOf(this.regparse.charAt(1)) != -1)) {
                        this.regparse.inc();
                        if (this.regparse.charAt() == 'n') {
                            if (ret.charAt() == '\u0016') {
                                ret.set('4');
                            } else if (ret.charAt() == '\u0015') {
                                ret.set('3');
                            }
                            flagp.set(8);
                            this.regparse.inc();
                            startc = -1;
                            continue;
                        }
                        startc = this.backslash_trans(this.regparse.charAt());
                        this.regparse.inc();
                        this.regc(startc);
                        continue;
                    }
                    if (this.regparse.charAt() == '[') {
                        int c_class = RegExp.skip_class_name(this.regparse);
                        startc = -1;
                        switch (c_class) {
                            case 99: {
                                startc = this.regparse.charAt();
                                this.regparse.inc();
                                this.regc(startc);
                                break;
                            }
                            case 0: {
                                int cu;
                                for (cu = 1; cu <= 255; ++cu) {
                                    if (!Character.isLetterOrDigit((char)cu)) continue;
                                    this.regc(cu);
                                }
                                break;
                            }
                            case 1: {
                                int cu;
                                for (cu = 1; cu <= 255; ++cu) {
                                    if (!Character.isLetter((char)cu)) continue;
                                    this.regc(cu);
                                }
                                break;
                            }
                            case 2: {
                                this.regc(32);
                                this.regc(9);
                                break;
                            }
                            case 3: {
                                int cu;
                                for (cu = 1; cu <= 255; ++cu) {
                                    if (!Character.isISOControl((char)cu)) continue;
                                    this.regc(cu);
                                }
                                break;
                            }
                            case 4: {
                                int cu;
                                for (cu = 1; cu <= 255; ++cu) {
                                    if (!Character.isDigit((char)cu)) continue;
                                    this.regc(cu);
                                }
                                break;
                            }
                            case 5: {
                                int cu;
                                for (cu = 1; cu <= 255; ++cu) {
                                    if (!CharacterClasses.isGraph((char)cu)) continue;
                                    this.regc(cu);
                                }
                                break;
                            }
                            case 6: {
                                int cu;
                                for (cu = 1; cu <= 255; ++cu) {
                                    if (!Character.isLowerCase((char)cu)) continue;
                                    this.regc(cu);
                                }
                                break;
                            }
                            case 7: {
                                int cu;
                                for (cu = 1; cu <= 255; ++cu) {
                                    if (!CharacterClasses.isPrint((char)cu)) continue;
                                    this.regc(cu);
                                }
                                break;
                            }
                            case 8: {
                                int cu;
                                for (cu = 1; cu <= 255; ++cu) {
                                    if (!CharacterClasses.isPunct((char)cu)) continue;
                                    this.regc(cu);
                                }
                                break;
                            }
                            case 9: {
                                int cu;
                                for (cu = 9; cu <= 13; ++cu) {
                                    this.regc(cu);
                                }
                                this.regc(32);
                                break;
                            }
                            case 10: {
                                int cu;
                                for (cu = 1; cu <= 255; ++cu) {
                                    if (!Character.isUpperCase((char)cu)) continue;
                                    this.regc(cu);
                                }
                                break;
                            }
                            case 11: {
                                int cu;
                                for (cu = 1; cu <= 255; ++cu) {
                                    if (!CharacterClasses.isHex((char)cu)) continue;
                                    this.regc(cu);
                                }
                                break;
                            }
                            case 12: {
                                this.regc(9);
                                break;
                            }
                            case 13: {
                                this.regc(13);
                                break;
                            }
                            case 14: {
                                this.regc(8);
                                break;
                            }
                            case 15: {
                                this.regc(27);
                            }
                        }
                        continue;
                    }
                    startc = this.regparse.charAt();
                    this.regparse.inc();
                    this.regc(startc);
                }
                this.regc(0);
                this.prevchr_len = 1;
                if (this.regparse.charAt() != ']') {
                    MessageHelper.EMSG("e_toomsbra");
                    return null;
                }
                this.skipchr();
                flagp.set(3);
            } else {
                doDefault = true;
            }
        }
        if (doDefault) {
            int len;
            ret = this.regnode(5);
            for (len = 0; c != 0 && (len == 0 || this.re_multi_type(this.peekchr()) == 0 && !this.one_exactly && !Magic.is_Magic(c)); ++len) {
                c = Magic.no_Magic(c);
                this.regc(c);
                c = this.getchr();
            }
            this.ungetchr();
            this.regc(0);
            flagp.set(1);
            if (len == 1) {
                flagp.set(2);
            }
        }
        return ret;
    }

    private CharPointer regnode(int op) {
        CharPointer ret = this.regcode.ref(0);
        this.regcode.set((char)op).inc();
        this.regcode.set('\u0000').inc();
        this.regcode.set('\u0000').inc();
        return ret;
    }

    private void regc(int b) {
        this.regcode.set((char)b).inc();
    }

    private void reginsert(int op, CharPointer opnd) {
        CharPointer src = this.regcode.ref(0);
        this.regcode.inc(3);
        CharPointer dst = this.regcode.ref(0);
        while (src.pointer() > opnd.pointer()) {
            dst.dec().set(src.dec().charAt());
        }
        CharPointer place = opnd.ref(0);
        place.set((char)op).inc();
        place.set('\u0000').inc();
        place.set('\u0000');
    }

    private void reginsert_limits(int op, int minval, int maxval, CharPointer opnd) {
        CharPointer src = this.regcode.ref(0);
        this.regcode.inc(11);
        CharPointer dst = this.regcode.ref(0);
        while (src.pointer() > opnd.pointer()) {
            dst.dec().set(src.dec().charAt());
        }
        CharPointer place = opnd.ref(0);
        place.set((char)op).inc();
        place.set('\u0000').inc();
        place.set('\u0000').inc();
        place = this.re_put_long(place.ref(0), minval);
        place = this.re_put_long(place.ref(0), maxval);
        this.regtail(opnd, place);
    }

    private CharPointer re_put_long(CharPointer p, int val) {
        p.set((char)(val >> 24 & 0xFF)).inc();
        p.set((char)(val >> 16 & 0xFF)).inc();
        p.set((char)(val >> 8 & 0xFF)).inc();
        p.set((char)(val & 0xFF)).inc();
        return p;
    }

    private void regtail(CharPointer p, CharPointer val) {
        CharPointer temp;
        CharPointer scan = p.ref(0);
        while ((temp = this.regnext(scan)) != null) {
            scan = temp;
        }
        int offset = scan.OP() == 4 ? scan.pointer() - val.pointer() : val.pointer() - scan.pointer();
        scan.ref(1).set((char)((char)offset >> 8 & 0xFF));
        scan.ref(2).set((char)(offset & 0xFF));
    }

    private void regoptail(CharPointer p, CharPointer val) {
        if (p == null || p.OP() != 3 && (p.OP() < 140 || p.OP() > 149)) {
            return;
        }
        this.regtail(p.OPERAND(), val);
    }

    private void initchr(String str) {
        this.regparse = new CharPointer(str);
        this.prevchr_len = 0;
        this.nextchr = -1;
        this.prevchr = -1;
        this.prevprevchr = -1;
        this.curchr = -1;
        this.at_start = true;
        this.prev_at_start = false;
    }

    private int peekchr() {
        if (this.curchr == -1) {
            char c = this.regparse.charAt(0);
            this.curchr = c;
            switch (c) {
                case '.': 
                case '[': 
                case '~': {
                    if (this.reg_magic < 3) break;
                    this.curchr = Magic.Magic(this.curchr);
                    break;
                }
                case '!': 
                case '\"': 
                case '#': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '+': 
                case ',': 
                case '-': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '`': 
                case '{': 
                case '|': {
                    if (this.reg_magic != 4) break;
                    this.curchr = Magic.Magic(this.curchr);
                    break;
                }
                case '*': {
                    if (this.reg_magic < 3 || this.at_start || this.prev_at_start && this.prevchr == -162) break;
                    this.curchr = -214;
                    break;
                }
                case '^': {
                    if (this.reg_magic < 2 || !this.at_start && this.reg_magic != 4 && this.prevchr != -216 && this.prevchr != -132 && this.prevchr != -218 && this.prevchr != -146 && (Magic.no_Magic(this.prevchr) != 40 || this.prevprevchr != -219)) break;
                    this.curchr = -162;
                    this.at_start = true;
                    this.prev_at_start = false;
                    break;
                }
                case '$': {
                    if (this.reg_magic < 2) break;
                    CharPointer p = this.regparse.ref(1);
                    while (p.charAt(0) == '\\' && (p.charAt(1) == 'c' || p.charAt(1) == 'C' || p.charAt(1) == 'm' || p.charAt(1) == 'M')) {
                        p.inc(2);
                    }
                    if (p.charAt(0) != '\u0000' && (p.charAt(0) != '\\' || p.charAt(1) != '|' && p.charAt(1) != '&' && p.charAt(1) != ')' && p.charAt(1) != 'n') && this.reg_magic != 4) break;
                    this.curchr = -220;
                    break;
                }
                case '\\': {
                    char c2 = this.regparse.charAt(1);
                    if (c2 == '\u0000') {
                        this.curchr = 92;
                        break;
                    }
                    if (c2 <= '~' && META_flags[c2] != 0) {
                        this.curchr = -1;
                        this.prev_at_start = this.at_start;
                        this.at_start = false;
                        this.regparse.inc();
                        this.peekchr();
                        this.regparse.dec();
                        this.curchr = Magic.toggle_Magic(this.curchr);
                        break;
                    }
                    if (REGEXP_ABBR.indexOf(c2) != -1) {
                        this.curchr = this.backslash_trans(c2);
                        break;
                    }
                    if (this.reg_magic == 1 && (c2 == '$' || c2 == '^')) {
                        this.curchr = Magic.toggle_Magic(c2);
                        break;
                    }
                    this.curchr = c2;
                    break;
                }
            }
        }
        return this.curchr;
    }

    private void skipchr() {
        this.prevchr_len = this.regparse.charAt() == '\\' ? 1 : 0;
        if (this.regparse.charAt(this.prevchr_len) != '\u0000') {
            ++this.prevchr_len;
        }
        this.regparse.inc(this.prevchr_len);
        this.prev_at_start = this.at_start;
        this.at_start = false;
        this.prevprevchr = this.prevchr;
        this.prevchr = this.curchr;
        this.curchr = this.nextchr;
        this.nextchr = -1;
    }

    private void skipchr_keepstart() {
        boolean as = this.prev_at_start;
        int pr = this.prevchr;
        int prpr = this.prevprevchr;
        this.skipchr();
        this.at_start = as;
        this.prevchr = pr;
        this.prevprevchr = prpr;
    }

    private int getchr() {
        int chr = this.peekchr();
        this.skipchr();
        return chr;
    }

    private void ungetchr() {
        this.nextchr = this.curchr;
        this.curchr = this.prevchr;
        this.prevchr = this.prevprevchr;
        this.at_start = this.prev_at_start;
        this.prev_at_start = false;
        this.regparse.dec(this.prevchr_len);
    }

    private MinMax read_limits() {
        boolean reverse = false;
        if (this.regparse.charAt() == '-') {
            this.regparse.inc();
            reverse = true;
        }
        CharPointer first_char = this.regparse.ref(0);
        int minval = this.getdigits(this.regparse);
        int maxval = this.regparse.charAt() == ',' ? (CharacterClasses.isDigit(this.regparse.inc().charAt()) ? this.getdigits(this.regparse) : Integer.MAX_VALUE) : (CharacterClasses.isDigit(first_char.charAt()) ? minval : Integer.MAX_VALUE);
        if (this.regparse.charAt() == '\\') {
            this.regparse.inc();
        }
        if (this.regparse.charAt() != '}' || maxval == 0 && minval == 0) {
            MessageHelper.EMSG("synerror", this.reg_magic == 4 ? "" : "\\");
            return null;
        }
        if (!reverse && minval > maxval || reverse && minval < maxval) {
            int tmp = minval;
            minval = maxval;
            maxval = tmp;
        }
        this.skipchr();
        MinMax res = new MinMax();
        res.maxvalue = maxval;
        res.minvalue = minval;
        return res;
    }

    private int getdigits(CharPointer p) {
        int res = 0;
        boolean neg = false;
        if (p.charAt() == '-') {
            neg = true;
            p.inc();
        }
        while (CharacterClasses.isDigit(p.charAt())) {
            res = res * 10 + Character.digit(p.charAt(), 10);
            p.inc();
        }
        if (neg) {
            res = -res;
        }
        return res;
    }

    private CharPointer reg_getline(int lnum) {
        if (this.reg_firstlnum + lnum < 0) {
            return null;
        }
        return new CharPointer(EditorHelper.getLineBuffer(this.reg_buf, this.reg_firstlnum + lnum));
    }

    public boolean vim_regexec(regmatch_T rmp, CharPointer line, int col) {
        this.reg_match = rmp;
        this.reg_mmatch = null;
        this.reg_maxline = 0;
        this.ireg_ic = rmp.rm_ic;
        return this.vim_regexec_both(line, col) != 0;
    }

    public int vim_regexec_multi(regmmatch_T rmp, Editor buf, int lcount, int lnum, int col) {
        this.reg_match = null;
        this.reg_mmatch = rmp;
        this.reg_buf = buf;
        this.reg_firstlnum = lnum;
        this.reg_maxline = lcount - lnum;
        this.ireg_ic = rmp.rmm_ic;
        int r = this.vim_regexec_both(null, col);
        return r;
    }

    private int vim_regexec_both(CharPointer line, int col) {
        CharPointer s;
        char c;
        regprog_T prog;
        this.reg_tofree = null;
        int retval = 0;
        if (this.reg_match == null) {
            prog = this.reg_mmatch.regprog;
            line = this.reg_getline(0);
            this.reg_startpos = this.reg_mmatch.startpos;
            this.reg_endpos = this.reg_mmatch.endpos;
        } else {
            prog = this.reg_match.regprog;
            this.reg_startp = this.reg_match.startp;
            this.reg_endp = this.reg_match.endp;
        }
        if (prog == null || line == null) {
            MessageHelper.EMSG("e_null");
            return retval;
        }
        if (this.prog_magic_wrong()) {
            return retval;
        }
        if ((prog.regflags & 1) != 0) {
            this.ireg_ic = true;
        } else if ((prog.regflags & 2) != 0) {
            this.ireg_ic = false;
        }
        if (prog.regmust != null) {
            c = prog.regmust.charAt();
            s = line.ref(col);
            while ((s = this.cstrchr(s, c)) != null && this.cstrncmp(s, prog.regmust, prog.regmlen) != 0) {
                s.inc();
            }
            if (s == null) {
                return retval;
            }
        }
        this.regline = line.ref(0);
        this.reglnum = 0;
        this.out_of_stack = false;
        if (prog.reganch != '\u0000') {
            c = this.regline.charAt(col);
            retval = prog.regstart == '\u0000' || prog.regstart == c || this.ireg_ic && Character.toLowerCase(prog.regstart) == Character.toLowerCase(c) ? this.regtry(prog, col) : 0;
        } else {
            while (!this.got_int && !this.out_of_stack) {
                if (prog.regstart != '\u0000') {
                    s = this.cstrchr(this.regline.ref(col), prog.regstart);
                    if (s == null) {
                        retval = 0;
                        break;
                    }
                    col = s.pointer() - this.regline.pointer();
                }
                if ((retval = this.regtry(prog, col)) > 0) break;
                if (this.reglnum != 0) {
                    this.regline = this.reg_getline(0);
                    this.reglnum = 0;
                }
                if (this.regline.charAt(col) == '\u0000') break;
                ++col;
            }
        }
        if (this.out_of_stack) {
            MessageHelper.EMSG("E363");
        }
        return retval;
    }

    private reg_extmatch_T make_extmatch() {
        return new reg_extmatch_T();
    }

    private int regtry(regprog_T prog, int col) {
        this.reginput = this.regline.ref(col);
        this.need_clear_subexpr = true;
        if (prog.reghasz == '\u0001') {
            this.need_clear_zsubexpr = true;
        }
        if (this.regmatch(new CharPointer(prog.program).ref(1))) {
            this.cleanup_subexpr();
            if (this.reg_match == null) {
                if (this.reg_startpos[0].lnum < 0) {
                    this.reg_startpos[0].lnum = 0;
                    this.reg_startpos[0].col = col;
                }
                if (this.reg_endpos[0].lnum < 0) {
                    this.reg_endpos[0].lnum = this.reglnum;
                    this.reg_endpos[0].col = this.reginput.pointer() - this.regline.pointer();
                }
            } else {
                if (this.reg_startp[0] == null) {
                    this.reg_startp[0] = this.regline.ref(col);
                }
                if (this.reg_endp[0] == null) {
                    this.reg_endp[0] = this.reginput;
                }
            }
            re_extmatch_out = null;
            if (prog.reghasz == '\u0001') {
                this.cleanup_zsubexpr();
                re_extmatch_out = this.make_extmatch();
                for (int i = 0; i < 10; ++i) {
                    if (this.reg_match == null) {
                        if (this.reg_startzpos[i].lnum < 0 || this.reg_endzpos[i].lnum != this.reg_startzpos[i].lnum) continue;
                        RegExp.re_extmatch_out.matches[i] = this.reg_getline(this.reg_startzpos[i].lnum).ref(this.reg_startzpos[i].col).substring(this.reg_endzpos[i].col - this.reg_startzpos[i].col);
                        continue;
                    }
                    if (this.reg_startzp[i] == null || this.reg_endzp[i] == null) continue;
                    RegExp.re_extmatch_out.matches[i] = this.reg_startzp[i].substring(this.reg_endzp[i].pointer() - this.reg_startzp[i].pointer());
                }
            }
            return 1 + this.reglnum;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private boolean regmatch(CharPointer scan) {
        while (scan != null) {
            block147: {
                block146: {
                    if (this.got_int || this.out_of_stack) {
                        return false;
                    }
                    next = this.regnext(scan);
                    op = scan.OP();
                    if (!RegExp.WITH_NL(op) || !this.reginput.isNul() || this.reglnum >= this.reg_maxline) break block146;
                    this.reg_nextline();
                    break block147;
                }
                if (RegExp.WITH_NL(op)) {
                    op -= 30;
                }
                c = this.reginput.charAt();
                switch (op) {
                    case 1: {
                        if (this.reginput.equals(this.regline)) break;
                        return false;
                    }
                    case 2: {
                        if (c == '\u0000') break;
                        return false;
                    }
                    case 201: {
                        if (this.reglnum == 0 && this.reginput.equals(this.regline) && (this.reg_match != null || this.reg_getline(-1) == null)) break;
                        return false;
                    }
                    case 202: {
                        if (this.reglnum == this.reg_maxline && c == '\u0000') break;
                        return false;
                    }
                    case 203: {
                        curpos = this.reg_buf.getCaretModel().getLogicalPosition();
                        if (this.reglnum + this.reg_firstlnum == curpos.line && this.reginput.pointer() - this.regline.pointer() == curpos.column) break;
                        return false;
                    }
                    case 204: {
                        if (this.reg_match == null && this.re_num_cmp(this.reglnum + this.reg_firstlnum, scan)) break;
                        return false;
                    }
                    case 205: {
                        if (this.re_num_cmp(this.reginput.pointer() - this.regline.pointer() + 1, scan)) break;
                        return false;
                    }
                    case 206: {
                        break;
                    }
                    case 15: {
                        if (c == '\u0000') {
                            return false;
                        }
                        if (CharacterClasses.isWord(c) && (this.reginput.pointer() <= this.regline.pointer() || !CharacterClasses.isWord(this.reginput.charAt(-1)))) break;
                        return false;
                    }
                    case 16: {
                        if (this.reginput.equals(this.regline)) {
                            return false;
                        }
                        if (!CharacterClasses.isWord(this.reginput.charAt(-1))) {
                            return false;
                        }
                        if (this.reginput.isNul() || !CharacterClasses.isWord(c)) break;
                        return false;
                    }
                    case 20: {
                        if (c == '\u0000') {
                            return false;
                        }
                        this.reginput.inc();
                        break;
                    }
                    case 23: {
                        if (!Character.isJavaIdentifierPart(c)) {
                            return false;
                        }
                        this.reginput.inc();
                        break;
                    }
                    case 24: {
                        if (CharacterClasses.isDigit(this.reginput.charAt()) || !Character.isJavaIdentifierPart(c)) {
                            return false;
                        }
                        this.reginput.inc();
                        break;
                    }
                    case 25: {
                        if (!CharacterClasses.isWord(this.reginput.charAt())) {
                            return false;
                        }
                        this.reginput.inc();
                        break;
                    }
                    case 26: {
                        if (CharacterClasses.isDigit(this.reginput.charAt()) || !CharacterClasses.isWord(this.reginput.charAt())) {
                            return false;
                        }
                        this.reginput.inc();
                        break;
                    }
                    case 27: {
                        if (!CharacterClasses.isFile(c)) {
                            return false;
                        }
                        this.reginput.inc();
                        break;
                    }
                    case 28: {
                        if (CharacterClasses.isDigit(this.reginput.charAt()) || !CharacterClasses.isFile(c)) {
                            return false;
                        }
                        this.reginput.inc();
                        break;
                    }
                    case 29: {
                        if (!CharacterClasses.isPrint(this.reginput.charAt())) {
                            return false;
                        }
                        this.reginput.inc();
                        break;
                    }
                    case 30: {
                        if (CharacterClasses.isDigit(this.reginput.charAt()) || !CharacterClasses.isPrint(this.reginput.charAt())) {
                            return false;
                        }
                        this.reginput.inc();
                        break;
                    }
                    case 31: {
                        if (!CharacterClasses.isWhite(c)) {
                            return false;
                        }
                        this.reginput.inc();
                        break;
                    }
                    case 32: {
                        if (c == '\u0000' || CharacterClasses.isWhite(c)) {
                            return false;
                        }
                        this.reginput.inc();
                        break;
                    }
                    case 33: {
                        if (!CharacterClasses.isDigit(c)) {
                            return false;
                        }
                        this.reginput.inc();
                        break;
                    }
                    case 34: {
                        if (c == '\u0000' || CharacterClasses.isDigit(c)) {
                            return false;
                        }
                        this.reginput.inc();
                        break;
                    }
                    case 35: {
                        if (!CharacterClasses.isHex(c)) {
                            return false;
                        }
                        this.reginput.inc();
                        break;
                    }
                    case 36: {
                        if (c == '\u0000' || CharacterClasses.isHex(c)) {
                            return false;
                        }
                        this.reginput.inc();
                        break;
                    }
                    case 37: {
                        if (!CharacterClasses.isOctal(c)) {
                            return false;
                        }
                        this.reginput.inc();
                        break;
                    }
                    case 38: {
                        if (c == '\u0000' || CharacterClasses.isOctal(c)) {
                            return false;
                        }
                        this.reginput.inc();
                        break;
                    }
                    case 39: {
                        if (!CharacterClasses.isWord(c)) {
                            return false;
                        }
                        this.reginput.inc();
                        break;
                    }
                    case 40: {
                        if (c == '\u0000' || CharacterClasses.isWord(c)) {
                            return false;
                        }
                        this.reginput.inc();
                        break;
                    }
                    case 41: {
                        if (!CharacterClasses.isHead(c)) {
                            return false;
                        }
                        this.reginput.inc();
                        break;
                    }
                    case 42: {
                        if (c == '\u0000' || CharacterClasses.isHead(c)) {
                            return false;
                        }
                        this.reginput.inc();
                        break;
                    }
                    case 43: {
                        if (!CharacterClasses.isAlpha(c)) {
                            return false;
                        }
                        this.reginput.inc();
                        break;
                    }
                    case 44: {
                        if (c == '\u0000' || CharacterClasses.isAlpha(c)) {
                            return false;
                        }
                        this.reginput.inc();
                        break;
                    }
                    case 45: {
                        if (!CharacterClasses.isLower(c)) {
                            return false;
                        }
                        this.reginput.inc();
                        break;
                    }
                    case 46: {
                        if (c == '\u0000' || CharacterClasses.isLower(c)) {
                            return false;
                        }
                        this.reginput.inc();
                        break;
                    }
                    case 47: {
                        if (!CharacterClasses.isUpper(c)) {
                            return false;
                        }
                        this.reginput.inc();
                        break;
                    }
                    case 48: {
                        if (c == '\u0000' || CharacterClasses.isUpper(c)) {
                            return false;
                        }
                        this.reginput.inc();
                        break;
                    }
                    case 5: {
                        opnd = scan.OPERAND();
                        if (!(opnd.charAt() == this.reginput.charAt() || this.ireg_ic && Character.toLowerCase(opnd.charAt()) == Character.toLowerCase(this.reginput.charAt()))) {
                            return false;
                        }
                        if (opnd.charAt(1) == '\u0000') {
                            this.reginput.inc();
                            break;
                        }
                        len = opnd.strlen();
                        if (this.cstrncmp(opnd, this.reginput, len) != 0) {
                            return false;
                        }
                        this.reginput.inc(len);
                        break;
                    }
                    case 21: 
                    case 22: {
                        if (c == '\u0000') {
                            return false;
                        }
                        if (this.cstrchr(scan.OPERAND(), c) == null == (op == 21)) {
                            return false;
                        }
                        this.reginput.inc();
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: {
                        save = new save_se_T();
                        no = op - 80;
                        this.cleanup_subexpr();
                        this.save_se((save_se_T)save, this.reg_startpos[no], this.reg_startp[no]);
                        if (this.regmatch(next)) {
                            return true;
                        }
                        this.restore_se((save_se_T)save, this.reg_startpos[no], this.reg_startp[no]);
                        return false;
                    }
                    case 150: 
                    case 151: {
                        return this.regmatch(next);
                    }
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: {
                        save = new save_se_T();
                        no = op - 110;
                        this.cleanup_zsubexpr();
                        this.save_se((save_se_T)save, this.reg_startzpos[no], this.reg_startzp[no]);
                        if (this.regmatch(next)) {
                            return true;
                        }
                        this.restore_se((save_se_T)save, this.reg_startzpos[no], this.reg_startzp[no]);
                        return false;
                    }
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: {
                        save = new save_se_T();
                        no = op - 90;
                        this.cleanup_subexpr();
                        this.save_se((save_se_T)save, this.reg_endpos[no], this.reg_endp[no]);
                        if (this.regmatch(next)) {
                            return true;
                        }
                        this.restore_se((save_se_T)save, this.reg_endpos[no], this.reg_endp[no]);
                        return false;
                    }
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 127: 
                    case 128: 
                    case 129: {
                        save = new save_se_T();
                        no = op - 120;
                        this.cleanup_zsubexpr();
                        this.save_se((save_se_T)save, this.reg_endzpos[no], this.reg_endzp[no]);
                        if (this.regmatch(next)) {
                            return true;
                        }
                        this.restore_se((save_se_T)save, this.reg_endzpos[no], this.reg_endzp[no]);
                        return false;
                    }
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: {
                        no = op - 100;
                        this.cleanup_subexpr();
                        if (this.reg_match == null) ** GOTO lbl287
                        if (this.reg_endp[no] == null) {
                            len = 0;
                        } else {
                            len = this.reg_endp[no].pointer() - this.reg_startp[no].pointer();
                            if (this.cstrncmp(this.reg_startp[no], this.reginput, len) != 0) {
                                return false;
                            }
                        }
                        ** GOTO lbl314
lbl287:
                        // 1 sources

                        if (this.reg_endpos[no].lnum >= 0) ** GOTO lbl290
                        len = 0;
                        ** GOTO lbl314
lbl290:
                        // 1 sources

                        if (this.reg_startpos[no].lnum != this.reglnum || this.reg_endpos[no].lnum != this.reglnum) ** GOTO lbl295
                        len = this.reg_endpos[no].col - this.reg_startpos[no].col;
                        if (this.cstrncmp(this.regline.ref(this.reg_startpos[no].col), this.reginput, len) != 0) {
                            return false;
                        }
                        ** GOTO lbl314
lbl295:
                        // 1 sources

                        ccol = this.reg_startpos[no].col;
                        clnum = this.reg_startpos[no].lnum;
                        do {
                            if (!this.regline.equals(this.reg_tofree)) {
                                this.reg_tofree = this.regline.ref(0);
                                this.reginput = this.reg_tofree.ref(this.reginput.pointer() - this.regline.pointer());
                                this.regline = this.reg_tofree.ref(0);
                            }
                            p = this.reg_getline(clnum);
                            len = clnum == this.reg_endpos[no].lnum ? this.reg_endpos[no].col - ccol : p.ref(ccol).strlen();
                            if (this.cstrncmp(p.ref(ccol), this.reginput, len) != 0) {
                                return false;
                            }
                            if (clnum == this.reg_endpos[no].lnum) ** GOTO lbl314
                            if (this.reglnum == this.reg_maxline) {
                                return false;
                            }
                            this.reg_nextline();
                            ++clnum;
                            ccol = 0;
                        } while (!this.got_int && !this.out_of_stack);
                        return false;
lbl314:
                        // 5 sources

                        this.reginput.inc(len);
                        break;
                    }
                    case 131: 
                    case 132: 
                    case 133: 
                    case 134: 
                    case 135: 
                    case 136: 
                    case 137: 
                    case 138: 
                    case 139: {
                        this.cleanup_zsubexpr();
                        no = op - 130;
                        if (RegExp.re_extmatch_in == null || RegExp.re_extmatch_in.matches[no] == null) break;
                        len = RegExp.re_extmatch_in.matches[no].length();
                        if (this.cstrncmp(new CharPointer(RegExp.re_extmatch_in.matches[no]), this.reginput, len) != 0) {
                            return false;
                        }
                        this.reginput.inc(len);
                        break;
                    }
                    case 3: {
                        if (next.OP() != 3) {
                            next = scan.OPERAND();
                            break;
                        }
                        save = new regsave_T();
                        do {
                            this.reg_save(save);
                            if (this.regmatch(scan.OPERAND())) {
                                return true;
                            }
                            this.reg_restore(save);
                        } while ((scan = this.regnext(scan)) != null && scan.OP() == 3);
                        return false;
                    }
                    case 17: {
                        if (next.OP() == 14) {
                            this.bl_minval = scan.OPERAND_MIN();
                            this.bl_maxval = scan.OPERAND_MAX();
                            break;
                        }
                        if (next.OP() >= 140 && next.OP() < 150) {
                            no = next.OP() - 140;
                            this.brace_min[no] = scan.OPERAND_MIN();
                            this.brace_max[no] = scan.OPERAND_MAX();
                            this.brace_count[no] = 0;
                            break;
                        }
                        MessageHelper.EMSG("e_internal");
                        return false;
                    }
                    case 140: 
                    case 141: 
                    case 142: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 146: 
                    case 147: 
                    case 148: 
                    case 149: {
                        save = new regsave_T();
                        v0 = no = op - 140;
                        this.brace_count[v0] = this.brace_count[v0] + 1;
                        if (this.brace_count[no] <= (this.brace_min[no] <= this.brace_max[no] ? this.brace_min[no] : this.brace_max[no])) {
                            this.reg_save((regsave_T)save);
                            if (this.regmatch(scan.OPERAND())) {
                                return true;
                            }
                            this.reg_restore((regsave_T)save);
                            v1 = no;
                            this.brace_count[v1] = this.brace_count[v1] - 1;
                            return false;
                        }
                        if (this.brace_min[no] <= this.brace_max[no]) {
                            if (this.brace_count[no] > this.brace_max[no]) break;
                            this.reg_save((regsave_T)save);
                            if (this.regmatch(scan.OPERAND())) {
                                return true;
                            }
                            this.reg_restore((regsave_T)save);
                            v2 = no;
                            this.brace_count[v2] = this.brace_count[v2] - 1;
                            break;
                        }
                        if (this.brace_count[no] > this.brace_min[no]) break;
                        this.reg_save((regsave_T)save);
                        if (this.regmatch(next)) {
                            return true;
                        }
                        this.reg_restore((regsave_T)save);
                        next = scan.OPERAND();
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 14: {
                        save = new regsave_T();
                        if (next.OP() == 5) {
                            nextb = next.OPERAND().charAt();
                            nextb_ic = this.ireg_ic ? (Character.isUpperCase(nextb) ? Character.toLowerCase(nextb) : Character.toUpperCase(nextb)) : nextb;
                        } else {
                            nextb = '\u0000';
                            nextb_ic = '\u0000';
                        }
                        if (op != 14) {
                            minval = op == 7 ? 0 : 1;
                            maxval = 0x7FFFFFFF;
                        } else {
                            minval = this.bl_minval;
                            maxval = this.bl_maxval;
                        }
                        count = this.regrepeat(scan.OPERAND(), maxval);
                        if (this.got_int) {
                            return false;
                        }
                        if (minval > maxval) ** GOTO lbl418
                        while (count >= minval) {
                            if (nextb == '\u0000' || this.reginput.charAt() == nextb || this.reginput.charAt() == nextb_ic) {
                                this.reg_save(save);
                                if (this.regmatch(next)) {
                                    return true;
                                }
                                this.reg_restore(save);
                            }
                            if (--count >= minval) {
                                if (this.reginput == this.regline) {
                                    --this.reglnum;
                                    this.regline = this.reg_getline(this.reglnum);
                                    if (this.regline == null) {
                                        return false;
                                    }
                                    this.reginput = this.regline.ref(this.regline.strlen());
                                    if (!this.got_int && !this.out_of_stack) continue;
                                    return false;
                                }
                                this.reginput.dec();
                                continue;
                            }
                            ** GOTO lbl430
                        }
                        ** GOTO lbl430
lbl418:
                        // 1 sources

                        if (count < maxval) {
                            return false;
                        }
                        do {
                            if (nextb == '\u0000' || this.reginput.charAt() == nextb || this.reginput.charAt() == nextb_ic) {
                                this.reg_save(save);
                                if (this.regmatch(next)) {
                                    return true;
                                }
                                this.reg_restore(save);
                            }
                            if (count == minval || this.regrepeat(scan.OPERAND(), 1) == 0) ** GOTO lbl430
                            ++count;
                        } while (!this.got_int && !this.out_of_stack);
                        return false;
lbl430:
                        // 3 sources

                        return false;
                    }
                    case 10: {
                        save = new regsave_T();
                        this.reg_save(save);
                        if (this.regmatch(scan.OPERAND())) {
                            return false;
                        }
                        this.reg_restore(save);
                        break;
                    }
                    case 9: 
                    case 13: {
                        save = new regsave_T();
                        this.reg_save(save);
                        if (!this.regmatch(scan.OPERAND())) {
                            return false;
                        }
                        if (op != 9) break;
                        this.reg_restore(save);
                        break;
                    }
                    case 11: 
                    case 12: {
                        save_after = new regsave_T();
                        save_start = new regsave_T();
                        save_behind_pos = new regsave_T();
                        needmatch = op == 11;
                        this.reg_save(save_start);
                        if (this.regmatch(next)) {
                            this.reg_save(save_after);
                            save_behind_pos = this.behind_pos;
                            this.behind_pos = save_start;
                            while (true) {
                                this.reg_restore(save_start);
                                if (this.regmatch(scan.OPERAND()) && this.reg_save_equal(this.behind_pos)) {
                                    this.behind_pos = save_behind_pos;
                                    if (needmatch) {
                                        this.reg_restore(save_after);
                                        return true;
                                    }
                                    return false;
                                }
                                if (this.reg_match == null) {
                                    if (save_start.pos.col == 0) {
                                        if (save_start.pos.lnum < this.behind_pos.pos.lnum || this.reg_getline(--save_start.pos.lnum) == null) break;
                                        this.reg_restore(save_start);
                                        save_start.pos.col = this.regline.strlen();
                                        continue;
                                    }
                                    --save_start.pos.col;
                                    continue;
                                }
                                if (save_start.ptr == this.regline) break;
                                save_start.ptr.dec();
                            }
                            this.behind_pos = save_behind_pos;
                            if (!needmatch) {
                                this.reg_restore(save_after);
                                return true;
                            }
                        }
                        return false;
                    }
                    case 19: {
                        if (!(this.reg_match == null ? this.behind_pos.pos.col != this.reginput.pointer() - this.regline.pointer() || this.behind_pos.pos.lnum != this.reglnum : this.behind_pos.ptr != this.reginput)) break;
                        return false;
                    }
                    case 18: {
                        if (c != '\u0000' || this.reglnum == this.reg_maxline) {
                            return false;
                        }
                        this.reg_nextline();
                        break;
                    }
                    case 0: {
                        return true;
                    }
                    default: {
                        MessageHelper.EMSG("e_re_corr");
                        return false;
                    }
                }
            }
            scan = next;
        }
        MessageHelper.EMSG("e_re_corr");
        return false;
    }

    private int regrepeat(CharPointer p, int maxcount) {
        int count;
        int mask = 0;
        int testval = 0;
        CharPointer scan = this.reginput.ref(0);
        CharPointer opnd = p.OPERAND();
        block0 : switch (p.OP()) {
            case 20: 
            case 50: {
                for (count = 0; count < maxcount; ++count) {
                    while (!scan.isNul() && count < maxcount) {
                        ++count;
                        scan.inc();
                    }
                    if (!RegExp.WITH_NL(p.OP()) || this.reglnum == this.reg_maxline || count == maxcount) break block0;
                    this.reg_nextline();
                    scan = this.reginput.ref(0);
                    if (!this.got_int) continue;
                    break block0;
                }
                break;
            }
            case 23: 
            case 53: {
                testval = 1;
            }
            case 24: 
            case 54: {
                while (count < maxcount) {
                    if (Character.isJavaIdentifierPart(scan.charAt()) && (testval == 1 || !Character.isDigit(scan.charAt()))) {
                        scan.inc();
                    } else {
                        if (!scan.isNul() || !RegExp.WITH_NL(p.OP()) || this.reglnum == this.reg_maxline) break block0;
                        this.reg_nextline();
                        scan = this.reginput.ref(0);
                        if (this.got_int) break block0;
                    }
                    ++count;
                }
                break;
            }
            case 25: 
            case 55: {
                testval = 1;
            }
            case 26: 
            case 56: {
                while (count < maxcount) {
                    if (CharacterClasses.isWord(scan.charAt()) && (testval == 1 || !Character.isDigit(scan.charAt()))) {
                        scan.inc();
                    } else {
                        if (!scan.isNul() || !RegExp.WITH_NL(p.OP()) || this.reglnum == this.reg_maxline) break block0;
                        this.reg_nextline();
                        scan = this.reginput.ref(0);
                        if (this.got_int) break block0;
                    }
                    ++count;
                }
                break;
            }
            case 27: 
            case 57: {
                testval = 1;
            }
            case 28: 
            case 58: {
                while (count < maxcount) {
                    if (CharacterClasses.isFile(scan.charAt()) && (testval == 1 || !Character.isDigit(scan.charAt()))) {
                        scan.inc();
                    } else {
                        if (!scan.isNul() || !RegExp.WITH_NL(p.OP()) || this.reglnum == this.reg_maxline) break block0;
                        this.reg_nextline();
                        scan = this.reginput.ref(0);
                        if (this.got_int) break block0;
                    }
                    ++count;
                }
                break;
            }
            case 29: 
            case 59: {
                testval = 1;
            }
            case 30: 
            case 60: {
                while (count < maxcount) {
                    if (scan.isNul()) {
                        if (!RegExp.WITH_NL(p.OP()) || this.reglnum == this.reg_maxline) break block0;
                        this.reg_nextline();
                        scan = this.reginput.ref(0);
                        if (this.got_int) {
                            break block0;
                        }
                    } else {
                        if (!CharacterClasses.isPrint(scan.charAt()) || testval != 1 && Character.isDigit(scan.charAt())) break block0;
                        scan.inc();
                    }
                    ++count;
                }
                break;
            }
            case 31: 
            case 61: {
                mask = 256;
                testval = 256;
                break;
            }
            case 32: 
            case 62: {
                mask = 256;
                break;
            }
            case 33: 
            case 63: {
                mask = 1;
                testval = 1;
                break;
            }
            case 34: 
            case 64: {
                mask = 1;
                break;
            }
            case 35: 
            case 65: {
                mask = 2;
                testval = 2;
                break;
            }
            case 36: 
            case 66: {
                mask = 2;
                break;
            }
            case 37: 
            case 67: {
                mask = 4;
                testval = 4;
                break;
            }
            case 38: 
            case 68: {
                mask = 4;
                break;
            }
            case 39: 
            case 69: {
                mask = 8;
                testval = 8;
                break;
            }
            case 40: 
            case 70: {
                mask = 8;
                break;
            }
            case 41: 
            case 71: {
                mask = 16;
                testval = 16;
                break;
            }
            case 42: 
            case 72: {
                mask = 16;
                break;
            }
            case 43: 
            case 73: {
                mask = 32;
                testval = 32;
                break;
            }
            case 44: 
            case 74: {
                mask = 32;
                break;
            }
            case 45: 
            case 75: {
                mask = 64;
                testval = 64;
                break;
            }
            case 46: 
            case 76: {
                mask = 64;
                break;
            }
            case 47: 
            case 77: {
                mask = 128;
                testval = 128;
                break;
            }
            case 48: 
            case 78: {
                mask = 128;
                break;
            }
            case 5: {
                char cu;
                if (this.ireg_ic) {
                    cu = Character.toUpperCase(opnd.charAt());
                    char cl = Character.toLowerCase(opnd.charAt());
                    while (count < maxcount && (scan.charAt() == cu || scan.charAt() == cl)) {
                        ++count;
                        scan.inc();
                    }
                } else {
                    cu = opnd.charAt();
                    while (count < maxcount && scan.charAt() == cu) {
                        ++count;
                        scan.inc();
                    }
                }
                break;
            }
            case 21: 
            case 51: {
                testval = 1;
            }
            case 22: 
            case 52: {
                while (count < maxcount) {
                    if (scan.isNul()) {
                        if (!RegExp.WITH_NL(p.OP()) || this.reglnum == this.reg_maxline) break block0;
                        this.reg_nextline();
                        scan = this.reginput.ref(0);
                        if (this.got_int) {
                            break block0;
                        }
                    } else {
                        if (this.cstrchr(opnd, scan.charAt()) == null == (testval == 1)) break block0;
                        scan.inc();
                    }
                    ++count;
                }
                break;
            }
            case 18: {
                while (count < maxcount && scan.isNul() && this.reglnum < this.reg_maxline) {
                    ++count;
                    this.reg_nextline();
                    scan = this.reginput.ref(0);
                    if (!this.got_int) continue;
                    break block0;
                }
                break;
            }
            default: {
                MessageHelper.EMSG("e_re_corr");
            }
        }
        if (mask != 0) {
            while (count < maxcount) {
                if (scan.isNul()) {
                    if (!RegExp.WITH_NL(p.OP()) || this.reglnum == this.reg_maxline) break;
                    this.reg_nextline();
                    scan = this.reginput.ref(0);
                    if (this.got_int) {
                        break;
                    }
                } else {
                    if (!CharacterClasses.isMask(scan.charAt(), mask, testval)) break;
                    scan.inc();
                }
                ++count;
            }
        }
        this.reginput = scan.ref(0);
        return count;
    }

    private CharPointer regnext(CharPointer p) {
        int offset = p.NEXT();
        if (offset == 0) {
            return null;
        }
        if (p.OP() == 4) {
            return p.ref(-offset);
        }
        return p.ref(offset);
    }

    private boolean prog_magic_wrong() {
        if ((this.reg_match == null ? this.reg_mmatch.regprog.program : this.reg_match.regprog.program).charAt(0) != '\u009c') {
            MessageHelper.EMSG("e_re_corr");
            return true;
        }
        return false;
    }

    private void cleanup_subexpr() {
        if (this.need_clear_subexpr) {
            if (this.reg_match == null) {
                for (int i = 0; i < 10; ++i) {
                    this.reg_startpos[i].col = -1;
                    this.reg_startpos[i].lnum = -1;
                    this.reg_endpos[i].col = -1;
                    this.reg_endpos[i].lnum = -1;
                }
            } else {
                for (int i = 0; i < 10; ++i) {
                    this.reg_startp[i] = null;
                    this.reg_endp[i] = null;
                }
            }
            this.need_clear_subexpr = false;
        }
    }

    private void cleanup_zsubexpr() {
        if (this.need_clear_zsubexpr) {
            if (this.reg_match == null) {
                for (int i = 0; i < 10; ++i) {
                    this.reg_startzpos[i].col = -1;
                    this.reg_startzpos[i].lnum = -1;
                    this.reg_endzpos[i].col = -1;
                    this.reg_endzpos[i].lnum = -1;
                }
            } else {
                for (int i = 0; i < 10; ++i) {
                    this.reg_startzp[i] = null;
                    this.reg_endzp[i] = null;
                }
            }
            this.need_clear_zsubexpr = false;
        }
    }

    private void reg_nextline() {
        this.regline = this.reg_getline(++this.reglnum);
        this.reginput = this.regline.ref(0);
    }

    private void reg_save(regsave_T save) {
        if (this.reg_match == null) {
            save.pos.col = this.reginput.pointer() - this.regline.pointer();
            save.pos.lnum = this.reglnum;
        } else {
            save.ptr = this.reginput.ref(0);
        }
    }

    private void reg_restore(regsave_T save) {
        if (this.reg_match == null) {
            if (this.reglnum != save.pos.lnum) {
                this.reglnum = save.pos.lnum;
                this.regline = this.reg_getline(this.reglnum);
            }
            this.reginput = this.regline.ref(save.pos.col);
        } else {
            this.reginput = save.ptr.ref(0);
        }
    }

    private boolean reg_save_equal(regsave_T save) {
        if (this.reg_match == null) {
            return this.reglnum == save.pos.lnum && this.reginput == this.regline.ref(save.pos.col);
        }
        return this.reginput == save.ptr;
    }

    private void save_se(save_se_T savep, lpos_T posp, CharPointer pp) {
        if (this.reg_match == null) {
            savep.pos.lnum = posp.lnum;
            savep.pos.col = posp.col;
            posp.lnum = this.reglnum;
            posp.col = this.reginput.pointer() - this.regline.pointer();
        } else {
            savep.ptr = pp.ref(0);
            pp.assign(this.reginput);
        }
    }

    private void restore_se(save_se_T savep, lpos_T posp, CharPointer pp) {
        if (this.reg_match == null) {
            posp.col = savep.pos.col;
            posp.lnum = savep.pos.lnum;
        } else {
            pp.assign(savep.ptr);
        }
    }

    private boolean re_num_cmp(int val, CharPointer scan) {
        int n = scan.OPERAND_MIN();
        if (scan.OPERAND_CMP() == '>') {
            return val > n;
        }
        if (scan.OPERAND_CMP() == '<') {
            return val < n;
        }
        return val == n;
    }

    private int cstrncmp(CharPointer s1, CharPointer s2, int n) {
        if (!this.ireg_ic) {
            return s1.strncmp(s2, n);
        }
        return s1.strnicmp(s2, n);
    }

    private CharPointer cstrchr(CharPointer s, char c) {
        if (!this.ireg_ic) {
            return s.strchr(c);
        }
        return s.istrchr(c);
    }

    public String vim_regsub(regmatch_T rmp, CharPointer source, int magic, boolean backslash) {
        this.reg_match = rmp;
        this.reg_mmatch = null;
        this.reg_maxline = 0;
        return this.vim_regsub_both(source, magic, backslash);
    }

    public String vim_regsub_multi(regmmatch_T rmp, int lnum, CharPointer source, int magic, boolean backslash) {
        this.reg_match = null;
        this.reg_mmatch = rmp;
        this.reg_firstlnum = lnum;
        this.reg_maxline = EditorHelper.getLineCount(this.reg_buf) - lnum;
        return this.vim_regsub_both(source, magic, backslash);
    }

    private int subappend(int mode, StringBuffer dst, char c) {
        switch (mode) {
            case 117: {
                mode = 0;
            }
            case 85: {
                dst.append(Character.toUpperCase(c));
                break;
            }
            case 108: {
                mode = 0;
            }
            case 76: {
                dst.append(Character.toLowerCase(c));
                break;
            }
            default: {
                dst.append(c);
            }
        }
        return mode;
    }

    private String vim_regsub_both(CharPointer source, int magic, boolean backslash) {
        StringBuffer dst = new StringBuffer();
        int no = -1;
        int clnum = 0;
        int len = 0;
        int mode = 0;
        if (source == null) {
            MessageHelper.EMSG("e_null");
            return null;
        }
        if (this.prog_magic_wrong()) {
            return null;
        }
        CharPointer src = source.ref(0);
        if (source.charAt(0) != '\\' || source.charAt(1) != '=') {
            int c;
            block13: while ((c = src.charAt()) != 0) {
                CharPointer s;
                src.inc();
                if (c == 38 && magic != 0) {
                    no = 0;
                } else if (c == 92 && !src.isNul()) {
                    if (src.charAt() == '&' && magic == 0) {
                        src.inc();
                        no = 0;
                    } else if ('0' <= src.charAt() && src.charAt() <= '9') {
                        no = src.charAt() - 48;
                        src.inc();
                    } else if ("uUlLeE".indexOf(src.charAt()) != -1) {
                        switch (src.charAtInc()) {
                            case 'u': {
                                mode = 117;
                                continue block13;
                            }
                            case 'U': {
                                mode = 85;
                                continue block13;
                            }
                            case 'l': {
                                mode = 108;
                                continue block13;
                            }
                            case 'L': {
                                mode = 76;
                                continue block13;
                            }
                            case 'E': 
                            case 'e': {
                                mode = 0;
                                continue block13;
                            }
                        }
                    }
                }
                if (no < 0) {
                    if (c == 92 && !src.isNul()) {
                        switch (src.charAt()) {
                            case 'r': {
                                c = 13;
                                src.inc();
                                break;
                            }
                            case 'n': {
                                c = 10;
                                src.inc();
                                break;
                            }
                            case 't': {
                                c = 9;
                                src.inc();
                                break;
                            }
                            case 'b': {
                                c = 8;
                                src.inc();
                                break;
                            }
                            default: {
                                if (backslash) {
                                    dst.append('\\');
                                }
                                c = src.charAt();
                                src.inc();
                            }
                        }
                    }
                    mode = this.subappend(mode, dst, (char)c);
                    continue;
                }
                if (this.reg_match == null) {
                    clnum = this.reg_mmatch.startpos[no].lnum;
                    if (clnum < 0 || this.reg_mmatch.endpos[no].lnum < 0) {
                        s = null;
                    } else {
                        s = this.reg_getline(clnum).ref(this.reg_mmatch.startpos[no].col);
                        len = this.reg_mmatch.endpos[no].lnum == clnum ? this.reg_mmatch.endpos[no].col - this.reg_mmatch.startpos[no].col : s.strlen();
                    }
                } else {
                    s = this.reg_match.startp[no];
                    if (this.reg_match.endp[no] == null) {
                        s = null;
                    } else {
                        len = this.reg_match.endp[no].pointer() - s.pointer();
                    }
                }
                if (s != null) {
                    while (true) {
                        if (len == 0) {
                            if (this.reg_match != null || this.reg_mmatch.endpos[no].lnum == clnum) break;
                            dst.append('\r');
                            s = this.reg_getline(++clnum);
                            if (this.reg_mmatch.endpos[no].lnum == clnum) {
                                len = this.reg_mmatch.endpos[no].col;
                                continue;
                            }
                            len = s.strlen();
                            continue;
                        }
                        if (s.isNul()) {
                            MessageHelper.EMSG("e_re_damg");
                            return dst.toString();
                        }
                        if (backslash && (s.charAt() == '\r' || s.charAt() == '\\')) {
                            dst.append('\\');
                            dst.append(s.charAt());
                        } else {
                            mode = this.subappend(mode, dst, s.charAt());
                        }
                        s.inc();
                        --len;
                    }
                }
                no = -1;
            }
        }
        return dst.toString();
    }

    private String regdump(String pattern, regprog_T r) {
        int op = 5;
        CharPointer end = null;
        StringBuffer res = new StringBuffer();
        res.append("\nregcomp(").append(pattern).append("):\n");
        CharPointer start = new CharPointer(r.program);
        CharPointer s = start.ref(1);
        while (op != 0 || !s.end()) {
            op = s.OP();
            res.append(s.pointer() - start.pointer());
            res.append(this.regprop(s));
            CharPointer next = this.regnext(s);
            if (next == null) {
                res.append("(0)");
            } else {
                res.append("(").append(s.pointer() - start.pointer() + (next.pointer() - s.pointer())).append(")");
            }
            if (end == null || next != null && end.pointer() < next.pointer()) {
                end = next;
            }
            if (op == 17) {
                res.append(" minval ");
                res.append(s.OPERAND_MIN());
                res.append(", maxval ");
                res.append(s.OPERAND_MAX());
                s.inc(8);
            }
            s.inc(3);
            if (op == 21 || op == 51 || op == 22 || op == 52 || op == 5) {
                while (!s.isNul()) {
                    res.append(s.charAt());
                    s.inc();
                }
                s.inc();
            }
            res.append("\n");
        }
        if (r.regstart != '\u0000') {
            res.append("start `");
            if (r.regstart < ' ') {
                res.append("^").append((char)(64 + r.regstart));
            } else {
                res.append(r.regstart);
            }
            res.append("' ");
            res.append(Integer.toString(r.regstart, 16));
        }
        if (r.reganch != '\u0000') {
            res.append("anchored: ");
        }
        if (r.regmust != null) {
            res.append("must have \"").append(r.regmust.substring(r.regmust.strlen())).append("\"");
        }
        res.append("\n");
        return res.toString();
    }

    private String regprop(CharPointer op) {
        String p;
        StringBuffer buf = new StringBuffer();
        buf.append(':');
        switch (op.OP()) {
            case 1: {
                p = "BOL";
                break;
            }
            case 2: {
                p = "EOL";
                break;
            }
            case 201: {
                p = "BOF";
                break;
            }
            case 202: {
                p = "EOF";
                break;
            }
            case 203: {
                p = "CURSOR";
                break;
            }
            case 204: {
                p = "RE_LNUM";
                break;
            }
            case 205: {
                p = "RE_COL";
                break;
            }
            case 206: {
                p = "RE_VCOL";
                break;
            }
            case 15: {
                p = "BOW";
                break;
            }
            case 16: {
                p = "EOW";
                break;
            }
            case 20: {
                p = "ANY";
                break;
            }
            case 50: {
                p = "ANY+NL";
                break;
            }
            case 21: {
                p = "ANYOF";
                break;
            }
            case 51: {
                p = "ANYOF+NL";
                break;
            }
            case 22: {
                p = "ANYBUT";
                break;
            }
            case 52: {
                p = "ANYBUT+NL";
                break;
            }
            case 23: {
                p = "IDENT";
                break;
            }
            case 53: {
                p = "IDENT+NL";
                break;
            }
            case 24: {
                p = "SIDENT";
                break;
            }
            case 54: {
                p = "SIDENT+NL";
                break;
            }
            case 25: {
                p = "KWORD";
                break;
            }
            case 55: {
                p = "KWORD+NL";
                break;
            }
            case 26: {
                p = "SKWORD";
                break;
            }
            case 56: {
                p = "SKWORD+NL";
                break;
            }
            case 27: {
                p = "FNAME";
                break;
            }
            case 57: {
                p = "FNAME+NL";
                break;
            }
            case 28: {
                p = "SFNAME";
                break;
            }
            case 58: {
                p = "SFNAME+NL";
                break;
            }
            case 29: {
                p = "PRINT";
                break;
            }
            case 59: {
                p = "PRINT+NL";
                break;
            }
            case 30: {
                p = "SPRINT";
                break;
            }
            case 60: {
                p = "SPRINT+NL";
                break;
            }
            case 31: {
                p = "WHITE";
                break;
            }
            case 61: {
                p = "WHITE+NL";
                break;
            }
            case 32: {
                p = "NWHITE";
                break;
            }
            case 62: {
                p = "NWHITE+NL";
                break;
            }
            case 33: {
                p = "DIGIT";
                break;
            }
            case 63: {
                p = "DIGIT+NL";
                break;
            }
            case 34: {
                p = "NDIGIT";
                break;
            }
            case 64: {
                p = "NDIGIT+NL";
                break;
            }
            case 35: {
                p = "HEX";
                break;
            }
            case 65: {
                p = "HEX+NL";
                break;
            }
            case 36: {
                p = "NHEX";
                break;
            }
            case 66: {
                p = "NHEX+NL";
                break;
            }
            case 37: {
                p = "OCTAL";
                break;
            }
            case 67: {
                p = "OCTAL+NL";
                break;
            }
            case 38: {
                p = "NOCTAL";
                break;
            }
            case 68: {
                p = "NOCTAL+NL";
                break;
            }
            case 39: {
                p = "WORD";
                break;
            }
            case 69: {
                p = "WORD+NL";
                break;
            }
            case 40: {
                p = "NWORD";
                break;
            }
            case 70: {
                p = "NWORD+NL";
                break;
            }
            case 41: {
                p = "HEAD";
                break;
            }
            case 71: {
                p = "HEAD+NL";
                break;
            }
            case 42: {
                p = "NHEAD";
                break;
            }
            case 72: {
                p = "NHEAD+NL";
                break;
            }
            case 43: {
                p = "ALPHA";
                break;
            }
            case 73: {
                p = "ALPHA+NL";
                break;
            }
            case 44: {
                p = "NALPHA";
                break;
            }
            case 74: {
                p = "NALPHA+NL";
                break;
            }
            case 45: {
                p = "LOWER";
                break;
            }
            case 75: {
                p = "LOWER+NL";
                break;
            }
            case 46: {
                p = "NLOWER";
                break;
            }
            case 76: {
                p = "NLOWER+NL";
                break;
            }
            case 47: {
                p = "UPPER";
                break;
            }
            case 77: {
                p = "UPPER+NL";
                break;
            }
            case 48: {
                p = "NUPPER";
                break;
            }
            case 78: {
                p = "NUPPER+NL";
                break;
            }
            case 3: {
                p = "BRANCH";
                break;
            }
            case 5: {
                p = "EXACTLY";
                break;
            }
            case 6: {
                p = "NOTHING";
                break;
            }
            case 4: {
                p = "BACK";
                break;
            }
            case 0: {
                p = "END";
                break;
            }
            case 80: {
                p = "MATCH START";
                break;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: {
                buf.append("MOPEN").append(op.OP() - 80);
                p = null;
                break;
            }
            case 90: {
                p = "MATCH END";
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                buf.append("MCLOSE").append(op.OP() - 90);
                p = null;
                break;
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                buf.append("BACKREF").append(op.OP() - 100);
                p = null;
                break;
            }
            case 150: {
                p = "NOPEN";
                break;
            }
            case 151: {
                p = "NCLOSE";
                break;
            }
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                buf.append("ZOPEN").append(op.OP() - 110);
                p = null;
                break;
            }
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: {
                buf.append("ZCLOSE").append(op.OP() - 120);
                p = null;
                break;
            }
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: {
                buf.append("ZREF").append(op.OP() - 130);
                p = null;
                break;
            }
            case 7: {
                p = "STAR";
                break;
            }
            case 8: {
                p = "PLUS";
                break;
            }
            case 10: {
                p = "NOMATCH";
                break;
            }
            case 9: {
                p = "MATCH";
                break;
            }
            case 11: {
                p = "BEHIND";
                break;
            }
            case 12: {
                p = "NOBEHIND";
                break;
            }
            case 13: {
                p = "SUBPAT";
                break;
            }
            case 17: {
                p = "BRACE_LIMITS";
                break;
            }
            case 14: {
                p = "BRACE_SIMPLE";
                break;
            }
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: {
                buf.append("BRACE_COMPLEX").append(op.OP() - 140);
                p = null;
                break;
            }
            case 18: {
                p = "NEWL";
                break;
            }
            default: {
                buf.append("corrupt ").append(op.OP());
                p = null;
            }
        }
        if (p != null) {
            buf.append(p);
        }
        return buf.toString();
    }

    public static class regmmatch_T {
        public regprog_T regprog;
        public lpos_T[] startpos = new lpos_T[10];
        public lpos_T[] endpos = new lpos_T[10];
        public boolean rmm_ic;

        public regmmatch_T() {
            for (int i = 0; i < 10; ++i) {
                this.startpos[i] = new lpos_T();
                this.endpos[i] = new lpos_T();
            }
        }
    }

    private static class regmatch_T {
        regprog_T regprog;
        CharPointer[] startp = new CharPointer[10];
        CharPointer[] endp = new CharPointer[10];
        boolean rm_ic;

        private regmatch_T() {
        }
    }

    private static class save_se_T {
        CharPointer ptr;
        lpos_T pos = new lpos_T();

        private save_se_T() {
        }
    }

    private static class regsave_T {
        CharPointer ptr;
        lpos_T pos = new lpos_T();

        private regsave_T() {
        }
    }

    public static class lpos_T {
        public int lnum = 0;
        public int col = 0;

        public lpos_T(lpos_T pos) {
            this.lnum = pos.lnum;
            this.col = pos.col;
        }

        public lpos_T() {
        }
    }

    private static class MinMax {
        int minvalue;
        int maxvalue;

        private MinMax() {
        }
    }

    public static class regprog_T {
        char regstart;
        char reganch;
        CharPointer regmust;
        int regmlen;
        int regflags;
        char reghasz;
        StringBuffer program;
    }

    private static class reg_extmatch_T {
        String[] matches = new String[10];

        private reg_extmatch_T() {
        }
    }
}

