/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.group.CommandGroups;
import com.maddyhome.idea.vim.helper.DigraphSequence;
import com.maddyhome.idea.vim.helper.SearchHelper;
import com.maddyhome.idea.vim.ui.ExDocument;
import com.maddyhome.idea.vim.ui.ExEntryPanel;
import com.maddyhome.idea.vim.ui.ExTextField;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.TextAction;

public class ExEditorKit
extends DefaultEditorKit {
    public static final String DefaultExKey = "default-ex-key";
    public static final String CancelEntry = "cancel-entry";
    public static final String CompleteEntry = "complete-entry";
    public static final String EscapeChar = "escape";
    public static final String DeletePreviousChar = "delete-prev-char";
    public static final String DeletePreviousWord = "delete-prev-word";
    public static final String DeleteToCursor = "delete-to-cursor";
    public static final String DeleteFromCursor = "delete-from-cursor";
    public static final String ToggleInsertReplace = "toggle-insert";
    public static final String InsertRegister = "insert-register";
    public static final String InsertWord = "insert-word";
    public static final String InsertWORD = "insert-WORD";
    public static final String HistoryUp = "history-up";
    public static final String HistoryDown = "history-down";
    public static final String HistoryUpFilter = "history-up-filter";
    public static final String HistoryDownFilter = "history-down-filter";
    public static final String StartDigraph = "start-digraph";
    protected Action[] exActions = new Action[]{new CancelEntryAction(), new CompleteEntryAction(), new EscapeCharAction(), new DeletePreviousCharAction(), new DeletePreviousWordAction(), new DeleteToCursorAction(), new DeleteFromCursorAction(), new HistoryUpAction(), new HistoryDownAction(), new HistoryUpFilterAction(), new HistoryDownFilterAction(), new ToggleInsertReplaceAction(), new StartDigraphAction()};
    private static ExEditorKit instance;
    private static final Logger logger;

    public static ExEditorKit getInstance() {
        if (instance == null) {
            instance = new ExEditorKit();
        }
        return instance;
    }

    public String getContentType() {
        return "text/plain";
    }

    public Action[] getActions() {
        Action[] res = TextAction.augmentList(super.getActions(), this.exActions);
        if (logger.isDebugEnabled()) {
            logger.debug("res.length=" + res.length);
        }
        return res;
    }

    public Document createDefaultDocument() {
        return new ExDocument();
    }

    public static KeyStroke convert(ActionEvent event) {
        String cmd = event.getActionCommand();
        int mods = event.getModifiers();
        if (cmd != null && cmd.length() > 0) {
            char ch = cmd.charAt(0);
            if (ch < ' ') {
                if (mods == 2) {
                    return KeyStroke.getKeyStroke(65 + ch - 1, mods);
                }
            } else {
                return KeyStroke.getKeyStroke(new Character(ch), mods);
            }
        }
        return null;
    }

    static {
        logger = Logger.getInstance((String)ExEditorKit.class.getName());
    }

    public static class StartDigraphAction
    extends TextAction {
        public StartDigraphAction() {
            super(ExEditorKit.StartDigraph);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ExTextField target = (ExTextField)this.getTextComponent(actionEvent);
            KeyStroke key = ExEditorKit.convert(actionEvent);
            if (key != null && DigraphSequence.isDigraphStart(key)) {
                target.startDigraph(ExEditorKit.convert(actionEvent));
            }
        }
    }

    public static class ToggleInsertReplaceAction
    extends TextAction {
        public ToggleInsertReplaceAction() {
            super(ExEditorKit.ToggleInsertReplace);
            logger.debug("ToggleInsertReplaceAction()");
        }

        public void actionPerformed(ActionEvent e) {
            logger.debug("actionPerformed");
            ExTextField target = (ExTextField)this.getTextComponent(e);
            target.toggleInsertReplace();
        }
    }

    public static class DeleteFromCursorAction
    extends TextAction {
        public DeleteFromCursorAction() {
            super(ExEditorKit.DeleteFromCursor);
        }

        public void actionPerformed(ActionEvent e) {
            ExTextField target = (ExTextField)this.getTextComponent(e);
            target.saveLastEntry();
            Document doc = target.getDocument();
            Caret caret = target.getCaret();
            try {
                doc.remove(caret.getDot(), doc.getLength());
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
        }
    }

    public static class DeleteToCursorAction
    extends TextAction {
        public DeleteToCursorAction() {
            super(ExEditorKit.DeleteToCursor);
        }

        public void actionPerformed(ActionEvent e) {
            ExTextField target = (ExTextField)this.getTextComponent(e);
            target.saveLastEntry();
            Document doc = target.getDocument();
            Caret caret = target.getCaret();
            try {
                doc.remove(0, caret.getDot());
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
        }
    }

    public static class DeletePreviousWordAction
    extends TextAction {
        public DeletePreviousWordAction() {
            super(ExEditorKit.DeletePreviousWord);
        }

        public void actionPerformed(ActionEvent e) {
            ExTextField target = (ExTextField)this.getTextComponent(e);
            target.saveLastEntry();
            Document doc = target.getDocument();
            Caret caret = target.getCaret();
            int offset = SearchHelper.findNextWord(target.getText(), caret.getDot(), target.getText().length(), -1, false, false);
            if (logger.isDebugEnabled()) {
                logger.debug("offset=" + offset);
            }
            try {
                int pos = caret.getDot();
                doc.remove(offset, pos - offset);
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
        }
    }

    public static class DeletePreviousCharAction
    extends TextAction {
        public DeletePreviousCharAction() {
            super(ExEditorKit.DeletePreviousChar);
        }

        public void actionPerformed(ActionEvent e) {
            ExTextField target = (ExTextField)this.getTextComponent(e);
            target.saveLastEntry();
            try {
                Document doc = target.getDocument();
                Caret caret = target.getCaret();
                int dot = caret.getDot();
                int mark = caret.getMark();
                if (dot != mark) {
                    doc.remove(Math.min(dot, mark), Math.abs(dot - mark));
                } else if (dot > 0) {
                    int delChars = 1;
                    if (dot > 1) {
                        String dotChars = doc.getText(dot - 2, 2);
                        char c0 = dotChars.charAt(0);
                        char c1 = dotChars.charAt(1);
                        if (c0 >= '\ud800' && c0 <= '\udbff' && c1 >= '\udc00' && c1 <= '\udfff') {
                            delChars = 2;
                        }
                    }
                    doc.remove(dot - delChars, delChars);
                } else {
                    CommandGroups.getInstance().getProcess().cancelExEntry(ExEntryPanel.getInstance().getEntry().getEditor(), ExEntryPanel.getInstance().getEntry().getContext());
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public static class EscapeCharAction
    extends TextAction {
        public EscapeCharAction() {
            super(ExEditorKit.EscapeChar);
        }

        public void actionPerformed(ActionEvent e) {
            ExTextField target = (ExTextField)this.getTextComponent(e);
            target.escape();
        }
    }

    public static class CancelEntryAction
    extends TextAction {
        public CancelEntryAction() {
            super(ExEditorKit.CancelEntry);
        }

        public void actionPerformed(ActionEvent e) {
            CommandGroups.getInstance().getProcess().cancelExEntry(ExEntryPanel.getInstance().getEntry().getEditor(), ExEntryPanel.getInstance().getEntry().getContext());
        }
    }

    public static class CompleteEntryAction
    extends TextAction {
        public CompleteEntryAction() {
            super(ExEditorKit.CompleteEntry);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            logger.debug("complete entry");
            KeyStroke stroke = KeyStroke.getKeyStroke(10, 0);
            KeyHandler.getInstance().handleKey(ExEntryPanel.getInstance().getEntry().getEditor(), stroke, ExEntryPanel.getInstance().getEntry().getContext());
        }
    }

    public static class InsertRegisterAction
    extends TextAction {
        public InsertRegisterAction() {
            super(ExEditorKit.InsertRegister);
        }

        public void actionPerformed(ActionEvent e) {
            ExTextField target = (ExTextField)this.getTextComponent(e);
            target.saveLastEntry();
        }
    }

    public static class HistoryDownFilterAction
    extends TextAction {
        public HistoryDownFilterAction() {
            super(ExEditorKit.HistoryDownFilter);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ExTextField target = (ExTextField)this.getTextComponent(actionEvent);
            target.selectHistory(false, true);
        }
    }

    public static class HistoryUpFilterAction
    extends TextAction {
        public HistoryUpFilterAction() {
            super(ExEditorKit.HistoryUpFilter);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ExTextField target = (ExTextField)this.getTextComponent(actionEvent);
            target.selectHistory(true, true);
        }
    }

    public static class HistoryDownAction
    extends TextAction {
        public HistoryDownAction() {
            super(ExEditorKit.HistoryDown);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ExTextField target = (ExTextField)this.getTextComponent(actionEvent);
            target.selectHistory(false, false);
        }
    }

    public static class HistoryUpAction
    extends TextAction {
        public HistoryUpAction() {
            super(ExEditorKit.HistoryUp);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ExTextField target = (ExTextField)this.getTextComponent(actionEvent);
            target.selectHistory(true, false);
        }
    }

    public static class DefaultExKeyHandler
    extends DefaultEditorKit.DefaultKeyTypedAction {
        public void actionPerformed(ActionEvent e) {
            ExTextField target = (ExTextField)this.getTextComponent(e);
            KeyStroke key = ExEditorKit.convert(e);
            if (key != null) {
                char ch = target.checkKey(ExEditorKit.convert(e));
                if (ch > '\u0000') {
                    ActionEvent event = new ActionEvent(e.getSource(), e.getID(), "" + ch, e.getWhen(), e.getModifiers());
                    super.actionPerformed(event);
                    target.saveLastEntry();
                }
            } else {
                super.actionPerformed(e);
                target.saveLastEntry();
            }
        }
    }
}

