/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.maddyhome.idea.vim.helper.DataPackage;
import com.maddyhome.idea.vim.ui.ExTextField;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class ExEntryPanel
extends JPanel {
    private JComponent parent;
    private JLabel label;
    private ExTextField entry;
    private JComponent oldGlass;
    private LayoutManager oldLayout;
    private boolean wasOpaque;
    private ComponentAdapter adapter;
    private int count;
    private boolean active;
    private static ExEntryPanel instance;
    private static Logger logger;

    public static ExEntryPanel getInstance() {
        if (instance == null) {
            instance = new ExEntryPanel();
        }
        return instance;
    }

    private ExEntryPanel() {
        this.setBorder(BorderFactory.createEtchedBorder());
        Font font = new Font("Monospaced", 0, 12);
        this.label = new JLabel(" ");
        this.label.setFont(font);
        this.entry = new ExTextField();
        this.entry.setFont(font);
        this.entry.setBorder(null);
        this.setForeground(this.entry.getForeground());
        this.setBackground(this.entry.getBackground());
        this.label.setForeground(this.entry.getForeground());
        this.label.setBackground(this.entry.getBackground());
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(layout);
        gbc.gridx = 0;
        layout.setConstraints(this.label, gbc);
        this.add(this.label);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        layout.setConstraints(this.entry, gbc);
        this.add(this.entry);
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.adapter = new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ExEntryPanel.this.positionPanel();
            }
        };
    }

    public void activate(Editor editor, DataPackage context, String label, String initText, int count) {
        this.entry.setEditor(editor, context);
        this.label.setText(label);
        this.count = count;
        this.entry.setDocument(this.entry.createDefaultModel());
        this.entry.setText(initText);
        this.entry.setType(label);
        this.parent = editor.getContentComponent();
        JRootPane root = SwingUtilities.getRootPane(this.parent);
        this.oldGlass = (JComponent)root.getGlassPane();
        this.oldLayout = this.oldGlass.getLayout();
        this.wasOpaque = this.oldGlass.isOpaque();
        this.oldGlass.setLayout(null);
        this.oldGlass.setOpaque(false);
        this.oldGlass.add(this);
        this.oldGlass.addComponentListener(this.adapter);
        this.positionPanel();
        this.oldGlass.setVisible(true);
        this.entry.requestFocus();
        this.active = true;
    }

    public String getLabel() {
        return this.label.getText();
    }

    public int getCount() {
        return this.count;
    }

    public void handleKey(KeyStroke stroke) {
        this.entry.handleKey(stroke);
    }

    public void processKey(KeyEvent event) {
        this.entry.processKeyEvent(event);
    }

    private void positionPanel() {
        if (this.parent == null) {
            return;
        }
        Container scroll = SwingUtilities.getAncestorOfClass(JScrollPane.class, this.parent);
        int height = (int)this.getPreferredSize().getHeight();
        Rectangle bounds = scroll.getBounds();
        bounds.translate(0, scroll.getHeight() - height);
        bounds.height = height;
        Point pos = SwingUtilities.convertPoint(scroll.getParent(), bounds.getLocation(), this.oldGlass);
        bounds.setLocation(pos);
        this.setBounds(bounds);
        this.repaint();
    }

    public String getText() {
        return this.entry.getText();
    }

    public ExTextField getEntry() {
        return this.entry;
    }

    public void deactivate(boolean changeFocus) {
        logger.info("deactivate");
        if (!this.active) {
            return;
        }
        this.active = false;
        this.oldGlass.removeComponentListener(this.adapter);
        this.oldGlass.setVisible(false);
        this.oldGlass.remove(this);
        this.oldGlass.setOpaque(this.wasOpaque);
        this.oldGlass.setLayout(this.oldLayout);
        this.parent = null;
    }

    public boolean isActive() {
        return this.active;
    }

    static {
        logger = Logger.getInstance((String)ExEntryPanel.class.getName());
    }
}

