/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.group.CommandGroups;
import com.maddyhome.idea.vim.group.HistoryGroup;
import com.maddyhome.idea.vim.helper.DataPackage;
import com.maddyhome.idea.vim.helper.DigraphSequence;
import com.maddyhome.idea.vim.ui.ExDocument;
import com.maddyhome.idea.vim.ui.ExEditorKit;
import com.maddyhome.idea.vim.ui.ExKeyBindings;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.util.Date;
import java.util.List;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import javax.swing.text.Keymap;

public class ExTextField
extends JTextField {
    private Editor editor;
    private DataPackage context;
    private String lastEntry;
    private List<HistoryGroup.HistoryEntry> history;
    private int histIndex = 0;
    private DigraphSequence digraph;
    private static final Logger logger = Logger.getInstance((String)ExTextField.class.getName());

    public ExTextField() {
        Font font = new Font("Monospaced", 0, 12);
        this.setFont(font);
        this.setInputMap(0, new InputMap());
        Keymap map = ExTextField.addKeymap("ex", this.getKeymap());
        ExTextField.loadKeymap(map, ExKeyBindings.getBindings(), this.getActions());
        map.setDefaultAction(new ExEditorKit.DefaultExKeyHandler());
        this.setKeymap(map);
    }

    public void setType(String type) {
        String hkey = null;
        switch (type.charAt(0)) {
            case '/': 
            case '?': {
                hkey = "search";
                break;
            }
            case ':': {
                hkey = "cmd";
            }
        }
        if (hkey != null) {
            this.history = CommandGroups.getInstance().getHistory().getEntries(hkey, 0, 0);
            this.histIndex = this.history.size();
        }
    }

    public void saveLastEntry() {
        this.lastEntry = this.getText();
    }

    public void selectHistory(boolean isUp, boolean filter) {
        int dir;
        int n = dir = isUp ? -1 : 1;
        if (this.histIndex + dir < 0 || this.histIndex + dir > this.history.size()) {
            VimPlugin.indicateError();
            return;
        }
        if (filter) {
            for (int i = this.histIndex + dir; i >= 0 && i <= this.history.size(); i += dir) {
                String txt;
                if (i == this.history.size()) {
                    txt = this.lastEntry;
                } else {
                    HistoryGroup.HistoryEntry entry = this.history.get(i);
                    txt = entry.getEntry();
                }
                if (!txt.startsWith(this.lastEntry)) continue;
                this.updateText(txt);
                this.histIndex = i;
                return;
            }
            VimPlugin.indicateError();
        } else {
            String txt;
            this.histIndex += dir;
            if (this.histIndex == this.history.size()) {
                txt = this.lastEntry;
            } else {
                HistoryGroup.HistoryEntry entry = this.history.get(this.histIndex);
                txt = entry.getEntry();
            }
            this.updateText(txt);
        }
    }

    void setEditor(Editor editor, DataPackage context) {
        this.editor = editor;
        this.context = context;
    }

    public Editor getEditor() {
        return this.editor;
    }

    public DataPackage getContext() {
        return this.context;
    }

    public Action[] getActions() {
        return ExEditorKit.getInstance().getActions();
    }

    public void handleKey(KeyStroke stroke) {
        if (logger.isDebugEnabled()) {
            logger.debug("stroke=" + stroke);
        }
        KeyEvent event = new KeyEvent(this, stroke.getKeyChar() != '\uffff' ? 400 : (stroke.isOnKeyRelease() ? 402 : 401), new Date().getTime(), stroke.getModifiers(), stroke.getKeyCode(), stroke.getKeyChar());
        super.processKeyEvent(event);
    }

    public void updateText(String string) {
        super.setText(string);
    }

    public void setText(String string) {
        super.setText(string);
        this.saveLastEntry();
    }

    protected void processKeyEvent(KeyEvent e) {
        if (logger.isDebugEnabled()) {
            logger.debug("key=" + e);
        }
        super.processKeyEvent(e);
    }

    protected Document createDefaultModel() {
        return new ExDocument();
    }

    public void escape() {
        if (this.digraph != null) {
            this.digraph = null;
        } else {
            CommandGroups.getInstance().getProcess().cancelExEntry(this.editor, this.context);
        }
    }

    public void startDigraph(KeyStroke key) {
        if (this.digraph == null) {
            this.digraph = new DigraphSequence();
            this.digraph.processKey(key, this.editor, this.context);
        }
    }

    public char checkKey(KeyStroke key) {
        if (this.digraph != null) {
            DigraphSequence.DigraphResult res = this.digraph.processKey(key, this.editor, this.context);
            switch (res.getResult()) {
                case 0: {
                    return '\u0000';
                }
                case 1: {
                    this.digraph = null;
                    return '\u0000';
                }
                case 2: {
                    key = res.getStroke();
                    this.digraph = null;
                }
            }
        }
        if (key.getKeyChar() != '\uffff') {
            return key.getKeyChar();
        }
        return '\u0000';
    }

    public void toggleInsertReplace() {
        ExDocument doc = (ExDocument)this.getDocument();
        doc.toggleInsertReplace();
    }
}

