/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.maddyhome.idea.vim.group.CommandGroups;
import com.maddyhome.idea.vim.helper.DataPackage;
import com.maddyhome.idea.vim.helper.EditorData;
import com.maddyhome.idea.vim.helper.EditorDataContext;
import com.maddyhome.idea.vim.option.Options;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class MorePanel
extends JPanel {
    private JLabel label = new JLabel("more");
    private JTextArea text = new JTextArea();
    private JScrollPane scrollPane = new JScrollPane(this.text, 21, 31);
    private ComponentAdapter adapter;
    private Editor editor = null;
    private JComponent parent = null;
    private boolean atEnd = false;
    private int lineHeight = 0;
    private JComponent oldGlass = null;
    private LayoutManager oldLayout = null;
    private boolean wasOpaque = false;
    private boolean active = false;
    private static MorePanel instance;
    private static Logger logger;

    public static MorePanel getInstance() {
        if (instance == null) {
            instance = new MorePanel();
        }
        return instance;
    }

    public static MorePanel getInstance(Editor editor) {
        if (instance == null) {
            instance = new MorePanel();
        }
        instance.setEditor(editor);
        return instance;
    }

    public void setEditor(Editor editor) {
        this.editor = editor;
        this.parent = editor.getContentComponent();
    }

    private MorePanel() {
        BorderLayout layout = new BorderLayout(0, 0);
        this.setLayout(layout);
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.label, "South");
        Font font = new Font("Monospaced", 0, 12);
        this.text.setFont(font);
        this.label.setFont(font);
        this.text.setBorder(null);
        this.scrollPane.setBorder(null);
        this.label.setForeground(this.text.getForeground());
        this.label.setBackground(this.text.getBackground());
        this.setForeground(this.text.getForeground());
        this.setBackground(this.text.getBackground());
        this.text.setEditable(false);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.adapter = new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                MorePanel.this.positionPanel();
            }
        };
        MoreKeyListener moreKeyListener = new MoreKeyListener(this);
        this.addKeyListener(moreKeyListener);
        this.text.addKeyListener(moreKeyListener);
    }

    public int getDisplayWidth() {
        Container scroll = SwingUtilities.getAncestorOfClass(JScrollPane.class, this.parent);
        int width = scroll.getSize().width;
        if (logger.isDebugEnabled()) {
            logger.debug("width=" + width);
        }
        int charWidth = this.text.getFontMetrics(this.text.getFont()).charWidth('M');
        return width / charWidth;
    }

    public boolean hasText() {
        return this.text.getText().length() > 0;
    }

    public String getText() {
        return this.text.getText();
    }

    public void setText(String data) {
        if (data.length() > 0 && data.charAt(data.length() - 1) == '\n') {
            data = data.substring(0, data.length() - 1);
        }
        this.text.setText(data);
        this.text.setCaretPosition(0);
    }

    public void activate() {
        JRootPane root = SwingUtilities.getRootPane(this.parent);
        this.oldGlass = (JComponent)root.getGlassPane();
        this.oldLayout = this.oldGlass.getLayout();
        this.wasOpaque = this.oldGlass.isOpaque();
        this.oldGlass.setLayout(null);
        this.oldGlass.setOpaque(false);
        this.oldGlass.add(this);
        this.oldGlass.addComponentListener(this.adapter);
        this.positionPanel();
        this.oldGlass.setVisible(true);
        this.active = true;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MorePanel.this.text.requestFocus();
                    }
                });
            }
        });
    }

    public void deactivate(boolean changeFocus) {
        logger.info("deactivate");
        if (!this.active) {
            return;
        }
        this.active = false;
        this.text.setText("");
        this.oldGlass.removeComponentListener(this.adapter);
        this.oldGlass.setVisible(false);
        this.oldGlass.remove(this);
        this.oldGlass.setOpaque(this.wasOpaque);
        this.oldGlass.setLayout(this.oldLayout);
        this.parent.requestFocus();
        this.parent = null;
    }

    public boolean isActive() {
        return this.active;
    }

    private static int countLines(String text) {
        if (text.length() == 0) {
            return 0;
        }
        int count = 0;
        int pos = -1;
        while ((pos = text.indexOf(10, pos + 1)) != -1) {
            ++count;
        }
        if (text.charAt(text.length() - 1) != '\n') {
            ++count;
        }
        return count;
    }

    private void scrollLine() {
        this.scrollOffset(this.lineHeight);
    }

    private void scrollPage() {
        this.scrollOffset(this.scrollPane.getVerticalScrollBar().getVisibleAmount());
    }

    private void scrollHalfPage() {
        double sa = (double)this.scrollPane.getVerticalScrollBar().getVisibleAmount() / 2.0;
        double offset = Math.ceil(sa / (double)this.lineHeight) * (double)this.lineHeight;
        this.scrollOffset((int)offset);
    }

    private void handleEnter() {
        if (this.atEnd) {
            this.close();
        } else {
            this.scrollLine();
        }
    }

    private void badKey() {
        this.label.setText("-- MORE -- (RET: line, SPACE: page, d: half page, q: quit)");
    }

    private void scrollOffset(int more) {
        this.atEnd = false;
        int val = this.scrollPane.getVerticalScrollBar().getValue();
        this.scrollPane.getVerticalScrollBar().setValue(val + more);
        this.scrollPane.getHorizontalScrollBar().setValue(0);
        if (logger.isDebugEnabled()) {
            logger.debug("val=" + val);
            logger.debug("more=" + more);
            logger.debug("scrollPane.getVerticalScrollBar().getMaximum()=" + this.scrollPane.getVerticalScrollBar().getMaximum());
            logger.debug("scrollPane.getVerticalScrollBar().getVisibleAmount()=" + this.scrollPane.getVerticalScrollBar().getVisibleAmount());
        }
        if (val + more >= this.scrollPane.getVerticalScrollBar().getMaximum() - this.scrollPane.getVerticalScrollBar().getVisibleAmount()) {
            this.atEnd = true;
            this.label.setText("Hit ENTER or type command to continue");
        } else {
            this.label.setText("-- MORE --");
        }
    }

    private void positionPanel() {
        if (this.parent == null) {
            return;
        }
        Container scroll = SwingUtilities.getAncestorOfClass(JScrollPane.class, this.parent);
        this.setSize(scroll.getSize());
        this.lineHeight = this.text.getFontMetrics(this.text.getFont()).getHeight();
        int count = MorePanel.countLines(this.text.getText());
        int visLines = this.getSize().height / this.lineHeight - 1;
        if (logger.isDebugEnabled()) {
            logger.debug("size.height=" + this.getSize().height);
            logger.debug("lineHeight=" + this.lineHeight);
            logger.debug("count=" + count);
            logger.debug("visLines=" + visLines);
        }
        int lines = Math.min(count, visLines);
        this.setSize(this.getSize().width, lines * this.lineHeight + this.label.getPreferredSize().height + this.getBorder().getBorderInsets((Component)this).top * 2);
        this.scrollPane.getVerticalScrollBar().setValues(0, visLines, 0, count - 1);
        int height = this.getSize().height;
        Rectangle bounds = scroll.getBounds();
        bounds.translate(0, scroll.getHeight() - height);
        bounds.height = height;
        Point pos = SwingUtilities.convertPoint(scroll.getParent(), bounds.getLocation(), SwingUtilities.getRootPane(this.parent).getGlassPane());
        bounds.setLocation(pos);
        this.setBounds(bounds);
        this.scrollPane.getVerticalScrollBar().setValue(0);
        if (!Options.getInstance().isSet("more")) {
            this.scrollOffset(100000);
        } else {
            this.scrollOffset(0);
        }
    }

    private void close() {
        this.close(null);
    }

    private void close(final KeyEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MorePanel.this.deactivate(false);
                VirtualFile vf = EditorData.getVirtualFile(MorePanel.this.editor);
                if (vf != null) {
                    FileEditorManager.getInstance((Project)EditorData.getProject(MorePanel.this.editor)).openFile(vf, true);
                }
                if (e != null && e.getKeyChar() != '\n') {
                    KeyStroke key = KeyStroke.getKeyStrokeForEvent(e);
                    Project project = EditorData.getProject(MorePanel.this.editor);
                    ArrayList<KeyStroke> keys = new ArrayList<KeyStroke>(1);
                    keys.add(key);
                    CommandGroups.getInstance().getMacro().playbackKeys(MorePanel.this.editor, new DataPackage(new EditorDataContext(MorePanel.this.editor)), project, keys, 0, 0, 1);
                }
            }
        });
    }

    static {
        logger = Logger.getInstance((String)MorePanel.class.getName());
    }

    private static class MoreKeyListener
    extends KeyAdapter {
        private MorePanel parent;

        public MoreKeyListener(MorePanel parent) {
            this.parent = parent;
        }

        public void keyTyped(KeyEvent e) {
            if (this.parent.atEnd) {
                this.parent.close(e);
            } else {
                switch (e.getKeyChar()) {
                    case ' ': {
                        this.parent.scrollPage();
                        break;
                    }
                    case 'd': {
                        this.parent.scrollHalfPage();
                        break;
                    }
                    case 'q': {
                        this.parent.close();
                        break;
                    }
                    case '\n': {
                        this.parent.handleEnter();
                        break;
                    }
                    case '\u001b': {
                        this.parent.close();
                        break;
                    }
                    case '\uffff': {
                        switch (e.getKeyCode()) {
                            case 10: {
                                this.parent.handleEnter();
                                break;
                            }
                            case 27: {
                                this.parent.close();
                                break;
                            }
                            default: {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("e.getKeyCode()=" + e.getKeyCode());
                                }
                                this.parent.badKey();
                            }
                        }
                    }
                    default: {
                        if (logger.isDebugEnabled()) {
                            logger.debug("e.getKeyChar()=" + e.getKeyChar());
                        }
                        this.parent.badKey();
                    }
                }
            }
        }
    }
}

