/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ui;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.keymap.KeymapUtil;
import com.maddyhome.idea.vim.VimSettings;
import com.maddyhome.idea.vim.key.KeyConflict;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VimSettingsPanel {
    private JPanel mainPanel;
    private JTable keys;
    private JCheckBox pluginEnable;
    private JScrollPane scrollPane;

    public VimSettingsPanel() {
        this.setupControls();
    }

    public JComponent getMainComponent() {
        return this.mainPanel;
    }

    public void setOptions(VimSettings options, HashMap<KeyStroke, KeyConflict> conflicts) {
        this.pluginEnable.setSelected(options.isEnabled());
        this.keys.setModel(new ConflictTableModel(conflicts));
        this.sizeColumns();
        this.scrollPane.getVerticalScrollBar().setValue(0);
    }

    private void sizeColumns() {
        TableColumn choice = this.keys.getColumn(this.keys.getColumnName(0));
        choice.sizeWidthToFit();
        TableColumn key = this.keys.getColumn(this.keys.getColumnName(1));
        key.sizeWidthToFit();
        int width = this.getPreferredWidthForColumn(choice);
        choice.setMinWidth(width);
        choice.setMaxWidth(width);
        width = this.getPreferredWidthForColumn(key);
        key.setMinWidth(width);
        key.setMaxWidth(width);
        this.keys.sizeColumnsToFit(0);
    }

    private int getPreferredWidthForColumn(TableColumn column) {
        return Math.max(this.columnHeaderWidth(column), this.widestCellInColumn(column));
    }

    private int widestCellInColumn(TableColumn column) {
        int c = column.getModelIndex();
        int res = 0;
        TableCellRenderer renderer = this.keys.getDefaultRenderer(this.keys.getColumnClass(c));
        for (int r = 0; r < this.keys.getRowCount(); ++r) {
            int width = renderer.getTableCellRendererComponent((JTable)this.keys, (Object)this.keys.getValueAt((int)r, (int)c), (boolean)false, (boolean)false, (int)r, (int)c).getPreferredSize().width;
            res = Math.max(res, width);
        }
        return res;
    }

    private int columnHeaderWidth(TableColumn column) {
        TableCellRenderer renderer = this.keys.getTableHeader().getDefaultRenderer();
        return renderer.getTableCellRendererComponent((JTable)this.keys, (Object)column.getHeaderValue(), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width + 2;
    }

    public VimSettings getOptions() {
        VimSettings res = new VimSettings();
        res.setEnabled(this.pluginEnable.isSelected());
        res.setChoices(((ConflictTableModel)this.keys.getModel()).getChoices());
        return res;
    }

    public boolean isModified(VimSettings options) {
        return !this.getOptions().equals(options);
    }

    private void setupControls() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConflictTableModel
    extends AbstractTableModel {
        boolean[] orig;
        KeyStroke[] keystokes;
        Object[][] data;
        String[] labels = new String[]{"Use IDEA Action", "KeyStroke", "IDEA Actions", "VIM Actions"};

        public ConflictTableModel(HashMap<KeyStroke, KeyConflict> conflicts) {
            TreeMap<String, KeyStroke> keys = new TreeMap<String, KeyStroke>();
            for (KeyStroke stroke : conflicts.keySet()) {
                KeyConflict conf = conflicts.get(stroke);
                if (!conf.hasConflict()) continue;
                keys.put(KeymapUtil.getKeystrokeText((KeyStroke)stroke), stroke);
            }
            this.orig = new boolean[keys.size()];
            this.keystokes = new KeyStroke[keys.size()];
            this.data = new Object[keys.size()][4];
            ActionManager mgr = ActionManager.getInstance();
            Iterator iter = keys.keySet().iterator();
            int i = 0;
            while (iter.hasNext()) {
                String keyLabel = (String)iter.next();
                KeyStroke stroke = (KeyStroke)keys.get(keyLabel);
                KeyConflict conf = conflicts.get(stroke);
                this.orig[i] = !conf.isPluginWins();
                this.keystokes[i] = stroke;
                this.data[i][0] = !conf.isPluginWins();
                this.data[i][1] = keyLabel;
                TreeSet<String> actions = new TreeSet<String>();
                for (String id : conf.getIdeaActions().keySet()) {
                    Presentation pres;
                    String desc = null;
                    AnAction act = mgr.getAction(id);
                    if (act != null && (pres = act.getTemplatePresentation()) != null) {
                        desc = pres.getText();
                    }
                    if (desc == null) continue;
                    actions.add(desc);
                }
                this.data[i][2] = actions.toString();
                actions = new TreeSet();
                List<String> pacts = conf.getPluginActions();
                for (String id : pacts) {
                    actions.add(mgr.getAction(id).getTemplatePresentation().getText());
                }
                this.data[i][3] = actions.toString();
                ++i;
            }
        }

        public HashSet getChoices() {
            HashSet<KeyStroke> res = new HashSet<KeyStroke>();
            for (int i = 0; i < this.getRowCount(); ++i) {
                Boolean val = (Boolean)this.getValueAt(i, 0);
                if (!val.booleanValue()) continue;
                res.add(this.keystokes[i]);
            }
            return res;
        }

        @Override
        public int getColumnCount() {
            return this.labels.length;
        }

        @Override
        public int getRowCount() {
            return this.data == null ? 0 : this.data.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }

        public Class getColumnClass(int col) {
            return col == 0 ? Boolean.class : String.class;
        }

        @Override
        public void setValueAt(Object object, int row, int col) {
            this.data[row][col] = object;
        }

        @Override
        public String getColumnName(int col) {
            return this.labels[col];
        }
    }
}

