/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.undo;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.maddyhome.idea.vim.helper.DataPackage;

public class DocumentChange {
    private int offset;
    private String oldText;
    private String newText;
    private static Logger logger = Logger.getInstance((String)DocumentChange.class.getName());

    public DocumentChange(int offset, String oldText, String newText) {
        this.offset = offset;
        this.oldText = oldText;
        this.newText = newText;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getOldText() {
        return this.oldText;
    }

    public String getNewText() {
        return this.newText;
    }

    public void redo(Editor editor, DataPackage context) {
        if (this.oldText.length() > 0) {
            if (this.newText.length() > 0) {
                editor.getDocument().replaceString(this.offset, this.offset + this.oldText.length(), (CharSequence)this.newText);
            } else {
                editor.getDocument().deleteString(this.offset, this.offset + this.oldText.length());
            }
        } else if (this.newText.length() > 0) {
            editor.getDocument().insertString(this.offset, (CharSequence)this.newText);
        }
    }

    public void undo(Editor editor, DataPackage context) {
        if (logger.isDebugEnabled()) {
            logger.debug("undo command = " + this);
        }
        if (this.oldText.length() > 0) {
            if (this.newText.length() > 0) {
                editor.getDocument().replaceString(this.offset, this.offset + this.newText.length(), (CharSequence)this.oldText);
            } else {
                editor.getDocument().insertString(this.offset, (CharSequence)this.oldText);
            }
        } else if (this.newText.length() > 0) {
            editor.getDocument().deleteString(this.offset, this.offset + this.newText.length());
        }
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("DocumentChange[");
        res.append("offset=").append(this.offset);
        res.append(", oldText=\"").append(this.oldText);
        res.append("\", newText=\"").append(this.newText);
        res.append("\"]");
        return res.toString();
    }
}

