/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.undo;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.maddyhome.idea.vim.helper.DataPackage;
import com.maddyhome.idea.vim.helper.DocumentManager;
import com.maddyhome.idea.vim.option.NumberOption;
import com.maddyhome.idea.vim.option.Options;
import com.maddyhome.idea.vim.undo.DocumentChange;
import com.maddyhome.idea.vim.undo.UndoCommand;
import java.util.ArrayList;
import java.util.List;

public class EditorUndoList {
    private UndoCommand currentCommand;
    private List<UndoCommand> undos = new ArrayList<UndoCommand>();
    private int pointer = 0;
    private boolean inUndo = false;
    private boolean restorable = true;
    private static Logger logger = Logger.getInstance((String)EditorUndoList.class.getName());

    public EditorUndoList(Editor editor) {
        this.beginCommand(editor);
    }

    public void documentSaved() {
        this.restorable = this.pointer == 0;
    }

    public boolean inCommand() {
        return this.currentCommand != null;
    }

    public void beginCommand(Editor editor) {
        logger.info("beginCommand");
        if (this.inCommand()) {
            this.endCommand();
        }
        this.currentCommand = new UndoCommand(editor);
    }

    public void abortCommand() {
        logger.info("abortCommand");
        this.currentCommand = null;
    }

    public void endCommand() {
        logger.info("endCommand");
        if (this.currentCommand != null && this.currentCommand.size() > 0) {
            logger.debug("ended");
            int max = this.getMaxUndos();
            if (max == 0) {
                this.undos.clear();
                this.undos.add(this.currentCommand);
            } else {
                while (this.pointer < this.undos.size()) {
                    this.undos.remove(this.pointer);
                }
                this.undos.add(this.currentCommand);
                if (this.undos.size() > max) {
                    this.undos.remove(0);
                }
            }
            this.currentCommand.complete();
            this.pointer = this.undos.size();
            if (logger.isDebugEnabled()) {
                logger.debug("this=" + this);
            }
        }
        this.currentCommand = null;
    }

    public int size() {
        return this.currentCommand == null ? 0 : this.currentCommand.size();
    }

    public void addChange(DocumentChange change) {
        logger.info("addChange");
        if (!this.inUndo && this.currentCommand != null) {
            logger.info("added");
            this.currentCommand.addChange(change);
        }
    }

    public boolean redo(Editor editor, DataPackage context) {
        if (this.pointer < this.undos.size()) {
            UndoCommand cmd = this.undos.get(this.pointer);
            if (logger.isDebugEnabled()) {
                logger.debug("redo command " + this.pointer);
            }
            ++this.pointer;
            this.inUndo = true;
            cmd.redo(editor, context);
            this.inUndo = false;
            return true;
        }
        return false;
    }

    public boolean undo(Editor editor, DataPackage context) {
        if (this.pointer == 0 && this.getMaxUndos() == 0) {
            return this.redo(editor, context);
        }
        if (this.pointer > 0) {
            --this.pointer;
            UndoCommand cmd = this.undos.get(this.pointer);
            if (logger.isDebugEnabled()) {
                logger.debug("undo command " + this.pointer);
            }
            this.inUndo = true;
            cmd.undo(editor, context);
            this.inUndo = false;
            if (this.pointer == 0 && this.restorable) {
                Project p = context.getProject();
                DocumentManager.getInstance().reloadDocument(editor.getDocument(), p);
            }
            return true;
        }
        return false;
    }

    public boolean undoLine(Editor editor, DataPackage context) {
        if (this.pointer == 0 && this.getMaxUndos() == 0) {
            return this.redo(editor, context);
        }
        if (this.pointer > 0) {
            int lastLine = -1;
            --this.pointer;
            UndoCommand cmd = this.undos.get(this.pointer);
            if (logger.isDebugEnabled()) {
                logger.debug("undo command " + this.pointer);
            }
            while (cmd.isOneLine() && (lastLine == -1 || cmd.getLine() == lastLine)) {
                lastLine = cmd.getLine();
                this.inUndo = true;
                cmd.undo(editor, context);
                this.inUndo = false;
                if (this.pointer <= 0) break;
                --this.pointer;
                cmd = this.undos.get(this.pointer);
            }
            return true;
        }
        return false;
    }

    private int getMaxUndos() {
        return ((NumberOption)Options.getInstance().getOption("undolevels")).value();
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("EditorUndoList[");
        res.append("pointer=").append(this.pointer);
        res.append(", undos=").append(this.undos);
        res.append("]");
        return res.toString();
    }
}

