/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.undo;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.maddyhome.idea.vim.group.MotionGroup;
import com.maddyhome.idea.vim.helper.DataPackage;
import com.maddyhome.idea.vim.undo.DocumentChange;
import java.util.ArrayList;
import java.util.List;

public class UndoCommand {
    private Editor editor;
    private int startOffset;
    private int endOffset;
    private List<DocumentChange> changes = new ArrayList<DocumentChange>();
    private static Logger logger = Logger.getInstance((String)UndoCommand.class.getName());

    public UndoCommand(Editor editor) {
        this.editor = editor;
        this.startOffset = editor.getCaretModel().getOffset();
        if (logger.isDebugEnabled()) {
            logger.debug("new undo command: startOffset=" + this.startOffset);
        }
    }

    public void complete() {
        this.endOffset = this.editor.getCaretModel().getOffset();
    }

    public boolean isOneLine() {
        return false;
    }

    public int getLine() {
        return -1;
    }

    public void addChange(DocumentChange change) {
        logger.debug("new change");
        if (this.changes.size() == 0 && logger.isDebugEnabled()) {
            logger.debug("startOffest=" + this.startOffset);
        }
        this.changes.add(change);
    }

    public void redo(Editor editor, DataPackage context) {
        for (DocumentChange change : this.changes) {
            change.redo(editor, context);
        }
        MotionGroup.moveCaret(editor, context, this.endOffset);
    }

    public void undo(Editor editor, DataPackage context) {
        if (logger.isDebugEnabled()) {
            logger.debug("undo: startOffset=" + this.startOffset);
        }
        for (int i = this.changes.size() - 1; i >= 0; --i) {
            DocumentChange change = this.changes.get(i);
            change.undo(editor, context);
        }
        MotionGroup.moveCaret(editor, context, this.startOffset);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("UndoCommand");
        sb.append("{startOffset=").append(this.startOffset);
        sb.append(", endOffset=").append(this.endOffset);
        sb.append(", changes=").append(this.changes);
        sb.append('}');
        return sb.toString();
    }

    public int size() {
        return this.changes.size();
    }
}

