/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.undo;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.EditorFactoryAdapter;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.helper.DataPackage;
import com.maddyhome.idea.vim.helper.EditorData;
import com.maddyhome.idea.vim.undo.DocumentChange;
import com.maddyhome.idea.vim.undo.EditorUndoList;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UndoManager {
    private HashMap<Document, EditorUndoList> editors = new HashMap();
    private HashMap<Document, HashSet<Editor>> documents = new HashMap();
    private boolean allow = true;
    private static UndoManager instance;
    private static Logger logger;

    public static UndoManager getInstance() {
        if (instance == null) {
            instance = new UndoManager();
        }
        return instance;
    }

    public UndoManager() {
        EditorFactory.getInstance().addEditorFactoryListener((EditorFactoryListener)new UndoEditorCloseListener());
        FileDocumentManager.getInstance().addFileDocumentManagerListener((FileDocumentManagerListener)new FileDocumentListener());
    }

    public boolean inCommand(Editor editor) {
        EditorUndoList list = this.getEditorUndoList(editor);
        return list.inCommand();
    }

    public void allowNewCommands(boolean allow) {
        this.allow = allow;
    }

    public boolean allowNewCommands() {
        return this.allow;
    }

    public void beginCommand(Editor editor) {
        if (this.allow) {
            logger.debug("begin command");
            EditorUndoList list = this.getEditorUndoList(editor);
            list.beginCommand(editor);
        }
    }

    public void abortCommand(Editor editor) {
        if (this.allow) {
            EditorUndoList list = this.getEditorUndoList(editor);
            list.abortCommand();
        }
    }

    public void endCommand(Editor editor) {
        if (this.allow) {
            EditorUndoList list = this.getEditorUndoList(editor);
            list.endCommand();
            if (logger.isDebugEnabled()) {
                logger.debug("endCommand: list=" + list);
            }
        }
    }

    public boolean hasChanges(Editor editor) {
        EditorUndoList list = this.getEditorUndoList(editor);
        return list.size() > 0;
    }

    public boolean undo(Editor editor, DataPackage context) {
        logger.debug("undo");
        EditorUndoList list = this.getEditorUndoList(editor);
        boolean res = list.undo(editor, context);
        if (logger.isDebugEnabled()) {
            logger.debug("undo: list=" + list);
        }
        return res;
    }

    public boolean undoLine(Editor editor, DataPackage context) {
        logger.debug("undoLine");
        EditorUndoList list = this.getEditorUndoList(editor);
        boolean res = list.undoLine(editor, context);
        if (logger.isDebugEnabled()) {
            logger.debug("undo: list=" + list);
        }
        return res;
    }

    public boolean redo(Editor editor, DataPackage context) {
        EditorUndoList list = this.getEditorUndoList(editor);
        boolean res = list.redo(editor, context);
        if (logger.isDebugEnabled()) {
            logger.debug("redo: list=" + list);
        }
        return res;
    }

    public void editorOpened(Editor editor) {
        logger.info("editorOpened");
        if (!editor.isViewer()) {
            this.addEditorUndoList(editor);
        }
    }

    public void editorClosed(Editor editor) {
        logger.info("editorClosed");
        if (!editor.isViewer()) {
            this.removeEditorUndoList(editor);
        }
    }

    public HashMap<Document, EditorUndoList> getEditors() {
        return this.editors;
    }

    private EditorUndoList addEditorUndoList(Editor editor) {
        EditorUndoList res;
        HashSet<Object> tors = this.documents.get(editor.getDocument());
        if (tors == null) {
            tors = new HashSet();
            this.documents.put(editor.getDocument(), tors);
            res = new EditorUndoList(editor);
            this.editors.put(editor.getDocument(), res);
        } else {
            res = this.editors.get(editor.getDocument());
        }
        tors.add(editor);
        return res;
    }

    private void removeEditorUndoList(Editor editor) {
        HashSet<Editor> tors = this.documents.get(editor.getDocument());
        if (tors != null) {
            tors.remove(editor);
            if (tors.isEmpty()) {
                this.documents.remove(editor.getDocument());
                this.editors.remove(editor.getDocument());
            }
        }
    }

    private EditorUndoList getEditorUndoList(Editor editor) {
        EditorUndoList res = this.editors.get(editor.getDocument());
        if (res == null) {
            if (logger.isDebugEnabled()) {
                VirtualFile vf = EditorData.getVirtualFile(editor);
                if (vf != null) {
                    logger.info("Creating new undo list for " + vf.getPath());
                } else {
                    logger.info("Creating new undo list for editor with no virtual file");
                }
            }
            res = this.addEditorUndoList(editor);
        }
        return res;
    }

    static {
        logger = Logger.getInstance((String)UndoManager.class.getName());
    }

    private class FileDocumentListener
    extends FileDocumentManagerAdapter {
        private FileDocumentListener() {
        }

        public void beforeDocumentSaving(Document document) {
            EditorUndoList list = UndoManager.getInstance().getEditors().get(document);
            if (list != null) {
                list.documentSaved();
            }
        }
    }

    public static class UndoEditorCloseListener
    extends EditorFactoryAdapter {
        public void editorReleased(EditorFactoryEvent event) {
            UndoManager.getInstance().removeEditorUndoList(event.getEditor());
        }
    }

    public static class DocumentChangeListener
    extends DocumentAdapter {
        public void documentChanged(DocumentEvent event) {
            if (!VimPlugin.isEnabled()) {
                return;
            }
            EditorUndoList list = UndoManager.getInstance().getEditors().get(event.getDocument());
            if (logger.isDebugEnabled()) {
                logger.debug("Change: list=" + list);
            }
            if (list != null) {
                list.addChange(new DocumentChange(event.getOffset(), ((Object)event.getOldFragment()).toString(), ((Object)event.getNewFragment()).toString()));
            }
        }
    }
}

