/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.osmorc.ModuleChangeListener;

public class ModuleChangeHandler
implements ProjectComponent {
    @NotNull
    private final Project project;
    @NotNull
    private final Map<Module, String> moduleNames;
    @NotNull
    private final ModuleChangeListener[] moduleChangeListeners;

    public ModuleChangeHandler(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/ModuleChangeHandler.<init> must not be null");
        }
        this.project = project;
        this.moduleNames = new HashMap<Module, String>();
        this.moduleChangeListeners = (ModuleChangeListener[])Extensions.getExtensions((ExtensionPointName)new ExtensionPointName("Osmorc.moduleChangeListener"));
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    @NotNull
    public String getComponentName() {
        if ("ModuleChangeHandler" == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/ModuleChangeHandler.getComponentName must not return null");
        }
        return "ModuleChangeHandler";
    }

    public void initComponent() {
        MessageBusConnection connection = this.project.getMessageBus().connect((Disposable)this.project);
        connection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void moduleAdded(Project project, Module module) {
                if (ModuleChangeHandler.this.project == project) {
                    ModuleChangeHandler.this.moduleNames.put(module, module.getName());
                }
            }

            public void beforeModuleRemoved(Project project, Module module) {
            }

            public void moduleRemoved(Project project, Module module) {
                if (ModuleChangeHandler.this.project == project) {
                    ModuleChangeHandler.this.moduleNames.remove(module);
                    ModuleChangeHandler.this.fireModuleRemoved(module);
                }
            }

            public void modulesRenamed(Project project, List<Module> modules) {
                assert (modules != null);
                if (ModuleChangeHandler.this.project == project) {
                    for (Module module : modules) {
                        String oldName = (String)ModuleChangeHandler.this.moduleNames.get(module);
                        if (oldName == null) {
                            throw new RuntimeException("Unknown module renamed " + module.getName());
                        }
                        ModuleChangeHandler.this.fireModuleRenamed(module, oldName);
                        ModuleChangeHandler.this.moduleNames.put(module, module.getName());
                    }
                }
            }
        });
    }

    private void fireModuleRemoved(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/ModuleChangeHandler.fireModuleRemoved must not be null");
        }
        for (ModuleChangeListener listener : this.moduleChangeListeners) {
            listener.moduleRemoved(module);
        }
    }

    private void fireModuleRenamed(@NotNull Module module, @NotNull String oldName) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/ModuleChangeHandler.fireModuleRenamed must not be null");
        }
        if (oldName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/ModuleChangeHandler.fireModuleRenamed must not be null");
        }
        for (ModuleChangeListener listener : this.moduleChangeListeners) {
            listener.moduleRenamed(module, oldName);
        }
    }

    public void disposeComponent() {
    }
}

