/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerAdapter;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleComponent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.osmorc.AdditionalJARContentsWatcherManager;
import org.osmorc.BundleManager;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.facet.OsmorcFacetConfiguration;
import org.osmorc.facet.OsmorcFacetType;
import org.osmorc.frameworkintegration.FrameworkInstanceModuleManager;

public class OsmorcModuleComponent
implements ModuleComponent {
    private MessageBusConnection connection;
    private final Module myModule;
    private final BundleManager myBundleManager;
    private FrameworkInstanceModuleManager myFrameworkInstanceModuleManager;
    private final AdditionalJARContentsWatcherManager myAdditionalJARContentsWatcherManager;
    private final Application myApplication;
    private boolean disposed;

    public OsmorcModuleComponent(Module module, BundleManager bundleManager, FrameworkInstanceModuleManager frameworkInstanceModuleManager, AdditionalJARContentsWatcherManager additionalJARContentsWatcherManager, Application application) {
        this.myModule = module;
        this.myBundleManager = bundleManager;
        this.myFrameworkInstanceModuleManager = frameworkInstanceModuleManager;
        this.myAdditionalJARContentsWatcherManager = additionalJARContentsWatcherManager;
        this.myApplication = application;
        this.disposed = false;
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("OsmorcModuleComponent" == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/OsmorcModuleComponent.getComponentName must not return null");
        }
        return "OsmorcModuleComponent";
    }

    public void initComponent() {
        this.disposed = false;
        this.connection = this.myModule.getMessageBus().connect();
        this.connection.subscribe(FacetManager.FACETS_TOPIC, (Object)new FacetManagerAdapter(){

            public void facetAdded(@NotNull Facet facet) {
                if (facet == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/OsmorcModuleComponent$1.facetAdded must not be null");
                }
                OsmorcModuleComponent.this.handleFacetChange(facet);
            }

            public void facetRemoved(@NotNull Facet facet) {
                if (facet == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/OsmorcModuleComponent$1.facetRemoved must not be null");
                }
                OsmorcModuleComponent.this.myFrameworkInstanceModuleManager.updateFrameworkInstanceModule();
            }

            public void facetConfigurationChanged(@NotNull Facet facet) {
                if (facet == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/OsmorcModuleComponent$1.facetConfigurationChanged must not be null");
                }
                OsmorcModuleComponent.this.handleFacetChange(facet);
            }
        });
    }

    public void disposeComponent() {
        if (this.connection != null) {
            this.connection.disconnect();
        }
        this.disposed = true;
    }

    public void projectOpened() {
        this.myApplication.invokeLater(new Runnable(){

            public void run() {
                if (!OsmorcModuleComponent.this.disposed && OsmorcFacet.hasOsmorcFacet(OsmorcModuleComponent.this.myModule)) {
                    OsmorcModuleComponent.this.buildManuallyEditedManifestIndex();
                    OsmorcModuleComponent.this.updateModuleDependencyIndex();
                }
            }
        });
    }

    public void projectClosed() {
        this.myAdditionalJARContentsWatcherManager.dispose();
    }

    public void moduleAdded() {
    }

    private void updateModuleDependencyIndex() {
        this.myApplication.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                if (indicator != null) {
                    indicator.setText("Updating OSGi dependency index for module '" + OsmorcModuleComponent.this.myModule.getName() + "'");
                }
                ModifiableRootModel model = (ModifiableRootModel)new ReadAction<ModifiableRootModel>(){

                    protected void run(Result<ModifiableRootModel> result) throws Throwable {
                        ModifiableRootModel model = ModuleRootManager.getInstance((Module)OsmorcModuleComponent.this.myModule).getModifiableModel();
                        result.setResult((Object)model);
                    }
                }.execute().getResultObject();
                OrderEntry[] entries = model.getOrderEntries();
                try {
                    int entriesLength = entries.length;
                    for (int i = 0; i < entriesLength; ++i) {
                        Library library;
                        OrderEntry entry;
                        if (indicator != null) {
                            indicator.setFraction((double)(i / entriesLength));
                        }
                        if (!((entry = entries[i]) instanceof LibraryOrderEntry) || (library = ((LibraryOrderEntry)entry).getLibrary()) == null) continue;
                        OsmorcModuleComponent.this.myBundleManager.addOrUpdateBundle(library);
                    }
                }
                finally {
                    model.dispose();
                }
            }
        });
    }

    private void buildManuallyEditedManifestIndex() {
        OsmorcFacet facet = OsmorcFacet.getInstance(this.myModule);
        if (facet != null && ((OsmorcFacetConfiguration)facet.getConfiguration()).isManifestManuallyEdited()) {
            this.myApplication.invokeLater(new Runnable(){

                public void run() {
                    ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                    if (indicator != null) {
                        indicator.setIndeterminate(true);
                        indicator.setText("Updating manifest indices.");
                    }
                    OsmorcModuleComponent.this.myBundleManager.addOrUpdateBundle(OsmorcModuleComponent.this.myModule);
                }
            });
        }
    }

    private void handleFacetChange(Facet facet) {
        if (!this.disposed && facet.getTypeId() == OsmorcFacetType.ID) {
            if (facet.getModule().getProject().isInitialized()) {
                this.myFrameworkInstanceModuleManager.updateFrameworkInstanceModule();
                this.buildManuallyEditedManifestIndex();
            }
            this.myAdditionalJARContentsWatcherManager.updateWatcherSetup();
        }
    }
}

