/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import org.jetbrains.annotations.NotNull;
import org.osmorc.BundleManager;
import org.osmorc.frameworkintegration.FrameworkInstanceModuleManager;
import org.osmorc.manifest.lang.psi.ManifestFile;
import org.osmorc.settings.ProjectSettings;

public class OsmorcProjectComponent
implements ProjectComponent,
ProjectSettings.ProjectSettingsListener {
    private final BundleManager bundleManager;
    private final ProjectSettings projectSettings;
    private final Project project;
    private final Application application;
    private FrameworkInstanceModuleManager frameworkInstanceModuleManager;

    public OsmorcProjectComponent(BundleManager bundleManager, ProjectSettings projectSettings, Project project, Application application, FrameworkInstanceModuleManager frameworkInstanceModuleManager) {
        this.bundleManager = bundleManager;
        this.projectSettings = projectSettings;
        this.project = project;
        this.application = application;
        this.frameworkInstanceModuleManager = frameworkInstanceModuleManager;
    }

    @NotNull
    public String getComponentName() {
        if ("OsmorcProjectComponent" == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/OsmorcProjectComponent.getComponentName must not return null");
        }
        return "OsmorcProjectComponent";
    }

    public void initComponent() {
        PsiManager.getInstance((Project)this.project).addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeChangeAdapter(){

            public void childrenChanged(PsiTreeChangeEvent event) {
                OsmorcProjectComponent.this.processChange(event);
            }

            public void childAdded(PsiTreeChangeEvent event) {
                OsmorcProjectComponent.this.processChange(event);
            }

            public void childRemoved(PsiTreeChangeEvent event) {
                OsmorcProjectComponent.this.processChange(event);
            }

            public void childReplaced(PsiTreeChangeEvent event) {
                OsmorcProjectComponent.this.processChange(event);
            }
        });
        this.projectSettings.addProjectSettingsListener(this);
    }

    public void disposeComponent() {
        this.projectSettings.removeProjectSettingsListener(this);
    }

    public void projectOpened() {
        this.frameworkInstanceModuleManager.updateFrameworkInstanceModule();
    }

    public void projectClosed() {
    }

    private void processChange(PsiTreeChangeEvent event) {
        final PsiFile file = event.getFile();
        if (!(file instanceof ManifestFile)) {
            return;
        }
        Runnable onChangeRunnable = new Runnable(){

            public void run() {
                Module moduleOfChangedManifest = ModuleUtil.findModuleForPsiElement((PsiElement)file);
                if (moduleOfChangedManifest != null) {
                    OsmorcProjectComponent.this.bundleManager.addOrUpdateBundle(moduleOfChangedManifest);
                }
            }
        };
        if (ApplicationManager.getApplication().isCommandLine()) {
            onChangeRunnable.run();
        } else {
            this.application.invokeLater(onChangeRunnable);
        }
    }

    private void runFrameworkInstanceUpdate(boolean onlyIfFrameworkInstanceSelectionChanged) {
        if (this.bundleManager.reloadFrameworkInstanceLibraries(onlyIfFrameworkInstanceSelectionChanged)) {
            this.frameworkInstanceModuleManager.updateFrameworkInstanceModule();
        }
    }

    public void projectSettingsChanged() {
        this.runFrameworkInstanceUpdate(true);
    }
}

