/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osmorc.facet.OsmorcFacetConfiguration;
import org.osmorc.facet.OsmorcFacetType;
import org.osmorc.settings.ProjectSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmorcFacet
extends Facet<OsmorcFacetConfiguration> {
    public OsmorcFacet(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/facet/OsmorcFacet.<init> must not be null");
        }
        this(FacetTypeRegistry.getInstance().findFacetType(OsmorcFacetType.ID), module, new OsmorcFacetConfiguration(), null, "OSGi");
    }

    public OsmorcFacet(@NotNull FacetType facetType, @NotNull Module module, @NotNull OsmorcFacetConfiguration configuration, Facet underlyingFacet, String name) {
        if (facetType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/facet/OsmorcFacet.<init> must not be null");
        }
        if (module == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/facet/OsmorcFacet.<init> must not be null");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/osmorc/facet/OsmorcFacet.<init> must not be null");
        }
        super(facetType, module, name, (FacetConfiguration)configuration, underlyingFacet);
    }

    @Nullable
    public static OsmorcFacet getInstance(Module module) {
        return (OsmorcFacet)FacetManager.getInstance((Module)module).getFacetByType(OsmorcFacetType.ID);
    }

    public static OsmorcFacet getInstance(PsiElement element) {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
        return OsmorcFacet.getInstance(module);
    }

    public static boolean hasOsmorcFacet(Module module) {
        return OsmorcFacet.getInstance(module) != null;
    }

    public static boolean hasOsmorcFacet(PsiElement element) {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
        return module != null && OsmorcFacet.hasOsmorcFacet(module);
    }

    public String getManifestLocation() {
        if (((OsmorcFacetConfiguration)this.getConfiguration()).isUseProjectDefaultManifestFileLocation()) {
            ProjectSettings projectSettings = (ProjectSettings)ModuleServiceManager.getService((Module)this.getModule(), ProjectSettings.class);
            return projectSettings.getDefaultManifestFileLocation();
        }
        return ((OsmorcFacetConfiguration)this.getConfiguration()).getManifestLocation();
    }
}

