/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.facet;

import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.osmorc.facet.ui.OsmorcFacetGeneralEditorTab;
import org.osmorc.facet.ui.OsmorcFacetJAREditorTab;
import org.osmorc.facet.ui.OsmorcFacetManifestGenerationEditorTab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmorcFacetConfiguration
implements FacetConfiguration {
    private boolean _osmorcControlsManifest = true;
    private String _manifestLocation;
    private String _jarFileLocation;
    private String _bundleSymbolicName;
    private String _bundleActivator;
    private String _bundleVersion;
    private String _additionalProperties;
    private List<Pair<String, String>> _additionalJARContents;
    private boolean _useProjectDefaultManifestFileLocation = true;
    private boolean _useBndFile;
    private String _bndFileLocation;
    private boolean _useBundlorFile;
    private String _bundlorFileLocation;
    private String _ignoreFilePattern;
    private boolean _alwaysRebuildBundleJAR;
    private static final String OSMORC_CONTROLS_MANIFEST = "osmorcControlsManifest";
    private static final String USE_BND_FILE = "useBndFile";
    private static final String BND_FILE_LOCATION = "bndFileLocation";
    private static final String USE_BUNDLOR_FILE = "useBundlorFile";
    private static final String BUNDLOR_FILE_LOCATION = "bundlorFileLocation";
    private static final String MANIFEST_LOCATION = "manifestLocation";
    private static final String JARFILE_LOCATION = "jarfileLocation";
    private static final String BUNDLE_ACTIVATOR = "bundleActivator";
    private static final String BUNDLE_SYMBOLIC_NAME = "bundleSymbolicName";
    private static final String BUNDLE_VERSION = "bundleVersion";
    private static final String USE_PROJECT_DEFAULT_MANIFEST_FILE_LOCATION = "useProjectDefaultManifestFileLocation";
    private static final String ADDITIONAL_PROPERTIES = "additionalProperties";
    private static final String IGNORE_FILE_PATTERN = "ignoreFilePattern";
    private static final String ALWAYS_REBUILD_BUNDLE_JAR = "alwaysRebuildBundleJAR";
    private static final String PROPERTY = "property";
    private static final String KEY = "key";
    private static final String VALUE = "value";

    public FacetEditorTab[] createEditorTabs(FacetEditorContext editorContext, FacetValidatorsManager validatorsManager) {
        return new FacetEditorTab[]{new OsmorcFacetGeneralEditorTab(editorContext), new OsmorcFacetJAREditorTab(editorContext), new OsmorcFacetManifestGenerationEditorTab(editorContext)};
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.setOsmorcControlsManifest(Boolean.parseBoolean(element.getAttributeValue(OSMORC_CONTROLS_MANIFEST, "true")));
        this.setUseBndFile(Boolean.parseBoolean(element.getAttributeValue(USE_BND_FILE, "false")));
        this.setBndFileLocation(element.getAttributeValue(BND_FILE_LOCATION));
        this.setUseBundlorFile(Boolean.parseBoolean(element.getAttributeValue(USE_BUNDLOR_FILE, "false")));
        this.setBundlorFileLocation(element.getAttributeValue(BUNDLOR_FILE_LOCATION));
        this.setManifestLocation(element.getAttributeValue(MANIFEST_LOCATION));
        this.setJarFileLocation(element.getAttributeValue(JARFILE_LOCATION));
        this.setBundleActivator(element.getAttributeValue(BUNDLE_ACTIVATOR));
        this.setBundleSymbolicName(element.getAttributeValue(BUNDLE_SYMBOLIC_NAME));
        this.setBundleVersion(element.getAttributeValue(BUNDLE_VERSION));
        this.setIgnoreFilePattern(element.getAttributeValue(IGNORE_FILE_PATTERN));
        this.setUseProjectDefaultManifestFileLocation(Boolean.parseBoolean(element.getAttributeValue(USE_PROJECT_DEFAULT_MANIFEST_FILE_LOCATION, "true")));
        this.setAlwaysRebuildBundleJAR(Boolean.parseBoolean(element.getAttributeValue(ALWAYS_REBUILD_BUNDLE_JAR, "false")));
        Element props = element.getChild(ADDITIONAL_PROPERTIES);
        if (props != null) {
            List children = props.getChildren();
            if (children.isEmpty()) {
                this.setAdditionalProperties(props.getText());
            } else {
                StringBuilder builder = new StringBuilder();
                for (Object child : children) {
                    Element prop = (Element)child;
                    builder.append(prop.getAttributeValue(KEY)).append(":").append(prop.getAttributeValue(VALUE)).append("\n");
                }
                this.setAdditionalProperties(builder.toString());
            }
        }
        List<Pair<String, String>> additionalJARContents = this.getAdditionalJARContents();
        Element additionalJARContentsElement = element.getChild("additionalJARContents");
        if (additionalJARContentsElement != null) {
            List children = additionalJARContentsElement.getChildren("entry");
            for (Element entryElement : children) {
                additionalJARContents.add((Pair<String, String>)Pair.create((Object)entryElement.getAttributeValue("source"), (Object)entryElement.getAttributeValue("dest")));
            }
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        String[] lines;
        element.setAttribute(OSMORC_CONTROLS_MANIFEST, String.valueOf(this.isOsmorcControlsManifest()));
        element.setAttribute(MANIFEST_LOCATION, this.getManifestLocation());
        element.setAttribute(JARFILE_LOCATION, this.getJarFileLocation());
        element.setAttribute(USE_BND_FILE, String.valueOf(this.isUseBndFile()));
        element.setAttribute(BND_FILE_LOCATION, this.getBndFileLocation());
        element.setAttribute(USE_BUNDLOR_FILE, String.valueOf(this.isUseBundlorFile()));
        element.setAttribute(BUNDLOR_FILE_LOCATION, this.getBundlorFileLocation());
        element.setAttribute(BUNDLE_ACTIVATOR, this.getBundleActivator());
        element.setAttribute(BUNDLE_SYMBOLIC_NAME, this.getBundleSymbolicName());
        element.setAttribute(BUNDLE_VERSION, this.getBundleVersion());
        element.setAttribute(IGNORE_FILE_PATTERN, this.getIgnoreFilePattern());
        element.setAttribute(USE_PROJECT_DEFAULT_MANIFEST_FILE_LOCATION, String.valueOf(this.isUseProjectDefaultManifestFileLocation()));
        element.setAttribute(ALWAYS_REBUILD_BUNDLE_JAR, String.valueOf(this.isAlwaysRebuildBundleJAR()));
        Element props = new Element(ADDITIONAL_PROPERTIES);
        for (String line : lines = this.getAdditionalProperties().split("\n")) {
            int sep = line.indexOf(58);
            if (sep == -1) continue;
            String key = line.substring(0, sep).trim();
            String value = line.substring(sep + 1).trim();
            Element prop = new Element(PROPERTY);
            prop.setAttribute(KEY, key);
            prop.setAttribute(VALUE, value);
            props.addContent(prop);
        }
        element.addContent(props);
        Element additionalJARContentsElement = new Element("additionalJARContents");
        List<Pair<String, String>> additionalJARContents = this.getAdditionalJARContents();
        for (Pair<String, String> additionalJARContent : additionalJARContents) {
            Element entry = new Element("entry");
            entry.setAttribute("source", (String)additionalJARContent.getFirst());
            entry.setAttribute("dest", (String)additionalJARContent.getSecond());
            additionalJARContentsElement.addContent(entry);
        }
        element.addContent(additionalJARContentsElement);
    }

    public boolean isOsmorcControlsManifest() {
        return this._osmorcControlsManifest;
    }

    public boolean isManifestManuallyEdited() {
        return !this._osmorcControlsManifest;
    }

    public void setOsmorcControlsManifest(boolean osmorcControlsManifest) {
        this._osmorcControlsManifest = osmorcControlsManifest;
    }

    @NotNull
    public String getManifestLocation() {
        String string = this._manifestLocation != null ? this._manifestLocation : "";
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/facet/OsmorcFacetConfiguration.getManifestLocation must not return null");
        }
        return string;
    }

    public void setManifestLocation(String manifestLocation) {
        this._manifestLocation = manifestLocation;
    }

    @NotNull
    public String getJarFileLocation() {
        String string = this._jarFileLocation != null ? this._jarFileLocation : "";
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/facet/OsmorcFacetConfiguration.getJarFileLocation must not return null");
        }
        return string;
    }

    public void setJarFileLocation(String jarFileLocation) {
        this._jarFileLocation = jarFileLocation;
    }

    @NotNull
    public String getBundleSymbolicName() {
        String string = this._bundleSymbolicName != null ? this._bundleSymbolicName : "";
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/facet/OsmorcFacetConfiguration.getBundleSymbolicName must not return null");
        }
        return string;
    }

    public void setBundleSymbolicName(String bundleSymbolicName) {
        this._bundleSymbolicName = bundleSymbolicName;
    }

    public String getBundleActivator() {
        return this._bundleActivator != null ? this._bundleActivator : "";
    }

    public void setBundleActivator(String bundleActivator) {
        this._bundleActivator = bundleActivator;
    }

    @NotNull
    public String getBundleVersion() {
        String string = this._bundleVersion != null ? this._bundleVersion : "1.0.0";
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/facet/OsmorcFacetConfiguration.getBundleVersion must not return null");
        }
        return string;
    }

    public void setBundleVersion(String bundleVersion) {
        this._bundleVersion = bundleVersion;
    }

    public void setAdditionalProperties(String additionalProperties) {
        this._additionalProperties = additionalProperties;
    }

    @NotNull
    public String getAdditionalProperties() {
        String string = this._additionalProperties != null ? this._additionalProperties : "";
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/facet/OsmorcFacetConfiguration.getAdditionalProperties must not return null");
        }
        return string;
    }

    public String asManifestString() {
        return "Bundle-SymbolicName:" + this.getBundleSymbolicName() + "\n" + "Bundle-Version" + ":" + this.getBundleVersion() + "\n" + "Bundle-Activator" + ":" + this.getBundleActivator() + "\n" + this.getAdditionalProperties() + "\n";
    }

    @NotNull
    public Map<String, String> getAdditionalPropertiesAsMap() {
        String[] lines;
        HashMap<String, String> result = new HashMap<String, String>();
        for (String line : lines = this.getAdditionalProperties().split("\n")) {
            int sep = line.indexOf(58);
            if (sep == -1) continue;
            String key = line.substring(0, sep).trim();
            String value = line.substring(sep + 1).trim();
            result.put(key, value);
        }
        HashMap<String, String> hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/facet/OsmorcFacetConfiguration.getAdditionalPropertiesAsMap must not return null");
        }
        return hashMap;
    }

    public void importAdditionalProperties(Map<String, String> properties, boolean overwrite) {
        Map<String, String> existing;
        Map<String, String> map = existing = overwrite ? properties : this.getAdditionalPropertiesAsMap();
        if (!overwrite) {
            existing.putAll(properties);
        }
        StringBuilder builder = new StringBuilder();
        for (String s : existing.keySet()) {
            builder.append(s).append(": ").append(existing.get(s)).append("\n");
        }
        this.setAdditionalProperties(builder.toString());
    }

    public void setUseProjectDefaultManifestFileLocation(boolean useProjectDefaultManifestFileLocation) {
        this._useProjectDefaultManifestFileLocation = useProjectDefaultManifestFileLocation;
    }

    public boolean isUseProjectDefaultManifestFileLocation() {
        return this._useProjectDefaultManifestFileLocation;
    }

    public boolean isUseBndFile() {
        return this._useBndFile;
    }

    public void setUseBndFile(boolean useBndFile) {
        this._useBndFile = useBndFile;
    }

    @NotNull
    public String getBndFileLocation() {
        String string = this._bndFileLocation != null ? this._bndFileLocation : "";
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/facet/OsmorcFacetConfiguration.getBndFileLocation must not return null");
        }
        return string;
    }

    public void setBndFileLocation(String bndFileLocation) {
        this._bndFileLocation = bndFileLocation;
    }

    public boolean isUseBundlorFile() {
        return this._useBundlorFile;
    }

    public void setUseBundlorFile(boolean _useBundlorFile) {
        this._useBundlorFile = _useBundlorFile;
    }

    @NotNull
    public String getBundlorFileLocation() {
        String string = this._bundlorFileLocation != null ? this._bundlorFileLocation : "";
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/facet/OsmorcFacetConfiguration.getBundlorFileLocation must not return null");
        }
        return string;
    }

    public void setBundlorFileLocation(String _bundlorFileLocation) {
        this._bundlorFileLocation = _bundlorFileLocation;
    }

    @NotNull
    public List<Pair<String, String>> getAdditionalJARContents() {
        if (this._additionalJARContents == null) {
            this._additionalJARContents = new ArrayList<Pair<String, String>>();
        }
        List<Pair<String, String>> list = this._additionalJARContents;
        if (list == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/facet/OsmorcFacetConfiguration.getAdditionalJARContents must not return null");
        }
        return list;
    }

    public void setAdditionalJARContents(@NotNull List<Pair<String, String>> additionalJARContents) {
        if (additionalJARContents == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/facet/OsmorcFacetConfiguration.setAdditionalJARContents must not be null");
        }
        this._additionalJARContents = additionalJARContents;
    }

    public void setIgnoreFilePattern(String attributeValue) {
        this._ignoreFilePattern = attributeValue;
    }

    public String getIgnoreFilePattern() {
        return this._ignoreFilePattern != null ? this._ignoreFilePattern : "";
    }

    public boolean isAlwaysRebuildBundleJAR() {
        return this._alwaysRebuildBundleJAR;
    }

    public void setAlwaysRebuildBundleJAR(boolean alwaysRebuildBundleJAR) {
        this._alwaysRebuildBundleJAR = alwaysRebuildBundleJAR;
    }

    public boolean isIgnorePatternValid() {
        if (this._ignoreFilePattern == null || this._ignoreFilePattern.equals("")) {
            return true;
        }
        try {
            Pattern p = Pattern.compile(this._ignoreFilePattern);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

