/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.facet;

import com.intellij.openapi.application.Application;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.facet.OsmorcFacetConfiguration;
import org.osmorc.facet.OsmorcFacetUtil;

public class OsmorcFacetRefactoringListenerProvider
implements RefactoringElementListenerProvider {
    private OsmorcFacetUtil osmorcFacetUtil;
    private Application application;

    public OsmorcFacetRefactoringListenerProvider(OsmorcFacetUtil osmorcFacetUtil, Application application) {
        this.osmorcFacetUtil = osmorcFacetUtil;
        this.application = application;
    }

    @Nullable
    public RefactoringElementListener getListener(PsiElement element) {
        if (element instanceof PsiClass && this.osmorcFacetUtil.hasOsmorcFacet(element)) {
            OsmorcFacet osmorcFacet = this.osmorcFacetUtil.getOsmorcFacet(element);
            OsmorcFacetConfiguration osmorcFacetConfiguration = (OsmorcFacetConfiguration)osmorcFacet.getConfiguration();
            PsiClass psiClass = (PsiClass)element;
            if (osmorcFacetConfiguration.isOsmorcControlsManifest() && osmorcFacetConfiguration.getBundleActivator() != null && osmorcFacetConfiguration.getBundleActivator().equals(psiClass.getQualifiedName())) {
                return new ActivatorClassRefactoringListener(osmorcFacetConfiguration, this.application);
            }
        }
        return null;
    }

    private static final class ActivatorClassRefactoringListener
    implements RefactoringElementListener {
        private OsmorcFacetConfiguration osmorcFacetConfiguration;
        private Application application;

        private ActivatorClassRefactoringListener(OsmorcFacetConfiguration osmorcFacetConfiguration, Application application) {
            this.osmorcFacetConfiguration = osmorcFacetConfiguration;
            this.application = application;
        }

        public void elementMoved(@NotNull PsiElement newElement) {
            if (newElement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/facet/OsmorcFacetRefactoringListenerProvider$ActivatorClassRefactoringListener.elementMoved must not be null");
            }
            this.updateActivatorName(newElement);
        }

        public void elementRenamed(@NotNull PsiElement newElement) {
            if (newElement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/facet/OsmorcFacetRefactoringListenerProvider$ActivatorClassRefactoringListener.elementRenamed must not be null");
            }
            this.updateActivatorName(newElement);
        }

        private void updateActivatorName(final @NotNull PsiElement newElement) {
            if (newElement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/facet/OsmorcFacetRefactoringListenerProvider$ActivatorClassRefactoringListener.updateActivatorName must not be null");
            }
            this.application.runWriteAction(new Runnable(){

                public void run() {
                    ActivatorClassRefactoringListener.this.osmorcFacetConfiguration.setBundleActivator(((PsiClass)newElement).getQualifiedName());
                }
            });
        }
    }
}

