/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetModel;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.autodetecting.FacetDetector;
import com.intellij.facet.autodetecting.FacetDetectorRegistry;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.facet.OsmorcFacetConfiguration;
import org.osmorc.i18n.OsmorcBundle;
import org.osmorc.manifest.ManifestFileTypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmorcFacetType
extends FacetType<OsmorcFacet, OsmorcFacetConfiguration> {
    public static final FacetTypeId<OsmorcFacet> ID = new FacetTypeId("Osmorc");
    public static final OsmorcFacetType INSTANCE = new OsmorcFacetType();
    private final Logger logger = Logger.getInstance((String)"#org.osmorc.facet.OsmorcFacetType");
    private final String[] DETECTION_HEADERS = new String[]{"Bundle-SymbolicName"};

    protected OsmorcFacetType() {
        super(ID, "Osmorc", "OSGi");
    }

    public OsmorcFacetConfiguration createDefaultConfiguration() {
        return new OsmorcFacetConfiguration();
    }

    public OsmorcFacet createFacet(@NotNull Module module, String name, @NotNull OsmorcFacetConfiguration configuration, @Nullable Facet underlyingFacet) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/facet/OsmorcFacetType.createFacet must not be null");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/osmorc/facet/OsmorcFacetType.createFacet must not be null");
        }
        this.completeDefaultConfiguration(configuration, module);
        return new OsmorcFacet(this, module, configuration, underlyingFacet, name);
    }

    public boolean isSuitableModuleType(ModuleType moduleType) {
        return moduleType instanceof JavaModuleType;
    }

    private void completeDefaultConfiguration(final OsmorcFacetConfiguration configuration, final Module module) {
        if (configuration.getJarFileLocation().length() == 0) {
            final String outputPathUrl = CompilerModuleExtension.getInstance((Module)module).getCompilerOutputUrl();
            StartupManager.getInstance((Project)module.getProject()).runWhenProjectIsInitialized(new Runnable(){

                public void run() {
                    try {
                        VfsUtil.createDirectories((String)VfsUtil.urlToPath((String)outputPathUrl));
                    }
                    catch (IOException e) {
                        return;
                    }
                    VirtualFile moduleCompilerOutputPath = CompilerModuleExtension.getInstance((Module)module).getCompilerOutputPath();
                    if (moduleCompilerOutputPath == null) {
                        return;
                    }
                    String jarFileName = module.getName();
                    jarFileName = jarFileName.replaceAll("[\\s]", "_");
                    String jarFilePath = new File(moduleCompilerOutputPath.getParent().getPath(), jarFileName + ".jar").getAbsolutePath().replace('\\', '/');
                    configuration.setJarFileLocation(jarFilePath);
                }
            });
        }
    }

    public Icon getIcon() {
        return OsmorcBundle.getSmallIcon();
    }

    public void registerDetectors(FacetDetectorRegistry<OsmorcFacetConfiguration> osmorcFacetConfigurationFacetDetectorRegistry) {
        VirtualFileFilter virtualFileFilter = new VirtualFileFilter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean accept(VirtualFile file) {
                ArrayList<String> headersToDetect = new ArrayList<String>(Arrays.asList(OsmorcFacetType.this.DETECTION_HEADERS));
                if (file != null && file.exists() && !file.isDirectory()) {
                    BufferedReader bufferedReader = null;
                    try {
                        InputStream inputStream = file.getInputStream();
                        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                        bufferedReader = new BufferedReader(inputStreamReader);
                        block11: while (bufferedReader.ready() && headersToDetect.size() > 0) {
                            String line = bufferedReader.readLine();
                            if (line == null) {
                                break;
                            }
                            Iterator headersToDetectIterator = headersToDetect.iterator();
                            while (headersToDetectIterator.hasNext()) {
                                String headertoDeteect = (String)headersToDetectIterator.next();
                                if (!line.startsWith(headertoDeteect)) continue;
                                headersToDetectIterator.remove();
                                continue block11;
                            }
                        }
                    }
                    catch (IOException e) {
                        OsmorcFacetType.this.logger.warn("There was an unexpected exception when accessing " + file.getName() + " (" + e.getMessage() + ")");
                        boolean bl = false;
                        return bl;
                    }
                    finally {
                        if (bufferedReader != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (IOException e) {
                                OsmorcFacetType.this.logger.warn("There was an unexpected exception when closing stream to " + file.getName() + " (" + e.getMessage() + ")");
                                return false;
                            }
                        }
                    }
                }
                return headersToDetect.size() == 0;
            }
        };
        FacetDetector<VirtualFile, OsmorcFacetConfiguration> detector = new FacetDetector<VirtualFile, OsmorcFacetConfiguration>("Osmorc"){

            public OsmorcFacetConfiguration detectFacet(VirtualFile source, Collection<OsmorcFacetConfiguration> existentFacetConfigurations) {
                if (!existentFacetConfigurations.isEmpty()) {
                    return existentFacetConfigurations.iterator().next();
                }
                OsmorcFacetConfiguration osmorcFacetConfiguration = OsmorcFacetType.this.createDefaultConfiguration();
                osmorcFacetConfiguration.setOsmorcControlsManifest(false);
                osmorcFacetConfiguration.setManifestLocation(source.getPath());
                osmorcFacetConfiguration.setUseProjectDefaultManifestFileLocation(false);
                return osmorcFacetConfiguration;
            }

            public void beforeFacetAdded(@NotNull Facet facet, FacetModel facetModel, @NotNull ModifiableRootModel modifiableRootModel) {
                if (facet == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/facet/OsmorcFacetType$3.beforeFacetAdded must not be null");
                }
                if (modifiableRootModel == null) {
                    throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/osmorc/facet/OsmorcFacetType$3.beforeFacetAdded must not be null");
                }
                super.beforeFacetAdded(facet, facetModel, modifiableRootModel);
                VirtualFile[] contentRoots = modifiableRootModel.getContentRoots();
                OsmorcFacet osmorcFacet = (OsmorcFacet)facet;
                OsmorcFacetConfiguration osmorcFacetConfiguration = (OsmorcFacetConfiguration)osmorcFacet.getConfiguration();
                VirtualFile manifestFile = LocalFileSystem.getInstance().findFileByPath(osmorcFacetConfiguration.getManifestLocation());
                if (manifestFile != null) {
                    for (VirtualFile contentRoot : contentRoots) {
                        if (!VfsUtil.isAncestor((VirtualFile)contentRoot, (VirtualFile)manifestFile, (boolean)false)) continue;
                        osmorcFacetConfiguration.setManifestLocation(VfsUtil.getRelativePath((VirtualFile)manifestFile, (VirtualFile)contentRoot, (char)'/'));
                        break;
                    }
                } else {
                    osmorcFacetConfiguration.setManifestLocation("");
                    osmorcFacetConfiguration.setUseProjectDefaultManifestFileLocation(true);
                }
                String manifestFileName = osmorcFacetConfiguration.getManifestLocation();
                if (manifestFileName.endsWith("template.mf")) {
                    osmorcFacetConfiguration.setManifestLocation("");
                    osmorcFacetConfiguration.setBundlorFileLocation(manifestFileName);
                    osmorcFacetConfiguration.setUseBundlorFile(true);
                }
            }
        };
        osmorcFacetConfigurationFacetDetectorRegistry.registerUniversalDetector((FileType)ManifestFileTypeFactory.MANIFEST, virtualFileFilter, (FacetDetector)detector);
    }
}

