/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.facet.maven;

import com.intellij.facet.FacetType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.jgoodies.binding.beans.BeanUtils;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.idea.maven.importing.FacetImporter;
import org.jetbrains.idea.maven.importing.MavenModifiableModelsProvider;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.project.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenId;
import org.jetbrains.idea.maven.project.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.facet.OsmorcFacetConfiguration;
import org.osmorc.facet.OsmorcFacetType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmorcFacetImporter
extends FacetImporter<OsmorcFacet, OsmorcFacetConfiguration, OsmorcFacetType> {
    private final Logger logger = Logger.getInstance((String)"#org.osmorc.facet.maven.OsmorcFacetImporter");

    public OsmorcFacetImporter() {
        super("org.apache.felix", "maven-bundle-plugin", (FacetType)OsmorcFacetType.INSTANCE, "OSGi");
    }

    public boolean isApplicable(MavenProject mavenProjectModel) {
        MavenPlugin p = mavenProjectModel.findPlugin(this.myPluginGroupID, this.myPluginArtifactID);
        String packaging = mavenProjectModel.getPackaging();
        return p != null && packaging != null && "bundle".equals(packaging);
    }

    protected void setupFacet(OsmorcFacet osmorcFacet, MavenProject mavenProjectModel) {
    }

    protected void reimportFacet(MavenModifiableModelsProvider modelsProvider, Module module, MavenRootModelAdapter mavenRootModelAdapter, OsmorcFacet osmorcFacet, MavenProjectsTree mavenProjectsTree, MavenProject mavenProject, MavenProjectChanges changes, Map<MavenProject, String> mavenProjectStringMap, List<MavenProjectsProcessorTask> mavenProjectsProcessorPostConfigurationTasks) {
        OsmorcFacetConfiguration conf = (OsmorcFacetConfiguration)osmorcFacet.getConfiguration();
        MavenPlugin p = mavenProject.findPlugin(this.myPluginGroupID, this.myPluginArtifactID);
        MavenId id = mavenProject.getMavenId();
        conf.setBundleSymbolicName(id.getGroupId() + "." + id.getArtifactId());
        conf.setBundleVersion(id.getVersion());
        if (p != null) {
            this.logger.debug("Plugin found.");
            this.setConfigProperty(mavenProject, conf, "bundleSymbolicName", "instructions.Bundle-SymbolicName");
            this.setConfigProperty(mavenProject, conf, "bundleVersion", "instructions.Bundle-Version");
            this.setConfigProperty(mavenProject, conf, "bundleActivator", "instructions.Bundle-Activator");
            Element instructionsNode = this.getConfig(mavenProject, "instructions");
            if (instructionsNode != null) {
                HashMap<String, String> props = new HashMap<String, String>();
                List children = instructionsNode.getChildren();
                for (Element child : children) {
                    String name = child.getName();
                    String value = child.getValue();
                    if (value == null || "".equals(value) || "Bundle-SymbolicName".equals(name) || "Bundle-Version".equals(name) || "Bundle-Activator".equals(name)) continue;
                    props.put(name, value);
                }
                conf.importAdditionalProperties(props, false);
            }
        }
    }

    private void setConfigProperty(MavenProject mavenProjectModel, OsmorcFacetConfiguration conf, String confProperty, String mavenConfProperty) {
        String value = this.findConfigValue(mavenProjectModel, mavenConfProperty);
        if (value != null && !"".equals(value)) {
            try {
                BeanUtils.setValue((Object)conf, (PropertyDescriptor)BeanUtils.getPropertyDescriptor(OsmorcFacetConfiguration.class, (String)confProperty), (Object)value);
            }
            catch (Exception e) {
                this.logger.error("Problem when setting property", (Throwable)e);
            }
        }
    }

    public boolean isSupportedDependency(MavenArtifact artifact) {
        String t = artifact.getType();
        return t.equalsIgnoreCase("bundle");
    }
}

