/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.facet.ui;

import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ResourceBundle;
import java.util.jar.Attributes;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.osgi.framework.Version;
import org.osmorc.facet.OsmorcFacetConfiguration;
import org.osmorc.settings.MyErrorText;
import org.osmorc.settings.ProjectSettings;

public class OsmorcFacetGeneralEditorTab
extends FacetEditorTab {
    private JRadioButton _manuallyEditedRadioButton;
    private JRadioButton _controlledByOsmorcRadioButton;
    private TextFieldWithBrowseButton _manifestFileChooser;
    private JPanel _root;
    private JRadioButton _useProjectDefaultManifestFileLocation;
    private JRadioButton _useModuleSpecificManifestFileLocation;
    private JRadioButton _useBndFileRadioButton;
    private JPanel _manifestPanel;
    private TextFieldWithBrowseButton _bndFile;
    private JPanel _bndPanel;
    private JPanel _warningPanel;
    private JButton _createButton;
    private MyErrorText _errorText;
    private JRadioButton _useBundlorFileRadioButton;
    private TextFieldWithBrowseButton _bundlorFile;
    private JPanel _bundlorPanel;
    private boolean _modified;
    private final FacetEditorContext _editorContext;
    private Module _module;
    static final Key<Boolean> MANUAL_MANIFEST_EDITING_KEY = Key.create((String)"MANUAL_MANIFEST_EDITING");
    static final Key<Boolean> BND_CREATION_KEY = Key.create((String)"BND_CREATION");
    static final Key<Boolean> BUNDLOR_CREATION_KEY = Key.create((String)"BUNDLOR_CREATION");

    public OsmorcFacetGeneralEditorTab(FacetEditorContext editorContext) {
        this._editorContext = editorContext;
        this.$$$setupUI$$$();
        this._module = editorContext.getModule();
        this._manifestFileChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OsmorcFacetGeneralEditorTab.this.onManifestFileSelect();
            }
        });
        this._bndFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OsmorcFacetGeneralEditorTab.this.selectBuildFile(OsmorcFacetGeneralEditorTab.this._bndFile);
            }
        });
        this._bundlorFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OsmorcFacetGeneralEditorTab.this.selectBuildFile(OsmorcFacetGeneralEditorTab.this._bundlorFile);
            }
        });
        ChangeListener listener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                OsmorcFacetGeneralEditorTab.this.updateGui();
            }
        };
        this._manuallyEditedRadioButton.addChangeListener(listener);
        this._useBndFileRadioButton.addChangeListener(listener);
        this._useBundlorFileRadioButton.addChangeListener(listener);
        this._controlledByOsmorcRadioButton.addChangeListener(listener);
        UserActivityWatcher watcher = new UserActivityWatcher();
        watcher.addUserActivityListener(new UserActivityListener(){

            public void stateChanged() {
                OsmorcFacetGeneralEditorTab.this._modified = true;
                OsmorcFacetGeneralEditorTab.this.checkFileExisting();
            }
        });
        watcher.register((Component)this._root);
        this._useProjectDefaultManifestFileLocation.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                OsmorcFacetGeneralEditorTab.this.onUseProjectDefaultManifestFileLocationChanged();
            }
        });
        this._createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OsmorcFacetGeneralEditorTab.this.tryCreateBundleManifest();
                OsmorcFacetGeneralEditorTab.this.checkFileExisting();
            }
        });
    }

    private void updateGui() {
        boolean isBnd = this._useBndFileRadioButton.isSelected();
        boolean isBundlor = this._useBundlorFileRadioButton.isSelected();
        boolean isManuallyEdited = this._manuallyEditedRadioButton.isSelected();
        this._editorContext.putUserData(MANUAL_MANIFEST_EDITING_KEY, (Object)isManuallyEdited);
        this._editorContext.putUserData(BND_CREATION_KEY, (Object)isBnd);
        this._editorContext.putUserData(BUNDLOR_CREATION_KEY, (Object)isBundlor);
        this._bndPanel.setEnabled(isBnd);
        this._bundlorPanel.setEnabled(isBundlor);
        this._manifestPanel.setEnabled(isManuallyEdited);
        this._useProjectDefaultManifestFileLocation.setEnabled(isManuallyEdited);
        this._useModuleSpecificManifestFileLocation.setEnabled(isManuallyEdited);
        this._manifestFileChooser.setEnabled(isManuallyEdited && !this._useProjectDefaultManifestFileLocation.isSelected());
        this._bndFile.setEnabled(isBnd);
        this._bundlorFile.setEnabled(isBundlor);
        this.checkFileExisting();
    }

    private void onUseProjectDefaultManifestFileLocationChanged() {
        this._manifestFileChooser.setEnabled(!this._useProjectDefaultManifestFileLocation.isSelected());
        this._modified = true;
    }

    private void onManifestFileSelect() {
        VirtualFile manifestFileLocation;
        VirtualFile[] roots = OsmorcFacetGeneralEditorTab.getContentRoots(this._module);
        VirtualFile currentFile = OsmorcFacetGeneralEditorTab.findFileInContentRoots(this._manifestFileChooser.getText(), this._module);
        VirtualFile[] result = FileChooser.chooseFiles((Project)this._editorContext.getProject(), (FileChooserDescriptor)new FileChooserDescriptor(true, true, false, false, false, false), (VirtualFile)currentFile);
        if (result.length == 1 && (manifestFileLocation = result[0]) != null) {
            for (VirtualFile root : roots) {
                String relativePath = VfsUtil.getRelativePath((VirtualFile)manifestFileLocation, (VirtualFile)root, (char)File.separatorChar);
                if (relativePath == null) continue;
                if (manifestFileLocation.isDirectory()) {
                    relativePath = relativePath + "/MANIFEST.MF";
                }
                this._manifestFileChooser.setText(relativePath);
                break;
            }
        }
    }

    private static VirtualFile[] getContentRoots(Module module) {
        return ModuleRootManager.getInstance((Module)module).getContentRoots();
    }

    @Nls
    public String getDisplayName() {
        return "General";
    }

    public JComponent createComponent() {
        return this._root;
    }

    public boolean isModified() {
        return this._modified;
    }

    private void selectBuildFile(TextFieldWithBrowseButton field) {
        VirtualFile[] roots = OsmorcFacetGeneralEditorTab.getContentRoots(this._module);
        VirtualFile currentFile = OsmorcFacetGeneralEditorTab.findFileInContentRoots(field.getText(), this._module);
        VirtualFile[] result = FileChooser.chooseFiles((Project)this._editorContext.getProject(), (FileChooserDescriptor)new FileChooserDescriptor(true, false, false, false, false, false), (VirtualFile)currentFile);
        if (result.length == 1) {
            VirtualFile fileLocation = result[0];
            for (VirtualFile root : roots) {
                String relativePath = VfsUtil.getRelativePath((VirtualFile)fileLocation, (VirtualFile)root, (char)File.separatorChar);
                if (relativePath == null) continue;
                field.setText(relativePath);
                break;
            }
        }
        this.updateGui();
    }

    public void apply() throws ConfigurationException {
        OsmorcFacetConfiguration configuration = (OsmorcFacetConfiguration)this._editorContext.getFacet().getConfiguration();
        configuration.setOsmorcControlsManifest(this._controlledByOsmorcRadioButton.isSelected());
        configuration.setManifestLocation(this._manifestFileChooser.getText());
        configuration.setUseProjectDefaultManifestFileLocation(this._useProjectDefaultManifestFileLocation.isSelected());
        configuration.setUseBndFile(this._useBndFileRadioButton.isSelected());
        configuration.setUseBundlorFile(this._useBundlorFileRadioButton.isSelected());
        String bndFileLocation = this._bndFile.getText();
        bndFileLocation = bndFileLocation.replace('\\', '/');
        configuration.setBndFileLocation(bndFileLocation);
        String bundlorFileLocation = this._bundlorFile.getText();
        bundlorFileLocation = bundlorFileLocation.replace('\\', '/');
        configuration.setBundlorFileLocation(bundlorFileLocation);
    }

    public void reset() {
        OsmorcFacetConfiguration configuration = (OsmorcFacetConfiguration)this._editorContext.getFacet().getConfiguration();
        if (configuration.isUseBndFile()) {
            this._useBndFileRadioButton.setSelected(true);
        } else if (configuration.isUseBundlorFile()) {
            this._useBundlorFileRadioButton.setSelected(true);
        } else if (configuration.isOsmorcControlsManifest()) {
            this._controlledByOsmorcRadioButton.setSelected(true);
        } else {
            this._manuallyEditedRadioButton.setSelected(true);
        }
        this._manifestFileChooser.setText(configuration.getManifestLocation());
        if (configuration.isUseProjectDefaultManifestFileLocation()) {
            this._useProjectDefaultManifestFileLocation.setSelected(true);
        } else {
            this._useModuleSpecificManifestFileLocation.setSelected(true);
        }
        this._bndFile.setText(configuration.getBndFileLocation());
        this._bundlorFile.setText(configuration.getBundlorFileLocation());
        this.updateGui();
    }

    public void onTabEntering() {
        super.onTabEntering();
        this.updateGui();
    }

    public void disposeUIResources() {
    }

    private String getManifestLocation() {
        if (this._controlledByOsmorcRadioButton.isSelected() || this._useBndFileRadioButton.isSelected() || this._useBundlorFileRadioButton.isSelected()) {
            return null;
        }
        if (this._useModuleSpecificManifestFileLocation.isSelected()) {
            return this._manifestFileChooser.getText();
        }
        if (this._useProjectDefaultManifestFileLocation.isSelected()) {
            ProjectSettings projectSettings = (ProjectSettings)ModuleServiceManager.getService((Module)this._module, ProjectSettings.class);
            return projectSettings.getDefaultManifestFileLocation();
        }
        return null;
    }

    private void checkFileExisting() {
        VirtualFile file;
        String location;
        boolean showWarning = this._controlledByOsmorcRadioButton.isSelected() || this._useBndFileRadioButton.isSelected() || this._useBundlorFileRadioButton.isSelected() ? false : ((location = this.getManifestLocation()) == null ? false : (file = OsmorcFacetGeneralEditorTab.findFileInContentRoots(location, this._module)) == null);
        this._warningPanel.setVisible(showWarning);
        this._root.revalidate();
    }

    private void createUIComponents() {
        this._errorText = new MyErrorText();
        this._errorText.setError("The manifest file does not exist.");
    }

    private void tryCreateBundleManifest() {
        final String manifestPath = this.getManifestLocation();
        if (StringUtil.isEmpty((String)manifestPath)) {
            return;
        }
        final VirtualFile[] contentRoots = OsmorcFacetGeneralEditorTab.getContentRoots(this._module);
        if (contentRoots.length > 0) {
            Application application = ApplicationManager.getApplication();
            application.runWriteAction(new Runnable(){

                public void run() {
                    try {
                        VirtualFile contentRoot = contentRoots[0];
                        String completePath = contentRoot.getPath() + File.separator + manifestPath;
                        completePath = completePath.replace('\\', '/');
                        int lastPathSep = completePath.lastIndexOf(47);
                        String path = completePath.substring(0, lastPathSep);
                        String filename = completePath.substring(lastPathSep + 1);
                        VfsUtil.createDirectories((String)path);
                        VirtualFile parentFolder = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
                        String bundleName = OsmorcFacetGeneralEditorTab.this._module.getName();
                        Version bundleVersion = null;
                        int nextDotPos = bundleName.indexOf(46);
                        while (bundleVersion == null && nextDotPos >= 0) {
                            try {
                                bundleVersion = new Version(bundleName.substring(nextDotPos + 1));
                                bundleName = bundleName.substring(0, nextDotPos);
                            }
                            catch (IllegalArgumentException e) {
                                // empty catch block
                            }
                            nextDotPos = bundleName.indexOf(46, nextDotPos + 1);
                        }
                        VirtualFile manifest = parentFolder.createChildData((Object)this, filename);
                        OutputStream outputStream = manifest.getOutputStream((Object)this);
                        PrintWriter writer = new PrintWriter(outputStream);
                        writer.write(Attributes.Name.MANIFEST_VERSION + ": 1.0.0\n" + "Bundle-ManifestVersion" + ": 2\n" + "Bundle-Name" + ": " + bundleName + "\n" + "Bundle-SymbolicName" + ": " + bundleName + "\n" + "Bundle-Version" + ": " + (bundleVersion != null ? bundleVersion.toString() : "1.0.0") + "\n");
                        writer.flush();
                        writer.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            VirtualFileManager.getInstance().refresh(false);
        }
    }

    public String getHelpTopic() {
        return "reference.settings.module.facet.osgi";
    }

    private static VirtualFile findFileInContentRoots(String fileName, Module module) {
        VirtualFile root;
        VirtualFile[] roots = OsmorcFacetGeneralEditorTab.getContentRoots(module);
        VirtualFile currentFile = null;
        VirtualFile[] arr$ = roots;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (currentFile = VfsUtil.findRelativeFile((String)fileName, (VirtualFile)(root = arr$[i$]))) == null; ++i$) {
        }
        return currentFile;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        JRadioButton jRadioButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JPanel jPanel2;
        JButton jButton;
        JPanel jPanel3;
        TextFieldWithBrowseButton textFieldWithBrowseButton3;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel4;
        JRadioButton jRadioButton4;
        JRadioButton jRadioButton5;
        JRadioButton jRadioButton6;
        JPanel jPanel5;
        this.createUIComponents();
        this._root = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new FormLayout("fill:d:noGrow,left:4dlu:noGrow,fill:max(d;4px):grow", "center:p:noGrow,top:3dlu:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:max(d;4px):noGrow,top:p:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:max(d;4px):noGrow"));
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), null, 0, 0, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Bundle creation");
        jPanel5.add((Component)jLabel, new CellConstraints(1, 1, 3, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this._controlledByOsmorcRadioButton = jRadioButton6 = new JRadioButton();
        jRadioButton6.setText("Create manifest using facet settings and bundle using facet configuration");
        jPanel5.add((Component)jRadioButton6, new CellConstraints(1, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this._useBndFileRadioButton = jRadioButton5 = new JRadioButton();
        jRadioButton5.setText("Create using bnd and ignore facet configuration");
        jPanel5.add((Component)jRadioButton5, new CellConstraints(1, 7, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this._manuallyEditedRadioButton = jRadioButton4 = new JRadioButton();
        jRadioButton4.setText("Use existing manifest and bundle using facet configuration");
        jRadioButton4.setSelected(true);
        jPanel5.add((Component)jRadioButton4, new CellConstraints(1, 5, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this._manifestPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new FormLayout("fill:d:grow", "center:max(d;4px):noGrow,top:3dlu:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:max(d;4px):noGrow"));
        jPanel5.add((Component)jPanel4, new CellConstraints(1, 6, 3, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        jPanel4.setBorder(BorderFactory.createTitledBorder(null, "Manifest file location (relative to module root)", 0, 0, null, null));
        this._useProjectDefaultManifestFileLocation = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("org/osmorc/i18n/OsmorcBundle").getString("faceteditor.manifestfilelocation.useprojectdefault"));
        jRadioButton3.setSelected(true);
        jPanel4.add((Component)jRadioButton3, new CellConstraints(1, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new FormLayout("left:34px:noGrow,fill:max(d;4px):noGrow,left:d:grow(2.0)", "center:d:grow"));
        jPanel4.add((Component)jPanel6, new CellConstraints(1, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this._useModuleSpecificManifestFileLocation = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("");
        jRadioButton2.setHorizontalAlignment(10);
        jPanel6.add((Component)jRadioButton2, new CellConstraints(1, 1, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this._manifestFileChooser = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton3.setEnabled(false);
        jPanel6.add((Component)textFieldWithBrowseButton3, new CellConstraints(3, 1, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this._warningPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new CellConstraints(1, 5, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        MyErrorText myErrorText = this._errorText;
        jPanel3.add((Component)myErrorText, new GridConstraints(0, 0, 1, 1, 8, 0, 7, 3, null, null, null));
        this._createButton = jButton = new JButton();
        jButton.setText("Create");
        jPanel3.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this._bndPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new FormLayout("fill:d:grow", "center:d:grow,top:3dlu:noGrow,center:max(d;4px):noGrow"));
        jPanel5.add((Component)jPanel2, new CellConstraints(1, 9, 3, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Bnd file location", 0, 0, null, null));
        this._bndFile = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton2, new CellConstraints(1, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this._useBundlorFileRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Create using Bundlor and ignore facet configuration");
        jPanel5.add((Component)jRadioButton, new CellConstraints(1, 11, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this._bundlorPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new FormLayout("fill:d:grow", "center:d:grow,top:3dlu:noGrow,center:max(d;4px):noGrow"));
        jPanel5.add((Component)jPanel, new CellConstraints(1, 13, 3, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        jPanel.setBorder(BorderFactory.createTitledBorder(null, "Bundlor file location", 0, 0, null, null));
        this._bundlorFile = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new CellConstraints(1, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton6);
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton5);
        buttonGroup.add(jRadioButton);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this._root;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

