/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.facet.ui;

import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.util.io.FileTypeFilter;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.osmorc.facet.OsmorcFacetConfiguration;
import org.osmorc.facet.ui.AdditionalJARContentsTableModel;
import org.osmorc.facet.ui.FileSelectorTableCellEditor;
import org.osmorc.facet.ui.OsmorcFacetGeneralEditorTab;
import org.osmorc.i18n.OsmorcBundle;

public class OsmorcFacetJAREditorTab
extends FacetEditorTab {
    private TextFieldWithBrowseButton _jarFileChooser;
    private JPanel _root;
    private JTable _additionalJARContentsTable;
    private EditorTextField _ignoreFilePatternTextField;
    private JButton _addButton;
    private JButton _removeButton;
    private JButton _editButton;
    private JCheckBox _alwaysRebuildBundleJARCheckBox;
    private JLabel _additionalJarContentsLabel;
    private JLabel _jarFileToCreateLabel;
    private JLabel _fileIgnorePatternLabel;
    private JPanel _ignoreFilePatternPanel;
    private boolean _modified;
    private final FacetEditorContext _editorContext;
    private AdditionalJARContentsTableModel _additionalJARContentsTableModel;

    public OsmorcFacetJAREditorTab(FacetEditorContext editorContext) {
        this._editorContext = editorContext;
        this.$$$setupUI$$$();
        Project project = editorContext.getProject();
        this._ignoreFilePatternTextField = new EditorTextField("", project, (FileType)FileTypes.PLAIN_TEXT);
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName("*.regexp");
        if (fileType == FileTypes.UNKNOWN) {
            fileType = FileTypeManager.getInstance().getFileTypeByFileName("*.txt");
        }
        PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText("*.regexp", fileType, (CharSequence)this._ignoreFilePatternTextField.getText(), -1L, true);
        this._ignoreFilePatternTextField.setNewDocumentAndFileType(fileType, PsiDocumentManager.getInstance((Project)project).getDocument(file));
        this._ignoreFilePatternPanel.add((Component)this._ignoreFilePatternTextField, "Center");
        UserActivityWatcher watcher = new UserActivityWatcher();
        watcher.addUserActivityListener(new UserActivityListener(){

            public void stateChanged() {
                OsmorcFacetJAREditorTab.this._modified = true;
            }
        });
        watcher.register((Component)this._root);
        this._jarFileChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OsmorcFacetJAREditorTab.this.onJarFileSelect();
            }
        });
        this._additionalJARContentsTableModel = new AdditionalJARContentsTableModel();
        this._additionalJARContentsTable.setModel(this._additionalJARContentsTableModel);
        TableColumn col = this._additionalJARContentsTable.getColumnModel().getColumn(0);
        FileSelectorTableCellEditor selectorTableCellEditor = new FileSelectorTableCellEditor(project, this._editorContext.getModule());
        col.setCellEditor((TableCellEditor)((Object)selectorTableCellEditor));
        selectorTableCellEditor.addCellEditorListener(new CellEditorListener(){

            public void editingCanceled(ChangeEvent e) {
            }

            public void editingStopped(ChangeEvent e) {
                int row = OsmorcFacetJAREditorTab.this._additionalJARContentsTable.getSelectedRow();
                if (row > -1) {
                    Pair<String, String> additionalJARContent = OsmorcFacetJAREditorTab.this._additionalJARContentsTableModel.getAdditionalJARContent(row);
                    VirtualFile preselectedPath = LocalFileSystem.getInstance().findFileByPath((String)additionalJARContent.getFirst());
                    String destinationName = preselectedPath != null ? OsmorcFacetJAREditorTab.this.determineMostLikelyLocationInJAR(preselectedPath) : "";
                    OsmorcFacetJAREditorTab.this._additionalJARContentsTableModel.changeAdditionalJARConent(row, (String)additionalJARContent.first, destinationName);
                    OsmorcFacetJAREditorTab.this._additionalJARContentsTable.editCellAt(row, 1);
                    OsmorcFacetJAREditorTab.this._additionalJARContentsTable.getEditorComponent().requestFocus();
                }
            }
        });
        this._additionalJARContentsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                OsmorcFacetJAREditorTab.this._removeButton.setEnabled(OsmorcFacetJAREditorTab.this._additionalJARContentsTable.getSelectedRowCount() > 0);
                OsmorcFacetJAREditorTab.this._editButton.setEnabled(OsmorcFacetJAREditorTab.this._additionalJARContentsTable.getSelectedRowCount() > 0);
            }
        });
        this._addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OsmorcFacetJAREditorTab.this.onAddAdditionalJARContent();
            }
        });
        this._removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OsmorcFacetJAREditorTab.this.onRemoveAdditionalJARContent();
            }
        });
        this._editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OsmorcFacetJAREditorTab.this.onEditAdditionalJARContent();
            }
        });
        this._editButton.setEnabled(false);
        this._removeButton.setEnabled(false);
    }

    private void onEditAdditionalJARContent() {
        int row = this._additionalJARContentsTable.getSelectedRow();
        if (row > -1) {
            VirtualFile[] files;
            Pair<String, String> additionalJARContent = this._additionalJARContentsTableModel.getAdditionalJARContent(row);
            Project project = this._editorContext.getProject();
            FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, true, true, false, false);
            descriptor.setTitle("Choose source file or folder");
            FileChooserDialog fileChooserDialog = FileChooserFactory.getInstance().createFileChooser(descriptor, project);
            VirtualFile preselectedPath = LocalFileSystem.getInstance().findFileByPath((String)additionalJARContent.getFirst());
            if (preselectedPath == null) {
                Module module = this._editorContext.getModule();
                VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
                if (contentRoots.length > 0) {
                    for (VirtualFile contentRoot : contentRoots) {
                        VirtualFile path = VfsUtil.findRelativeFile((String)((String)additionalJARContent.getFirst()), (VirtualFile)contentRoot);
                        if (path == null) continue;
                        preselectedPath = path;
                        break;
                    }
                    if (preselectedPath == null) {
                        preselectedPath = contentRoots[0];
                    }
                } else if (project.getBaseDir() != null) {
                    preselectedPath = project.getBaseDir();
                }
            }
            if ((files = fileChooserDialog.choose(preselectedPath, project)).length > 0) {
                String sourcePath = files[0].getPath();
                String destPath = this.determineMostLikelyLocationInJAR(files[0]);
                this._additionalJARContentsTableModel.changeAdditionalJARConent(row, sourcePath, destPath);
                this._additionalJARContentsTable.editCellAt(row, 1);
                this._additionalJARContentsTable.getEditorComponent().requestFocus();
            }
        }
    }

    private void onRemoveAdditionalJARContent() {
        this._additionalJARContentsTableModel.deleteAdditionalJARContent(this._additionalJARContentsTable.getSelectedRow());
    }

    private void onAddAdditionalJARContent() {
        VirtualFile[] files;
        Project project = this._editorContext.getProject();
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, true, true, false, true);
        descriptor.setTitle("Choose source file or folder");
        FileChooserDialog fileChooserDialog = FileChooserFactory.getInstance().createFileChooser(descriptor, project);
        VirtualFile rootFolder = null;
        Module module = this._editorContext.getModule();
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (contentRoots.length > 0) {
            rootFolder = contentRoots[0];
        } else if (project.getBaseDir() != null) {
            rootFolder = project.getBaseDir();
        }
        for (VirtualFile file : files = fileChooserDialog.choose(rootFolder, project)) {
            String destFile = this.determineMostLikelyLocationInJAR(file);
            int row = this._additionalJARContentsTableModel.addAdditionalJARContent(file.getPath(), destFile);
            this._additionalJARContentsTable.editCellAt(row, 1);
            this._additionalJARContentsTable.getEditorComponent().requestFocus();
        }
    }

    private String determineMostLikelyLocationInJAR(@NotNull VirtualFile file) {
        VirtualFile[] contentRoots;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/facet/ui/OsmorcFacetJAREditorTab.determineMostLikelyLocationInJAR must not be null");
        }
        Project project = this._editorContext.getProject();
        Module module = this._editorContext.getModule();
        for (VirtualFile contentRoot : contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            if (!VfsUtil.isAncestor((VirtualFile)contentRoot, (VirtualFile)file, (boolean)false)) continue;
            return VfsUtil.getRelativePath((VirtualFile)file, (VirtualFile)contentRoot, (char)'/');
        }
        VirtualFile projectBaseFolder = project.getBaseDir();
        if (projectBaseFolder != null && VfsUtil.isAncestor((VirtualFile)projectBaseFolder, (VirtualFile)file, (boolean)false)) {
            return VfsUtil.getRelativePath((VirtualFile)file, (VirtualFile)projectBaseFolder, (char)'/');
        }
        return file.getName();
    }

    private void updateGui() {
        Boolean bnd = (Boolean)this._editorContext.getUserData(OsmorcFacetGeneralEditorTab.BND_CREATION_KEY);
        Boolean bundlor = (Boolean)this._editorContext.getUserData(OsmorcFacetGeneralEditorTab.BUNDLOR_CREATION_KEY);
        boolean useExternalTool = bnd != null && bnd != false || bundlor != null && bundlor != false;
        this._jarFileChooser.setEnabled(!useExternalTool);
        this._additionalJARContentsTable.setEnabled(!useExternalTool);
        this._ignoreFilePatternTextField.setEnabled(!useExternalTool);
        this._addButton.setEnabled(!useExternalTool);
        this._removeButton.setEnabled(!useExternalTool);
        this._editButton.setEnabled(!useExternalTool);
        this._alwaysRebuildBundleJARCheckBox.setEnabled(!useExternalTool);
        this._additionalJarContentsLabel.setEnabled(!useExternalTool);
        this._jarFileToCreateLabel.setEnabled(!useExternalTool);
        this._fileIgnorePatternLabel.setEnabled(!useExternalTool);
    }

    private void onJarFileSelect() {
        String preselectedFileName;
        File file;
        String currentFile = this._jarFileChooser.getText();
        VirtualFile moduleCompilerOutputPath = CompilerModuleExtension.getInstance((Module)this._editorContext.getModule()).getCompilerOutputPath();
        if (moduleCompilerOutputPath == null) {
            String outputPathUrl = CompilerModuleExtension.getInstance((Module)this._editorContext.getModule()).getCompilerOutputUrl();
            try {
                VfsUtil.createDirectories((String)VfsUtil.urlToPath((String)outputPathUrl));
            }
            catch (IOException e) {
                Messages.showErrorDialog((Component)this._root, (String)OsmorcBundle.getTranslation("error", new Object[0]), (String)OsmorcBundle.getTranslation("faceteditor.cannot.create.outputpath", new Object[0]));
                return;
            }
            moduleCompilerOutputPath = CompilerModuleExtension.getInstance((Module)this._editorContext.getModule()).getCompilerOutputPath();
            if (moduleCompilerOutputPath == null) {
                throw new IllegalStateException("Cannot access compiler output path.");
            }
        }
        if (!(file = new File(preselectedFileName = StringUtil.isNotEmpty((String)currentFile) ? currentFile : moduleCompilerOutputPath.getParent().getPath())).exists()) {
            preselectedFileName = file.getParent();
        }
        JFileChooser jfilechooser = new JFileChooser(preselectedFileName);
        FileView fileview = new FileView(){

            public Icon getIcon(File aFile) {
                if (aFile.isDirectory()) {
                    return super.getIcon(aFile);
                }
                FileType filetype = FileTypeManager.getInstance().getFileTypeByFileName(aFile.getName());
                return filetype.getIcon();
            }
        };
        jfilechooser.setFileView(fileview);
        jfilechooser.setMultiSelectionEnabled(false);
        jfilechooser.setAcceptAllFileFilterUsed(false);
        jfilechooser.setDialogTitle(OsmorcBundle.getTranslation("faceteditor.selectjar.title", new Object[0]));
        jfilechooser.addChoosableFileFilter((FileFilter)new FileTypeFilter(StdFileTypes.ARCHIVE));
        if (jfilechooser.showSaveDialog(WindowManager.getInstance().suggestParentWindow(this._editorContext.getProject())) != 0) {
            return;
        }
        file = jfilechooser.getSelectedFile();
        if (file != null && VfsUtil.isAncestor((File)new File(moduleCompilerOutputPath.getPath()), (File)file, (boolean)false)) {
            this._jarFileChooser.setText("");
            Messages.showErrorDialog((Project)this._editorContext.getProject(), (String)OsmorcBundle.getTranslation("error", new Object[0]), (String)OsmorcBundle.getTranslation("faceteditor.jar.cannot.be.in.output.path", new Object[0]));
            return;
        }
        this._jarFileChooser.setText(file.getPath());
    }

    @Nls
    public String getDisplayName() {
        return "Bundle JAR";
    }

    public JComponent createComponent() {
        return this._root;
    }

    public boolean isModified() {
        return this._modified;
    }

    public void apply() throws ConfigurationException {
        OsmorcFacetConfiguration configuration = (OsmorcFacetConfiguration)this._editorContext.getFacet().getConfiguration();
        String fileLocation = this._jarFileChooser.getText();
        fileLocation = fileLocation.replace('\\', '/');
        configuration.setJarFileLocation(fileLocation);
        configuration.setIgnoreFilePattern(this._ignoreFilePatternTextField.getText());
        configuration.setAlwaysRebuildBundleJAR(this._alwaysRebuildBundleJARCheckBox.isSelected());
        configuration.setAdditionalJARContents(this._additionalJARContentsTableModel.getAdditionalContents());
    }

    public void reset() {
        OsmorcFacetConfiguration configuration = (OsmorcFacetConfiguration)this._editorContext.getFacet().getConfiguration();
        this._jarFileChooser.setText(configuration.getJarFileLocation());
        this._additionalJARContentsTableModel.replaceContent(configuration.getAdditionalJARContents());
        this._ignoreFilePatternTextField.setText(configuration.getIgnoreFilePattern());
        this._alwaysRebuildBundleJARCheckBox.setSelected(configuration.isAlwaysRebuildBundleJAR());
        this.updateGui();
    }

    public void onTabEntering() {
        super.onTabEntering();
        this.updateGui();
    }

    public void disposeUIResources() {
    }

    public String getHelpTopic() {
        return "reference.settings.module.facet.osgi";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JLabel jLabel;
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JLabel jLabel2;
        JTable jTable;
        JLabel jLabel3;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel2;
        this._root = jPanel2 = new JPanel();
        FormLayout formLayout = new FormLayout("fill:p:noGrow,left:4dlu:noGrow,fill:max(p;4px):grow,left:4dlu:noGrow,fill:max(p;4px):noGrow", "center:p:noGrow,center:p:noGrow,top:4dlu:noGrow,center:p:noGrow,top:6dlu:noGrow,center:p:noGrow,top:4dlu:noGrow,center:p:noGrow,top:4dlu:noGrow,center:p:noGrow,top:4dlu:noGrow,center:p:noGrow,top:5dlu:noGrow,center:d:grow,top:8dlu:noGrow,center:max(p;4px):noGrow");
        int[][] nArrayArray = new int[1][];
        int[] nArray = new int[]{8, 10, 12};
        nArrayArray[0] = nArray;
        formLayout.setRowGroups((int[][])nArrayArray);
        jPanel2.setLayout((LayoutManager)formLayout);
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), null, 0, 0, null, null));
        this._jarFileChooser = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new CellConstraints(3, 2, 3, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new FormLayout("left:d:grow(2.0)", ""));
        jPanel2.add((Component)jPanel3, new CellConstraints(1, 1, 3, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this._additionalJarContentsLabel = jLabel3 = new JLabel();
        jLabel3.setText("Additional JAR contents");
        jPanel2.add((Component)jLabel3, new CellConstraints(1, 6, 5, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel2.add((Component)jScrollPane, new CellConstraints(1, 8, 3, 7, CellConstraints.FILL, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        this._additionalJARContentsTable = jTable = new JTable();
        jTable.setPreferredScrollableViewportSize(new Dimension(450, 150));
        jScrollPane.setViewportView(jTable);
        this._fileIgnorePatternLabel = jLabel2 = new JLabel();
        jLabel2.setText("File Ignore Pattern (regex)");
        jPanel2.add((Component)jLabel2, new CellConstraints(1, 16, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this._addButton = jButton3 = new JButton();
        jButton3.setText("Add...");
        jPanel2.add((Component)jButton3, new CellConstraints(5, 8, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this._removeButton = jButton2 = new JButton();
        jButton2.setText("Remove");
        jPanel2.add((Component)jButton2, new CellConstraints(5, 10, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this._editButton = jButton = new JButton();
        jButton.setText("Edit...");
        jPanel2.add((Component)jButton, new CellConstraints(5, 12, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this._jarFileToCreateLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("org/osmorc/i18n/OsmorcBundle").getString("faceteditor.jarfilelocation"));
        jPanel2.add((Component)jLabel, new CellConstraints(1, 2, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this._alwaysRebuildBundleJARCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Always rebuild bundle JAR");
        jPanel2.add((Component)jCheckBox, new CellConstraints(1, 4, 3, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this._ignoreFilePatternPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new CellConstraints(3, 16, 3, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        jLabel3.setLabelFor(jScrollPane);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this._root;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

