/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.facet.ui;

import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserDialog;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.osmorc.facet.OsmorcFacetConfiguration;
import org.osmorc.facet.ui.OsmorcFacetGeneralEditorTab;
import org.osmorc.i18n.OsmorcBundle;
import org.osmorc.settings.ManifestEditor;

public class OsmorcFacetManifestGenerationEditorTab
extends FacetEditorTab {
    private JPanel _root;
    private JTextField _bundleSymbolicName;
    private TextFieldWithBrowseButton _bundleActivator;
    private JLabel _bundleSymbolicNameLabel;
    private JLabel _bundleActivatorLabel;
    private JTextField _bundleVersion;
    private JLabel _bundleVersionLabel;
    private ManifestEditor _additionalProperties;
    private JLabel _additionalPropertiesLabel;
    private JPanel _editorPanel;
    private boolean _modified;
    private final FacetEditorContext _editorContext;

    public OsmorcFacetManifestGenerationEditorTab(FacetEditorContext editorContext) {
        this._editorContext = editorContext;
        this.$$$setupUI$$$();
        this._additionalProperties = new ManifestEditor(this._editorContext.getProject(), "");
        this._editorPanel.add((Component)((Object)this._additionalProperties), "Center");
        ChangeListener listener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                OsmorcFacetManifestGenerationEditorTab.this.updateGui();
            }
        };
        UserActivityWatcher watcher = new UserActivityWatcher();
        watcher.addUserActivityListener(new UserActivityListener(){

            public void stateChanged() {
                OsmorcFacetManifestGenerationEditorTab.this._modified = true;
            }
        });
        watcher.register((Component)this._root);
        this._bundleActivator.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OsmorcFacetManifestGenerationEditorTab.this.onBundleActivatorSelect();
            }
        });
    }

    private void updateGui() {
        Boolean manuallyEdited = (Boolean)this._editorContext.getUserData(OsmorcFacetGeneralEditorTab.MANUAL_MANIFEST_EDITING_KEY);
        boolean isManuallyEdited = manuallyEdited != null ? manuallyEdited : true;
        Boolean bnd = (Boolean)this._editorContext.getUserData(OsmorcFacetGeneralEditorTab.BND_CREATION_KEY);
        Boolean bundlor = (Boolean)this._editorContext.getUserData(OsmorcFacetGeneralEditorTab.BUNDLOR_CREATION_KEY);
        boolean isUseExternalTool = bnd != null && bnd != false || bundlor != null && bundlor != false;
        this._bundleActivatorLabel.setEnabled(!isManuallyEdited && !isUseExternalTool);
        this._bundleActivator.setEnabled(!isManuallyEdited && !isUseExternalTool);
        this._bundleSymbolicName.setEnabled(!isManuallyEdited && !isUseExternalTool);
        this._bundleSymbolicNameLabel.setEnabled(!isManuallyEdited && !isUseExternalTool);
        this._bundleVersionLabel.setEnabled(!isManuallyEdited && !isUseExternalTool);
        this._bundleVersion.setEnabled(!isManuallyEdited && !isUseExternalTool);
        this._additionalProperties.getComponent().setEnabled(!isManuallyEdited && !isUseExternalTool);
        this._additionalPropertiesLabel.setEnabled(!isManuallyEdited && !isUseExternalTool);
    }

    private void onBundleActivatorSelect() {
        Project project = this._editorContext.getProject();
        GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesScope((Module)this._editorContext.getModule());
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass("org.osgi.framework.BundleActivator", GlobalSearchScope.allScope((Project)project));
        TreeClassChooserDialog dialog = new TreeClassChooserDialog(OsmorcBundle.getTranslation("faceteditor.select.bundleactivator", new Object[0]), project, searchScope, (TreeClassChooser.ClassFilter)new TreeClassChooserDialog.InheritanceClassFilterImpl(psiClass, false, true, null), null);
        dialog.showDialog();
        PsiClass clazz = dialog.getSelectedClass();
        if (clazz != null) {
            this._bundleActivator.setText(clazz.getQualifiedName());
        }
    }

    @Nls
    public String getDisplayName() {
        return "Manifest Generation";
    }

    public JComponent createComponent() {
        return this._root;
    }

    public boolean isModified() {
        return this._modified;
    }

    public void apply() throws ConfigurationException {
        OsmorcFacetConfiguration configuration = (OsmorcFacetConfiguration)this._editorContext.getFacet().getConfiguration();
        configuration.setBundleActivator(this._bundleActivator.getText());
        configuration.setBundleSymbolicName(this._bundleSymbolicName.getText());
        configuration.setBundleVersion(this._bundleVersion.getText());
        configuration.setAdditionalProperties(this._additionalProperties.getText());
    }

    public void reset() {
        OsmorcFacetConfiguration configuration = (OsmorcFacetConfiguration)this._editorContext.getFacet().getConfiguration();
        this._bundleActivator.setText(configuration.getBundleActivator());
        this._bundleSymbolicName.setText(configuration.getBundleSymbolicName());
        this._bundleVersion.setText(configuration.getBundleVersion());
        this._additionalProperties.setText(configuration.getAdditionalProperties());
        this.updateGui();
    }

    public void onTabEntering() {
        super.onTabEntering();
        this.updateGui();
    }

    public void disposeUIResources() {
    }

    public String getHelpTopic() {
        return "reference.settings.module.facet.osgi";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JLabel jLabel;
        JTextField jTextField;
        JLabel jLabel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel3;
        JTextField jTextField2;
        JLabel jLabel4;
        JPanel jPanel2;
        this._root = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new FormLayout("fill:d:grow", "center:271px:grow"));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new FormLayout("fill:d:noGrow,left:4dlu:noGrow,fill:d:grow", "center:d:noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:max(p;4px):grow"));
        jPanel2.add((Component)jPanel3, new CellConstraints(1, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        jPanel3.setBorder(BorderFactory.createTitledBorder(null, ResourceBundle.getBundle("org/osmorc/i18n/OsmorcBundle").getString("faceteditor.bundlesettings"), 0, 0, null, null));
        this._bundleSymbolicNameLabel = jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("org/osmorc/i18n/OsmorcBundle").getString("faceteditor.bundlesymbolicname"));
        jPanel3.add((Component)jLabel4, new CellConstraints(1, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this._bundleSymbolicName = jTextField2 = new JTextField();
        jPanel3.add((Component)jTextField2, new CellConstraints(3, 1, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this._bundleActivatorLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("org/osmorc/i18n/OsmorcBundle").getString("faceteditor.bundleactivator"));
        jPanel3.add((Component)jLabel3, new CellConstraints(1, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this._bundleActivator = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new CellConstraints(3, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this._bundleVersionLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("org/osmorc/i18n/OsmorcBundle").getString("faceteditor.bundleversion"));
        jPanel3.add((Component)jLabel2, new CellConstraints(1, 5, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this._bundleVersion = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new CellConstraints(3, 5, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this._additionalPropertiesLabel = jLabel = new JLabel();
        jLabel.setVerticalTextPosition(0);
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("org/osmorc/i18n/OsmorcBundle").getString("faceteditor.additionalproperties"));
        jLabel.setVerticalAlignment(0);
        jPanel3.add((Component)jLabel, new CellConstraints(1, 7, 1, 1, CellConstraints.DEFAULT, CellConstraints.TOP, new Insets(0, 0, 0, 0)));
        this._editorPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new CellConstraints(3, 7, 1, 1, CellConstraints.FILL, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        jLabel4.setLabelFor(jTextField2);
        jLabel2.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this._root;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

