/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.fix.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.osmorc.manifest.lang.psi.Clause;
import org.osmorc.manifest.lang.psi.Header;
import org.osmorc.manifest.lang.psi.HeaderValuePart;

public class ReplaceUtil {
    public static void replace(PsiElement element, String with) {
        ReplaceUtil.replace(element, element.getTextRange(), with);
    }

    public static void replace(PsiElement element, TextRange range, String with) {
        TextRange relativeTextRange = TextRange.from((int)(range.getStartOffset() - element.getTextRange().getStartOffset()), (int)range.getLength());
        String newText = relativeTextRange.replace(element.getText(), with);
        if (element instanceof HeaderValuePart) {
            ReplaceUtil.replace((HeaderValuePart)element, newText);
        }
    }

    private static void replace(HeaderValuePart headerValue, String with) {
        ReadonlyStatusHandler.OperationStatus status = ReadonlyStatusHandler.getInstance((Project)headerValue.getProject()).ensureFilesWritable(new VirtualFile[]{((PsiFile)PsiTreeUtil.getParentOfType((PsiElement)headerValue, PsiFile.class, (boolean)false)).getVirtualFile()});
        if (!status.hasReadonlyFiles()) {
            PsiFile fromText = PsiFileFactory.getInstance((Project)headerValue.getProject()).createFileFromText("DUMMY.MF", "dummy: " + with);
            Header header = (Header)PsiTreeUtil.getChildOfType((PsiElement)fromText.getFirstChild(), Header.class);
            assert (header != null);
            Clause clause = (Clause)PsiTreeUtil.getChildOfType((PsiElement)header, Clause.class);
            assert (clause != null);
            HeaderValuePart value = (HeaderValuePart)PsiTreeUtil.getChildOfAnyType((PsiElement)clause, (Class[])new Class[]{HeaderValuePart.class});
            try {
                assert (value != null);
                headerValue.replace(value);
            }
            catch (IncorrectOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

