/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.frameworkintegration;

import com.intellij.openapi.vfs.VfsUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.WeakHashMap;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jetbrains.annotations.Nullable;

public class CachingBundleInfoProvider {
    private static final WeakHashMap<String, Manifest> _cache = new WeakHashMap();

    private CachingBundleInfoProvider() {
    }

    public static boolean isBundle(String bundleUrl) {
        return CachingBundleInfoProvider.getBundleSymbolicName(bundleUrl) != null;
    }

    public static boolean canBeBundlified(String bundleUrl) {
        if (CachingBundleInfoProvider.isBundle(bundleUrl)) {
            return false;
        }
        File sourceFile = new File(VfsUtil.urlToPath((String)bundleUrl));
        if (sourceFile.isDirectory()) {
            return false;
        }
        return sourceFile.getName().endsWith(".jar");
    }

    @Nullable
    public static String getBundleSymbolicName(String bundleUrl) {
        String symbolicName = CachingBundleInfoProvider.getBundleAttribute(bundleUrl, "Bundle-SymbolicName");
        return symbolicName != null ? symbolicName.split(";", 2)[0] : null;
    }

    @Nullable
    public static String getBundleVersions(String bundleUrl) {
        return CachingBundleInfoProvider.getBundleAttribute(bundleUrl, "Bundle-Version");
    }

    public static boolean isFragmentBundle(String bundleUrl) {
        String fragmentHost = CachingBundleInfoProvider.getBundleAttribute(bundleUrl, "Fragment-Host");
        return fragmentHost != null;
    }

    @Nullable
    private static synchronized String getBundleAttribute(String bundleUrl, String attribute) {
        Manifest manifest;
        if (!_cache.containsKey(bundleUrl = CachingBundleInfoProvider.normalize(bundleUrl))) {
            try {
                File bundleFile = new File(VfsUtil.urlToPath((String)bundleUrl));
                if (bundleFile.isDirectory()) {
                    File manifestFile = new File(bundleFile, "META-INF/MANIFEST.MF");
                    if (manifestFile.exists() && !manifestFile.isDirectory()) {
                        FileInputStream fileInputStream = new FileInputStream(manifestFile);
                        Manifest manifest2 = new Manifest(fileInputStream);
                        fileInputStream.close();
                        _cache.put(bundleUrl, manifest2);
                    }
                } else {
                    JarFile file = new JarFile(bundleFile);
                    _cache.put(bundleUrl, file.getManifest());
                    file.close();
                }
            }
            catch (IOException e) {
                return null;
            }
        }
        return (manifest = _cache.get(bundleUrl)) != null ? manifest.getMainAttributes().getValue(attribute) : null;
    }

    private static String normalize(String bundleUrl) {
        return bundleUrl.replaceAll("file:/([^/]+)", "file:///$1");
    }

    public static boolean isExploded(String bundleUrl) {
        File bundleFile = new File(VfsUtil.urlToPath((String)bundleUrl));
        return bundleFile.isDirectory();
    }
}

