/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.frameworkintegration;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.osmorc.facet.OsmorcFacetUtil;
import org.osmorc.frameworkintegration.LibraryHandler;
import org.osmorc.settings.ProjectSettings;

public class FrameworkInstanceModuleManager {
    private final ProjectSettings projectSettings;
    private final Application application;
    private final Project project;
    private final LibraryHandler libraryHandler;
    private final ModuleManager moduleManager;
    private final OsmorcFacetUtil osmorcFacetUtil;
    protected static final String FRAMEWORK_INSTANCE_MODULE_NAME = "FrameworkInstance";

    public FrameworkInstanceModuleManager(LibraryHandler libraryHandler, ProjectSettings projectSettings, Application application, Project project, ModuleManager moduleManager, OsmorcFacetUtil osmorcFacetUtil) {
        this.projectSettings = projectSettings;
        this.application = application;
        this.project = project;
        this.libraryHandler = libraryHandler;
        this.moduleManager = moduleManager;
        this.osmorcFacetUtil = osmorcFacetUtil;
    }

    public void updateFrameworkInstanceModule() {
        if (this.projectSettings.isCreateFrameworkInstanceModule() && this.isExistsAtLeastOneOsmorcFacetInProject()) {
            this.ensureFrameworkInstanceModuleExists();
            this.updateModuleLibraries(this.projectSettings.getFrameworkInstanceName());
        } else {
            final Module module = this.getFrameworkInstanceModule();
            if (module != null) {
                this.application.runWriteAction(new Runnable(){

                    public void run() {
                        try {
                            VirtualFile file = module.getModuleFile();
                            ModifiableModuleModel moduleModel = FrameworkInstanceModuleManager.this.moduleManager.getModifiableModel();
                            moduleModel.disposeModule(module);
                            moduleModel.commit();
                            if (file != null && file.exists()) {
                                file.delete((Object)this);
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
        }
    }

    private boolean isExistsAtLeastOneOsmorcFacetInProject() {
        Module[] modules;
        for (Module module : modules = this.moduleManager.getModules()) {
            if (!this.osmorcFacetUtil.hasOsmorcFacet(module)) continue;
            return true;
        }
        return false;
    }

    private void updateModuleLibraries(@Nullable String instanceName) {
        final List<Object> libraries = instanceName != null ? this.libraryHandler.getLibraries(instanceName) : new ArrayList();
        this.application.runWriteAction(new Runnable(){

            public void run() {
                Module module = FrameworkInstanceModuleManager.this.getFrameworkInstanceModule();
                ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                ArrayList<OrderEntry> oldOrderEntries = new ArrayList<OrderEntry>();
                for (OrderEntry oldOrderEntry : model.getOrderEntries()) {
                    if (!(oldOrderEntry instanceof LibraryOrderEntry)) continue;
                    oldOrderEntries.add(oldOrderEntry);
                }
                Iterator oldOrderEntriesIterator = oldOrderEntries.iterator();
                while (oldOrderEntriesIterator.hasNext()) {
                    OrderEntry orderEntry = (OrderEntry)oldOrderEntriesIterator.next();
                    if (!(orderEntry instanceof LibraryOrderEntry) || !libraries.remove(((LibraryOrderEntry)orderEntry).getLibrary())) continue;
                    oldOrderEntriesIterator.remove();
                }
                boolean commitNeeded = false;
                for (OrderEntry orderEntry : oldOrderEntries) {
                    model.removeOrderEntry(orderEntry);
                    commitNeeded = true;
                }
                for (Library newBundle : libraries) {
                    if (newBundle instanceof LibraryEx && ((LibraryEx)newBundle).isDisposed()) continue;
                    model.addLibraryEntry(newBundle);
                    commitNeeded = true;
                }
                if (commitNeeded) {
                    model.commit();
                } else {
                    model.dispose();
                }
            }
        });
    }

    private void ensureFrameworkInstanceModuleExists() {
        Module frameworkInstanceModule = this.getFrameworkInstanceModule();
        if (frameworkInstanceModule == null) {
            this.application.runWriteAction(new Runnable(){

                public void run() {
                    VirtualFile baseDir = FrameworkInstanceModuleManager.this.project.getBaseDir();
                    assert (baseDir != null);
                    String path = baseDir.getPath();
                    if (!path.endsWith("/")) {
                        path = path + '/';
                    }
                    path = path + FrameworkInstanceModuleManager.FRAMEWORK_INSTANCE_MODULE_NAME + ".iml";
                    Module module = FrameworkInstanceModuleManager.this.moduleManager.newModule(path, StdModuleTypes.JAVA);
                    ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                    model.setSdk(ProjectRootManager.getInstance((Project)FrameworkInstanceModuleManager.this.project).getProjectJdk());
                    model.commit();
                }
            });
        }
    }

    private Module getFrameworkInstanceModule() {
        return this.moduleManager.findModuleByName(FRAMEWORK_INSTANCE_MODULE_NAME);
    }
}

