/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.frameworkintegration;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.frameworkintegration.FrameworkIntegrator;

public class FrameworkIntegratorRegistry {
    private final FrameworkIntegrator[] _frameworkIntegrators = (FrameworkIntegrator[])Extensions.getExtensions((ExtensionPointName)new ExtensionPointName("Osmorc.frameworkIntegrator"));

    public FrameworkIntegrator[] getFrameworkIntegrators() {
        FrameworkIntegrator[] result = new FrameworkIntegrator[this._frameworkIntegrators.length];
        System.arraycopy(this._frameworkIntegrators, 0, result, 0, this._frameworkIntegrators.length);
        return result;
    }

    @Nullable
    public FrameworkIntegrator findIntegratorByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/FrameworkIntegratorRegistry.findIntegratorByName must not be null");
        }
        FrameworkIntegrator result = null;
        for (FrameworkIntegrator frameworkIntegrator : this._frameworkIntegrators) {
            if (!frameworkIntegrator.getDisplayName().equals(name)) continue;
            result = frameworkIntegrator;
            break;
        }
        return result;
    }

    @Nullable
    public FrameworkIntegrator findIntegratorByInstanceDefinition(@NotNull FrameworkInstanceDefinition frameworkInstanceDefinition) {
        if (frameworkInstanceDefinition == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/FrameworkIntegratorRegistry.findIntegratorByInstanceDefinition must not be null");
        }
        return this.findIntegratorByName(frameworkInstanceDefinition.getFrameworkIntegratorName());
    }
}

