/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.frameworkintegration;

import com.intellij.util.xmlb.annotations.Transient;
import com.jgoodies.binding.beans.Model;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryBundlificationRule
extends Model {
    private String _additionalProperties = "Import-Package: *;resolution:=optional";
    private String _ruleRegex = ".*";
    private long _lastModified = System.currentTimeMillis();
    private boolean _doNotBundle = false;
    private boolean _stopAfterThisRule = false;

    public LibraryBundlificationRule() {
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LibraryBundlificationRule.this._lastModified = System.currentTimeMillis();
            }
        });
    }

    @Transient
    public Map<String, String> getAdditionalPropertiesMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        Properties p = new Properties();
        ByteArrayInputStream bais = new ByteArrayInputStream(this.getAdditionalProperties().getBytes());
        try {
            p.load(bais);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            result.put(name, p.getProperty(name));
        }
        return result;
    }

    public String getRuleRegex() {
        return this._ruleRegex;
    }

    public void setRuleRegex(String ruleRegex) {
        String oldRegex = this._ruleRegex;
        this._ruleRegex = ruleRegex;
        this.firePropertyChange("ruleRegex", oldRegex, this._ruleRegex);
    }

    public boolean appliesTo(@NotNull String libraryName) {
        if (libraryName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/LibraryBundlificationRule.appliesTo must not be null");
        }
        try {
            return ".*".equals(this.getRuleRegex()) || !"".equals(this.getRuleRegex()) && Pattern.compile(this.getRuleRegex()).matcher(libraryName).matches();
        }
        catch (PatternSyntaxException e) {
            return false;
        }
    }

    public String getAdditionalProperties() {
        return this._additionalProperties;
    }

    public void setAdditionalProperties(String additionalProperties) {
        String old = this._additionalProperties;
        this._additionalProperties = additionalProperties;
        this.firePropertyChange("additionalProperties", old, this._additionalProperties);
    }

    public String toString() {
        return "Rule: " + this._ruleRegex;
    }

    public long getLastModified() {
        return this._lastModified;
    }

    public void setLastModified(long lastModified) {
        long old = this._lastModified;
        this._lastModified = lastModified;
        this.firePropertyChange("lastModified", old, lastModified);
    }

    public boolean isDoNotBundle() {
        return this._doNotBundle;
    }

    public void setDoNotBundle(boolean doNotBundle) {
        boolean old = this._doNotBundle;
        this._doNotBundle = doNotBundle;
        this.firePropertyChange("doNotBundle", old, doNotBundle);
    }

    public void setStopAfterThisRule(boolean stopAfterThisRule) {
        boolean old = this._stopAfterThisRule;
        this._stopAfterThisRule = stopAfterThisRule;
        this.firePropertyChange("stopAfterThisRule", old, stopAfterThisRule);
    }

    public boolean isStopAfterThisRule() {
        return this._stopAfterThisRule;
    }

    public LibraryBundlificationRule copy() {
        LibraryBundlificationRule result = new LibraryBundlificationRule();
        result._additionalProperties = this._additionalProperties;
        result._ruleRegex = this._ruleRegex;
        result._doNotBundle = this._doNotBundle;
        result._stopAfterThisRule = this._stopAfterThisRule;
        return result;
    }
}

