/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.frameworkintegration.impl;

import com.intellij.execution.configurations.DebuggingRunnerData;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.frameworkintegration.FrameworkInstanceManager;
import org.osmorc.frameworkintegration.FrameworkIntegrator;
import org.osmorc.frameworkintegration.FrameworkIntegratorRegistry;
import org.osmorc.frameworkintegration.FrameworkRunner;
import org.osmorc.frameworkintegration.util.PropertiesWrapper;
import org.osmorc.run.OsgiRunConfiguration;
import org.osmorc.run.ui.SelectedBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFrameworkRunner<P extends PropertiesWrapper>
implements FrameworkRunner {
    private Project myProject;
    private OsgiRunConfiguration myRunConfiguration;
    private RunnerSettings myRunnerSettings;
    private P myAdditionalProperties;
    private File workingDir;
    private File frameworkDir;

    @Override
    public void init(@NotNull Project project, @NotNull OsgiRunConfiguration runConfiguration, RunnerSettings runnerSettings) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/impl/AbstractFrameworkRunner.init must not be null");
        }
        if (runConfiguration == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/frameworkintegration/impl/AbstractFrameworkRunner.init must not be null");
        }
        this.myProject = project;
        this.myRunConfiguration = runConfiguration;
        this.myRunnerSettings = runnerSettings;
        this.myAdditionalProperties = this.convertProperties(this.myRunConfiguration.getAdditionalProperties());
    }

    protected P getFrameworkProperties() {
        return this.myAdditionalProperties;
    }

    protected int getFrameworkStartLevel(SelectedBundle[] bundlesToStart) {
        if (this.myRunConfiguration.isAutoStartLevel()) {
            int sl = 0;
            for (SelectedBundle selectedBundle : bundlesToStart) {
                sl = Math.max(selectedBundle.getStartLevel(), sl);
            }
            return sl;
        }
        return this.myRunConfiguration.getFrameworkStartLevel();
    }

    protected boolean isDebugRun() {
        return this.myRunnerSettings.getData() instanceof DebuggingRunnerData;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    protected String getDebugPort() {
        if (!this.isDebugRun()) {
            return "-1";
        }
        DebuggingRunnerData data = (DebuggingRunnerData)this.myRunnerSettings.getData();
        String string = data.getDebugPort();
        String string2 = string;
        if (string == null) throw new IllegalStateException("@NotNull method org/osmorc/frameworkintegration/impl/AbstractFrameworkRunner.getDebugPort must not return null");
        return string2;
    }

    @Override
    @NotNull
    public File getWorkingDir() {
        if (this.workingDir == null) {
            String path = this.getRunConfiguration().isGenerateWorkingDir() ? PathManager.getSystemPath() + File.separator + "osmorc" + File.separator + "runtmp" + System.currentTimeMillis() : this.getRunConfiguration().getWorkingDir();
            File dir = new File(path);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            this.workingDir = dir;
        }
        File file = this.workingDir;
        if (file == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/frameworkintegration/impl/AbstractFrameworkRunner.getWorkingDir must not return null");
        }
        return file;
    }

    public void dispose() {
        if (this.getRunConfiguration().isGenerateWorkingDir()) {
            FileUtil.asyncDelete((File)this.getWorkingDir());
        }
    }

    @NotNull
    protected abstract P convertProperties(Map<String, String> var1);

    protected Project getProject() {
        return this.myProject;
    }

    @NotNull
    protected OsgiRunConfiguration getRunConfiguration() {
        OsgiRunConfiguration osgiRunConfiguration = this.myRunConfiguration;
        if (osgiRunConfiguration == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/frameworkintegration/impl/AbstractFrameworkRunner.getRunConfiguration must not return null");
        }
        return osgiRunConfiguration;
    }

    protected RunnerSettings getRunnerSettings() {
        return this.myRunnerSettings;
    }

    @Override
    @NotNull
    public List<VirtualFile> getFrameworkStarterLibraries() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        FrameworkInstanceDefinition definition = this.getRunConfiguration().getInstanceToUse();
        FrameworkIntegratorRegistry registry = (FrameworkIntegratorRegistry)ServiceManager.getService((Project)this.getProject(), FrameworkIntegratorRegistry.class);
        FrameworkIntegrator integrator = registry.findIntegratorByInstanceDefinition(definition);
        FrameworkInstanceManager frameworkInstanceManager = integrator.getFrameworkInstanceManager();
        List<Library> libs = frameworkInstanceManager.getLibraries(definition);
        Pattern starterClasspathPattern = this.getFrameworkStarterClasspathPattern();
        for (Library lib : libs) {
            for (VirtualFile virtualFile : lib.getFiles(OrderRootType.CLASSES_AND_OUTPUT)) {
                if (starterClasspathPattern != null && !starterClasspathPattern.matcher(virtualFile.getName()).matches()) continue;
                result.add(virtualFile);
            }
        }
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/frameworkintegration/impl/AbstractFrameworkRunner.getFrameworkStarterLibraries must not return null");
        }
        return arrayList;
    }

    @Nullable
    protected abstract Pattern getFrameworkStarterClasspathPattern();
}

