/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.frameworkintegration.impl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.net.HttpConfigurable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.osmorc.frameworkintegration.CachingBundleInfoProvider;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.frameworkintegration.impl.AbstractFrameworkRunner;
import org.osmorc.frameworkintegration.impl.GenericRunProperties;
import org.osmorc.run.ExternalVMFrameworkRunner;
import org.osmorc.run.ui.SelectedBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPaxBasedFrameworkRunner<P extends GenericRunProperties>
extends AbstractFrameworkRunner<P>
implements ExternalVMFrameworkRunner {
    private static final String PaxRunnerLib = "pax-runner-1.5.0-SNAPSHOT.jar";

    protected AbstractPaxBasedFrameworkRunner() {
    }

    @Override
    @NotNull
    public final List<VirtualFile> getFrameworkStarterLibraries() {
        String paxLib = PluginManager.getPlugin((PluginId)PluginId.getId((String)"Osmorc")).getPath().getPath() + "/lib/" + PaxRunnerLib;
        ArrayList<VirtualFile> libs = new ArrayList<VirtualFile>(1);
        VirtualFile path = LocalFileSystem.getInstance().findFileByPath(paxLib);
        if (path == null) {
            String[] classpath;
            for (String s : classpath = System.getProperty("java.class.path").split(File.pathSeparator)) {
                if (!s.contains(PaxRunnerLib) || (path = LocalFileSystem.getInstance().findFileByPath(s)) == null) continue;
                libs.add(path);
                break;
            }
        } else {
            libs.add(path);
        }
        ArrayList<VirtualFile> arrayList = libs;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/frameworkintegration/impl/AbstractPaxBasedFrameworkRunner.getFrameworkStarterLibraries must not return null");
        }
        return arrayList;
    }

    @Override
    public void fillCommandLineParameters(@NotNull ParametersList commandLineParameters, @NotNull SelectedBundle[] bundlesToInstall) {
        String additionalVmOptions;
        String systemPackages;
        if (commandLineParameters == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/impl/AbstractPaxBasedFrameworkRunner.fillCommandLineParameters must not be null");
        }
        if (bundlesToInstall == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/frameworkintegration/impl/AbstractPaxBasedFrameworkRunner.fillCommandLineParameters must not be null");
        }
        commandLineParameters.add("--p=" + this.getOsgiFrameworkName().toLowerCase());
        FrameworkInstanceDefinition definition = this.getRunConfiguration().getInstanceToUse();
        String version = definition.getVersion();
        if (version != null && version.length() > 0) {
            commandLineParameters.add("--v=" + version);
        }
        for (SelectedBundle bundle : bundlesToInstall) {
            String prefix;
            String string = prefix = CachingBundleInfoProvider.isExploded(bundle.getBundleUrl()) ? "scan-bundle:" : "";
            if (bundle.isStartAfterInstallation() && !CachingBundleInfoProvider.isFragmentBundle(bundle.getBundleUrl())) {
                commandLineParameters.add(prefix + bundle.getBundleUrl() + "@" + bundle.getStartLevel());
                continue;
            }
            if (CachingBundleInfoProvider.isFragmentBundle(bundle.getBundleUrl())) {
                commandLineParameters.add(prefix + bundle.getBundleUrl() + "@nostart");
                continue;
            }
            commandLineParameters.add(prefix + bundle.getBundleUrl());
        }
        GenericRunProperties frameworkProperties = (GenericRunProperties)((Object)this.getFrameworkProperties());
        String bootDelegation = frameworkProperties.getBootDelegation();
        if (bootDelegation != null && bootDelegation.trim().length() != 0) {
            commandLineParameters.add("--bd=" + bootDelegation);
        }
        if ((systemPackages = frameworkProperties.getSystemPackages()) != null && systemPackages.trim().length() != 0) {
            commandLineParameters.add("--sp=" + systemPackages);
        }
        int startLevel = this.getFrameworkStartLevel(bundlesToInstall);
        commandLineParameters.add("--sl=" + startLevel);
        int defaultStartLevel = this.getRunConfiguration().getDefaultStartLevel();
        commandLineParameters.add("--bsl=" + defaultStartLevel);
        if (frameworkProperties.isDebugMode()) {
            commandLineParameters.add("--log=DEBUG");
        }
        if (frameworkProperties.isStartConsole()) {
            commandLineParameters.add("--console");
        } else {
            commandLineParameters.add("--noConsole");
        }
        StringBuilder vmOptionsParam = new StringBuilder();
        vmOptionsParam.append("--vmOptions=");
        String vmParameters = this.getRunConfiguration().getVmParameters();
        if (vmParameters.length() > 0) {
            vmOptionsParam.append(vmParameters);
        }
        if ((additionalVmOptions = this.getAdditionalTargetVMProperties(bundlesToInstall)).length() > 0) {
            vmOptionsParam.append(" ").append(additionalVmOptions);
        }
        if (this.isDebugRun()) {
            String debugParams = "-Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,server=n,suspend=n,address=" + this.getDebugPort();
            vmOptionsParam.append(" ").append(debugParams);
        }
        commandLineParameters.add(vmOptionsParam.toString());
        commandLineParameters.add("--keepOriginalUrls");
        commandLineParameters.add("--skipInvalidBundles");
        String additionalProgramParams = this.getRunConfiguration().getProgramParameters();
        if (additionalProgramParams != null && !"".equals(additionalProgramParams)) {
            commandLineParameters.addParametersString(additionalProgramParams);
        }
    }

    @Override
    public void fillVmParameters(ParametersList vmParameters, @NotNull SelectedBundle[] bundlesToInstall) {
        if (bundlesToInstall == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/frameworkintegration/impl/AbstractPaxBasedFrameworkRunner.fillVmParameters must not be null");
        }
        HttpConfigurable httpConfigurable = HttpConfigurable.getInstance();
        if (httpConfigurable.USE_HTTP_PROXY) {
            vmParameters.defineProperty("proxySet", "true");
            vmParameters.defineProperty("http.proxyHost", httpConfigurable.PROXY_HOST);
            vmParameters.defineProperty("http.proxyPort", Integer.toString(httpConfigurable.PROXY_PORT));
            vmParameters.defineProperty("https.proxyHost", httpConfigurable.PROXY_HOST);
            vmParameters.defineProperty("https.proxyPort", Integer.toString(httpConfigurable.PROXY_PORT));
        }
    }

    @Override
    public void runCustomInstallationSteps(@NotNull SelectedBundle[] bundlesToInstall) throws ExecutionException {
        if (bundlesToInstall == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/impl/AbstractPaxBasedFrameworkRunner.runCustomInstallationSteps must not be null");
        }
    }

    @NotNull
    protected abstract String getOsgiFrameworkName();

    @NotNull
    protected String getAdditionalTargetVMProperties(@NotNull SelectedBundle[] urlsOfBundlesToInstall) {
        if (urlsOfBundlesToInstall == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/impl/AbstractPaxBasedFrameworkRunner.getAdditionalTargetVMProperties must not be null");
        }
        if ("" == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/frameworkintegration/impl/AbstractPaxBasedFrameworkRunner.getAdditionalTargetVMProperties must not return null");
        }
        return "";
    }

    @Override
    @NotNull
    @NonNls
    public final String getMainClass() {
        if ("org.ops4j.pax.runner.Run" == null) {
            throw new IllegalStateException("@NotNull method org/osmorc/frameworkintegration/impl/AbstractPaxBasedFrameworkRunner.getMainClass must not return null");
        }
        return "org.ops4j.pax.runner.Run";
    }

    @Override
    protected final Pattern getFrameworkStarterClasspathPattern() {
        return null;
    }
}

