/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.frameworkintegration.impl;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import java.io.File;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.run.OsgiRunConfiguration;
import org.osmorc.run.OsgiRunConfigurationChecker;

public class DefaultOsgiRunConfigurationChecker
implements OsgiRunConfigurationChecker {
    public final void checkConfiguration(OsgiRunConfiguration runConfiguration) throws RuntimeConfigurationException {
        String version;
        if (!runConfiguration.isGenerateWorkingDir()) {
            if (runConfiguration.getWorkingDir() == null || "".equals(runConfiguration.getWorkingDir())) {
                throw new RuntimeConfigurationError("The runtime directory is not specified. Please set a runtime directory at the 'Parameters' tab or select 'Recreate each time'.");
            }
            File dir = new File(runConfiguration.getWorkingDir());
            if (!dir.exists() && !dir.mkdirs()) {
                throw new RuntimeConfigurationError("The runtime directory could not be created. Please check the path at the 'Parameters' tab.");
            }
        }
        this.checkFrameworkSpecifics(runConfiguration);
        FrameworkInstanceDefinition frameworkInstanceDefinition = runConfiguration.getInstanceToUse();
        if (frameworkInstanceDefinition != null && ((version = frameworkInstanceDefinition.getVersion()) == null || version.length() == 0 && !runConfiguration.getProgramParameters().contains("--v=") && !runConfiguration.getProgramParameters().contains("--version="))) {
            throw new RuntimeConfigurationWarning("You did not specify a version to be used for '" + frameworkInstanceDefinition.getName() + "'. The runner will download and use the latest available version for this framework.");
        }
    }

    protected void checkFrameworkSpecifics(OsgiRunConfiguration runConfiguration) throws RuntimeConfigurationException {
    }
}

