/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.frameworkintegration.impl;

import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.osmorc.frameworkintegration.FrameworkInstanceLibrarySourceFinder;
import org.osmorc.frameworkintegration.LibraryHandler;
import org.osmorc.frameworkintegration.util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryHandlerImpl
implements LibraryHandler {
    private static final String FRAMEWORK_INSTANCE_LIBRARY_NAME_PREFIX_SEPARATOR = "/";
    private static final String FRAMEWORK_INSTANCE_LIBRARY_NAME_OSMORC_PREFIX = "Osmorc";
    private boolean _isChangingLibraries;
    private LibraryTable.ModifiableModel _modifiableApplicationLibraryTableModel;
    private List<Library.ModifiableModel> _modifiableLibraryModels;

    @Override
    public void startLibraryChanges() {
        this._modifiableApplicationLibraryTableModel = LibraryTablesRegistrar.getInstance().getLibraryTable().getModifiableModel();
        this._modifiableLibraryModels = new ArrayList<Library.ModifiableModel>();
        this._isChangingLibraries = true;
    }

    @Override
    public void commitLibraryChanges() {
        for (Library.ModifiableModel model : this._modifiableLibraryModels) {
            model.commit();
        }
        this._modifiableLibraryModels.clear();
        this._modifiableApplicationLibraryTableModel.commit();
    }

    @Override
    public void endLibraryChanges() {
        this._modifiableApplicationLibraryTableModel = null;
        this._modifiableLibraryModels = null;
        this._isChangingLibraries = false;
    }

    @Override
    public boolean hasLibraryChanges() {
        return this._modifiableApplicationLibraryTableModel.isChanged();
    }

    @Override
    public boolean isChangingLibraries() {
        return this._isChangingLibraries;
    }

    @Override
    public void createLibrariesFromBundles(@NotNull VirtualFile bundleFolder, @NotNull String instanceName, @NotNull FrameworkInstanceLibrarySourceFinder sourceFinder) {
        VirtualFile[] files;
        if (bundleFolder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/impl/LibraryHandlerImpl.createLibrariesFromBundles must not be null");
        }
        if (instanceName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/frameworkintegration/impl/LibraryHandlerImpl.createLibrariesFromBundles must not be null");
        }
        if (sourceFinder == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/osmorc/frameworkintegration/impl/LibraryHandlerImpl.createLibrariesFromBundles must not be null");
        }
        assert (this.isChangingLibraries());
        if (!bundleFolder.isDirectory()) {
            throw new IllegalArgumentException(bundleFolder.getPath() + " is not a folder");
        }
        for (VirtualFile file : files = bundleFolder.getChildren()) {
            VirtualFile manifest;
            VirtualFile dir = FileUtil.getFolder(file);
            if (dir == null || (manifest = dir.findFileByRelativePath("META-INF/MANIFEST.MF")) == null || sourceFinder.containsOnlySources(file)) continue;
            List<VirtualFile> sources = sourceFinder.getSourceForLibraryClasses(file);
            this._modifiableLibraryModels.add(this.createLibrary(instanceName, dir, sources));
        }
    }

    private Library.ModifiableModel createLibrary(@NotNull String instanceName, @NotNull VirtualFile classes, List<VirtualFile> sources) {
        if (instanceName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/impl/LibraryHandlerImpl.createLibrary must not be null");
        }
        if (classes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/frameworkintegration/impl/LibraryHandlerImpl.createLibrary must not be null");
        }
        Library library = this._modifiableApplicationLibraryTableModel.createLibrary(this.getLibraryPrefix(instanceName) + classes.getNameWithoutExtension());
        Library.ModifiableModel modifiableLibraryModel = library.getModifiableModel();
        modifiableLibraryModel.addRoot(classes, OrderRootType.CLASSES);
        for (VirtualFile source : sources) {
            VirtualFile sourceDir = FileUtil.getFolder(source);
            if (sourceDir != null) {
                modifiableLibraryModel.addRoot(sourceDir, OrderRootType.SOURCES);
                continue;
            }
            throw new RuntimeException(source + " is neither a directory nor a JAR.");
        }
        return modifiableLibraryModel;
    }

    private String getLibraryPrefix(String instanceName) {
        return this.getFrameworkInstanceLibraryPrefix() + instanceName + FRAMEWORK_INSTANCE_LIBRARY_NAME_PREFIX_SEPARATOR;
    }

    private String getFrameworkInstanceLibraryPrefix() {
        return "Osmorc/";
    }

    @Override
    public List<Library> getLibraries(@NotNull String instanceName) {
        if (instanceName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/impl/LibraryHandlerImpl.getLibraries must not be null");
        }
        ArrayList<Library> result = new ArrayList<Library>();
        String libraryPrefix = this.getLibraryPrefix(instanceName);
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable();
        for (Library library : libraryTable.getLibraries()) {
            if (!library.getName().startsWith(libraryPrefix)) continue;
            result.add(library);
        }
        return result;
    }

    @Override
    public boolean isFrameworkInstanceLibrary(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/impl/LibraryHandlerImpl.isFrameworkInstanceLibrary must not be null");
        }
        return library.getName() != null && library.getName().startsWith(this.getFrameworkInstanceLibraryPrefix()) && "application".equals(library.getTable().getTableLevel());
    }

    @Override
    public boolean isFrameworkInstanceLibrary(@NotNull LibraryOrderEntry libraryOrderEntry) {
        if (libraryOrderEntry == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/impl/LibraryHandlerImpl.isFrameworkInstanceLibrary must not be null");
        }
        return libraryOrderEntry.getLibraryName() != null && libraryOrderEntry.getLibraryName().startsWith(this.getFrameworkInstanceLibraryPrefix()) && "application".equals(libraryOrderEntry.getLibraryLevel());
    }

    @Override
    public void deleteLibraries(String instanceName) {
        List<Library> libraries = this.getLibraries(instanceName);
        for (Library library : libraries) {
            this._modifiableApplicationLibraryTableModel.removeLibrary(library);
        }
    }

    @Override
    public String getShortLibraryName(String instanceName, Library library) {
        String libraryPrefix = this.getLibraryPrefix(instanceName);
        String libraryName = library.getName();
        if (libraryName.startsWith(libraryPrefix)) {
            return libraryName.substring(libraryPrefix.length());
        }
        return libraryName;
    }
}

