/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.frameworkintegration.impl.concierge;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.frameworkintegration.FrameworkInstanceManager;
import org.osmorc.frameworkintegration.LibraryHandler;
import org.osmorc.frameworkintegration.impl.concierge.ConciergeSourceFinder;
import org.osmorc.i18n.OsmorcBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConciergeFrameworkInstanceManager
implements FrameworkInstanceManager {
    private final LibraryHandler _libraryHandler;
    private final LocalFileSystem _fileSystem;
    private final Application _application;

    public ConciergeFrameworkInstanceManager(LibraryHandler libraryHandler, LocalFileSystem fileSystem, Application application) {
        this._libraryHandler = libraryHandler;
        this._fileSystem = fileSystem;
        this._application = application;
    }

    @Override
    public void createLibraries(final FrameworkInstanceDefinition frameworkInstanceDefinition) {
        final VirtualFile installFolder = this._fileSystem.findFileByPath(frameworkInstanceDefinition.getBaseFolder());
        if (installFolder == null) {
            throw new RuntimeException("The folder " + frameworkInstanceDefinition.getBaseFolder() + " does not exist.");
        }
        if (!installFolder.isDirectory()) {
            throw new RuntimeException(frameworkInstanceDefinition.getBaseFolder() + " is not a folder");
        }
        this._application.runWriteAction(new Runnable(){

            public void run() {
                installFolder.refresh(false, true);
                ConciergeSourceFinder sourceFinder = new ConciergeSourceFinder(installFolder);
                ConciergeFrameworkInstanceManager.this._libraryHandler.startLibraryChanges();
                ConciergeFrameworkInstanceManager.this._libraryHandler.createLibrariesFromBundles(installFolder, frameworkInstanceDefinition.getName(), sourceFinder);
                VirtualFile bundlesFolder = installFolder.findChild("bundles");
                if (bundlesFolder != null) {
                    if (!bundlesFolder.isDirectory()) {
                        throw new RuntimeException(bundlesFolder.getPath() + " is not a folder");
                    }
                    ConciergeFrameworkInstanceManager.this._libraryHandler.createLibrariesFromBundles(bundlesFolder, frameworkInstanceDefinition.getName(), sourceFinder);
                }
                ConciergeFrameworkInstanceManager.this._libraryHandler.commitLibraryChanges();
            }
        });
    }

    @Override
    public void removeLibraries(final FrameworkInstanceDefinition frameworkInstanceDefinition) {
        this._application.runWriteAction(new Runnable(){

            public void run() {
                ConciergeFrameworkInstanceManager.this._libraryHandler.startLibraryChanges();
                ConciergeFrameworkInstanceManager.this._libraryHandler.deleteLibraries(frameworkInstanceDefinition.getName());
                ConciergeFrameworkInstanceManager.this._libraryHandler.commitLibraryChanges();
            }
        });
    }

    @Override
    public List<Library> getLibraries(FrameworkInstanceDefinition frameworkInstanceDefinition) {
        return this._libraryHandler.getLibraries(frameworkInstanceDefinition.getName());
    }

    @Override
    public String checkValidity(@NotNull FrameworkInstanceDefinition frameworkInstanceDefinition) {
        if (frameworkInstanceDefinition == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/impl/concierge/ConciergeFrameworkInstanceManager.checkValidity must not be null");
        }
        if (frameworkInstanceDefinition.getName() == null || frameworkInstanceDefinition.getName().trim().length() == 0) {
            return "A name for the framework instance needs to be given.";
        }
        VirtualFile installFolder = this._fileSystem.findFileByPath(frameworkInstanceDefinition.getBaseFolder());
        if (installFolder == null || !installFolder.isDirectory()) {
            return OsmorcBundle.getTranslation("concierge.folder.does.not.exist", frameworkInstanceDefinition.getBaseFolder());
        }
        VirtualFile bundlesFolder = installFolder.findChild("bundles");
        if (bundlesFolder == null || !bundlesFolder.isDirectory()) {
            return OsmorcBundle.getTranslation("concierge.folder.bundles.missing", installFolder.getPath());
        }
        return null;
    }
}

