/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.frameworkintegration.impl.concierge;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.osmorc.frameworkintegration.FrameworkInstanceLibrarySourceFinder;
import org.osmorc.frameworkintegration.util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConciergeSourceFinder
implements FrameworkInstanceLibrarySourceFinder {
    @NonNls
    private VirtualFile _sourceFolder;

    public ConciergeSourceFinder(@NotNull VirtualFile conciergeRootFolder) {
        if (conciergeRootFolder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/impl/concierge/ConciergeSourceFinder.<init> must not be null");
        }
        this._sourceFolder = conciergeRootFolder.findChild("src");
    }

    @Override
    public List<VirtualFile> getSourceForLibraryClasses(@NotNull VirtualFile libraryClasses) {
        String sourceZIPName;
        VirtualFile sourceZIP;
        VirtualFile sourceFolder;
        if (libraryClasses == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/impl/concierge/ConciergeSourceFinder.getSourceForLibraryClasses must not be null");
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        if (this._sourceFolder != null && (sourceFolder = FileUtil.getFolder(sourceZIP = this._sourceFolder.findChild(sourceZIPName = FileUtil.getNameWithoutJarSuffix(libraryClasses) + ".zip"))) != null) {
            result.add(sourceFolder);
        }
        return result;
    }

    @Override
    public boolean containsOnlySources(@NotNull VirtualFile libraryClassesCondidate) {
        if (libraryClassesCondidate == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/impl/concierge/ConciergeSourceFinder.containsOnlySources must not be null");
        }
        return false;
    }
}

