/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.frameworkintegration.impl.equinox;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.osmorc.frameworkintegration.BundleSelectionAction;
import org.osmorc.frameworkintegration.CachingBundleInfoProvider;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.frameworkintegration.FrameworkIntegrator;
import org.osmorc.frameworkintegration.FrameworkIntegratorRegistry;
import org.osmorc.make.BundleCompiler;
import org.osmorc.run.ui.SelectedBundle;

class AdaptToRunWithUpdateConfiguratorAction
extends BundleSelectionAction {
    private static final String ORG_ECLIPSE_EQUINOX_COMMON_URL = "org.eclipse.equinox.common_";
    private static final String ORG_ECLIPSE_UPDATE_CONFIGURATOR_URL = "org.eclipse.update.configurator_";
    private static final String ORG_ECLIPSE_CORE_RUNTIME_URL = "org.eclipse.core.runtime_";

    public AdaptToRunWithUpdateConfiguratorAction() {
        super("Adapt to Run With Update Configurator");
    }

    public void actionPerformed(AnActionEvent e) {
        ArrayList<String> necessaryFrameworkBundleURLs = new ArrayList<String>();
        necessaryFrameworkBundleURLs.add(ORG_ECLIPSE_EQUINOX_COMMON_URL);
        necessaryFrameworkBundleURLs.add(ORG_ECLIPSE_UPDATE_CONFIGURATOR_URL);
        necessaryFrameworkBundleURLs.add(ORG_ECLIPSE_CORE_RUNTIME_URL);
        ArrayList<SelectedBundle> currentlySelectedBundles = new ArrayList<SelectedBundle>(this.getContext().getCurrentlySelectedBundles());
        for (SelectedBundle selectedBundle : currentlySelectedBundles) {
            if (selectedBundle.getBundleType() != SelectedBundle.BundleType.FrameworkBundle) continue;
            String url = selectedBundle.getBundleUrl();
            boolean necessaryFrameworkBundleFound = false;
            if (url != null) {
                Iterator iterator = necessaryFrameworkBundleURLs.iterator();
                while (iterator.hasNext()) {
                    String necessaryFrameworkBundleURL = (String)iterator.next();
                    if (!url.contains(necessaryFrameworkBundleURL)) continue;
                    this.adaptBundle(selectedBundle);
                    necessaryFrameworkBundleFound = true;
                    iterator.remove();
                    break;
                }
            }
            if (necessaryFrameworkBundleFound) continue;
            this.getContext().removeBundle(selectedBundle);
        }
        if (necessaryFrameworkBundleURLs.size() > 0) {
            FrameworkInstanceDefinition instance = this.getContext().getUsedFrameworkInstance();
            FrameworkIntegratorRegistry registry = (FrameworkIntegratorRegistry)ServiceManager.getService(FrameworkIntegratorRegistry.class);
            assert (instance != null);
            FrameworkIntegrator frameworkIntegrator = registry.findIntegratorByInstanceDefinition(instance);
            List<Library> libraries = frameworkIntegrator.getFrameworkInstanceManager().getLibraries(instance);
            for (Library library : libraries) {
                String[] urls;
                block3: for (String url : urls = library.getUrls(OrderRootType.CLASSES)) {
                    Iterator iterator = necessaryFrameworkBundleURLs.iterator();
                    while (iterator.hasNext()) {
                        String necessaryFrameworkBundleURL = (String)iterator.next();
                        if (!url.contains(necessaryFrameworkBundleURL)) continue;
                        SelectedBundle bundle = this.createSelectedFrameworkBundle(url);
                        this.adaptBundle(bundle);
                        iterator.remove();
                        this.getContext().addBundle(bundle);
                        continue block3;
                    }
                }
            }
        }
    }

    private void adaptBundle(@NotNull SelectedBundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/impl/equinox/AdaptToRunWithUpdateConfiguratorAction.adaptBundle must not be null");
        }
        String url = bundle.getBundleUrl();
        assert (url != null);
        if (url.contains(ORG_ECLIPSE_EQUINOX_COMMON_URL)) {
            bundle.setStartLevel(2);
            bundle.setStartAfterInstallation(true);
        } else if (url.contains(ORG_ECLIPSE_UPDATE_CONFIGURATOR_URL)) {
            bundle.setStartLevel(3);
            bundle.setStartAfterInstallation(true);
        } else if (url.contains(ORG_ECLIPSE_CORE_RUNTIME_URL)) {
            bundle.setStartLevel(4);
            bundle.setStartAfterInstallation(true);
        }
    }

    private SelectedBundle createSelectedFrameworkBundle(String url) {
        url = BundleCompiler.convertJarUrlToFileUrl(url);
        url = BundleCompiler.fixFileURL(url);
        String bundleName = CachingBundleInfoProvider.getBundleSymbolicName(url);
        SelectedBundle bundle = null;
        if (bundleName != null) {
            String bundleVersion = CachingBundleInfoProvider.getBundleVersions(url);
            bundle = new SelectedBundle(bundleName + " - " + bundleVersion, url, SelectedBundle.BundleType.FrameworkBundle);
        }
        return bundle;
    }
}

