/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.frameworkintegration.impl.equinox;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.osmorc.frameworkintegration.BundleSelectionAction;
import org.osmorc.frameworkintegration.CachingBundleInfoProvider;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.frameworkintegration.FrameworkIntegrator;
import org.osmorc.frameworkintegration.FrameworkIntegratorRegistry;
import org.osmorc.make.BundleCompiler;
import org.osmorc.run.ui.SelectedBundle;

class AdaptToRunWithoutUpdateConfigurator
extends BundleSelectionAction {
    private static final String ORG_ECLIPSE_UPDATE_CONFIGURATOR_URL = "org.eclipse.update.configurator_";
    private static final String ORG_ECLIPSE_OSGI_URL = "org.eclipse.osgi_";

    public AdaptToRunWithoutUpdateConfigurator() {
        super("Start all plugins");
    }

    public void actionPerformed(AnActionEvent e) {
        ArrayList<SelectedBundle> currentlySelectedBundles = new ArrayList<SelectedBundle>(this.getContext().getCurrentlySelectedBundles());
        for (SelectedBundle selectedBundle : currentlySelectedBundles) {
            String url;
            if (selectedBundle.getBundleType() != SelectedBundle.BundleType.FrameworkBundle || (url = selectedBundle.getBundleUrl()) == null) continue;
            if (url.contains(ORG_ECLIPSE_UPDATE_CONFIGURATOR_URL) || url.contains(ORG_ECLIPSE_OSGI_URL)) {
                this.getContext().removeBundle(selectedBundle);
                continue;
            }
            this.adaptBundle(selectedBundle);
        }
        SelectedBundle prototypeBundle = null;
        FrameworkInstanceDefinition instance = this.getContext().getUsedFrameworkInstance();
        FrameworkIntegratorRegistry registry = (FrameworkIntegratorRegistry)ServiceManager.getService(FrameworkIntegratorRegistry.class);
        assert (instance != null);
        FrameworkIntegrator frameworkIntegrator = registry.findIntegratorByInstanceDefinition(instance);
        List<Library> libraries = frameworkIntegrator.getFrameworkInstanceManager().getLibraries(instance);
        for (Library library : libraries) {
            String[] urls;
            for (String url : urls = library.getUrls(OrderRootType.CLASSES)) {
                if (url.contains(ORG_ECLIPSE_UPDATE_CONFIGURATOR_URL) || url.contains(ORG_ECLIPSE_OSGI_URL) || (prototypeBundle = this.createSelectedFrameworkBundle(prototypeBundle, url)) == null || currentlySelectedBundles.contains(prototypeBundle)) continue;
                this.adaptBundle(prototypeBundle);
                this.getContext().addBundle(prototypeBundle);
                prototypeBundle = null;
            }
        }
    }

    private SelectedBundle createSelectedFrameworkBundle(SelectedBundle prototypeBundle, String url) {
        String bundleUrl = BundleCompiler.convertJarUrlToFileUrl(url);
        bundleUrl = BundleCompiler.fixFileURL(bundleUrl);
        String bundleName = CachingBundleInfoProvider.getBundleSymbolicName(bundleUrl);
        SelectedBundle bundle = null;
        if (bundleName != null) {
            bundle = prototypeBundle;
            String bundleVersion = CachingBundleInfoProvider.getBundleVersions(bundleUrl);
            String displayName = bundleName + " - " + bundleVersion;
            if (bundle != null) {
                bundle.setName(displayName);
                bundle.setBundleUrl(bundleUrl);
            } else {
                bundle = new SelectedBundle(displayName, bundleUrl, SelectedBundle.BundleType.FrameworkBundle);
            }
        }
        return bundle;
    }

    private void adaptBundle(@NotNull SelectedBundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/impl/equinox/AdaptToRunWithoutUpdateConfigurator.adaptBundle must not be null");
        }
        String url = bundle.getBundleUrl();
        assert (url != null);
        if (url.contains("org.eclipse.core.runtime_")) {
            bundle.setStartLevel(4);
            bundle.setStartAfterInstallation(true);
        } else {
            bundle.setStartLevel(4);
            bundle.setStartAfterInstallation(false);
        }
    }
}

