/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.frameworkintegration.impl.equinox;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.text.MessageFormat;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.frameworkintegration.FrameworkInstanceManager;
import org.osmorc.frameworkintegration.LibraryHandler;
import org.osmorc.frameworkintegration.impl.equinox.EquinoxSourceFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquinoxFrameworkInstanceManager
implements FrameworkInstanceManager {
    private final LibraryHandler libraryHandler;
    private final VirtualFileSystem fileSystem;
    private Application application;
    private final EquinoxSourceFinder equinoxSourceFinder;
    protected static final String FOLDER_DOES_NOT_EXIST = "The folder <strong>{0}</strong> does not exist or is not a folder. The folder should be an existing folder containing a <strong>plugins</strong> folder which contains the bundles of your Equinox installation. ";
    protected static final String NO_PLUGINS_FOLDER = "The folder  <strong>{0}</strong> does not contain a <strong>plugins</strong> folder or <strong>plugins</strong> is not a folder. The base folder needs to be the folder of your Equinox installation which contains a <strong>plugins</strong> folder containing all bundle JARs of your Equinox installation.";
    private static final Logger LOG = Logger.getInstance((String)"org.osmorc.frameworkintegration.impl.equinox.EquinoxFrameworkInstanceManager");

    public EquinoxFrameworkInstanceManager(LibraryHandler libraryHandler, LocalFileSystem fileSystem, Application application) {
        this.libraryHandler = libraryHandler;
        this.fileSystem = fileSystem;
        this.application = application;
        this.equinoxSourceFinder = new EquinoxSourceFinder();
    }

    @Override
    public void createLibraries(final FrameworkInstanceDefinition frameworkInstanceDefinition) {
        VirtualFile equinoxFolder = this.fileSystem.findFileByPath(frameworkInstanceDefinition.getBaseFolder());
        assert (equinoxFolder != null);
        final VirtualFile pluginsFolder = equinoxFolder.findChild("plugins");
        if (pluginsFolder == null) {
            throw new RuntimeException("the folder " + equinoxFolder.getName() + " does not contain a plugins folder.");
        }
        this.application.runWriteAction(new Runnable(){

            public void run() {
                pluginsFolder.refresh(false, true);
                EquinoxFrameworkInstanceManager.this.libraryHandler.startLibraryChanges();
                EquinoxFrameworkInstanceManager.this.libraryHandler.createLibrariesFromBundles(pluginsFolder, frameworkInstanceDefinition.getName(), EquinoxFrameworkInstanceManager.this.equinoxSourceFinder);
                EquinoxFrameworkInstanceManager.this.libraryHandler.commitLibraryChanges();
            }
        });
    }

    @Override
    public void removeLibraries(final FrameworkInstanceDefinition frameworkInstanceDefinition) {
        this.application.runWriteAction(new Runnable(){

            public void run() {
                EquinoxFrameworkInstanceManager.this.libraryHandler.startLibraryChanges();
                EquinoxFrameworkInstanceManager.this.libraryHandler.deleteLibraries(frameworkInstanceDefinition.getName());
                EquinoxFrameworkInstanceManager.this.libraryHandler.commitLibraryChanges();
            }
        });
    }

    @Override
    public List<Library> getLibraries(FrameworkInstanceDefinition frameworkInstanceDefinition) {
        return this.libraryHandler.getLibraries(frameworkInstanceDefinition.getName());
    }

    @Override
    @Nullable
    public String checkValidity(@NotNull FrameworkInstanceDefinition frameworkInstanceDefinition) {
        if (frameworkInstanceDefinition == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/impl/equinox/EquinoxFrameworkInstanceManager.checkValidity must not be null");
        }
        if (frameworkInstanceDefinition.getName() == null || frameworkInstanceDefinition.getName().trim().length() == 0) {
            return "A name for the framework instance needs to be given.";
        }
        VirtualFile equinoxFolder = this.fileSystem.findFileByPath(frameworkInstanceDefinition.getBaseFolder());
        if (equinoxFolder == null || !equinoxFolder.isDirectory()) {
            return MessageFormat.format(FOLDER_DOES_NOT_EXIST, frameworkInstanceDefinition.getBaseFolder());
        }
        VirtualFile pluginsFolder = equinoxFolder.findChild("plugins");
        if (pluginsFolder == null || !pluginsFolder.isDirectory()) {
            return MessageFormat.format(NO_PLUGINS_FOLDER, frameworkInstanceDefinition.getBaseFolder());
        }
        return null;
    }
}

