/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.frameworkintegration.impl.equinox;

import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.util.SystemInfo;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.frameworkintegration.impl.DefaultOsgiRunConfigurationChecker;
import org.osmorc.frameworkintegration.impl.equinox.EquinoxRunProperties;
import org.osmorc.i18n.OsmorcBundle;
import org.osmorc.run.OsgiRunConfiguration;

public class EquinoxOsgiRunConfigurationChecker
extends DefaultOsgiRunConfigurationChecker {
    protected void checkFrameworkSpecifics(OsgiRunConfiguration runConfiguration) throws RuntimeConfigurationWarning {
        FrameworkInstanceDefinition frameworkInstanceDefinition = runConfiguration.getInstanceToUse();
        assert (frameworkInstanceDefinition != null);
        EquinoxRunProperties runProperties = new EquinoxRunProperties(runConfiguration.getAdditionalProperties());
        if (runProperties.getEquinoxApplication() != null && runProperties.getEquinoxApplication().length() > 0 || runProperties.getEquinoxProduct() != null && runProperties.getEquinoxProduct().length() > 0) {
            if (SystemInfo.isMac && !runConfiguration.getVmParameters().contains("-XstartOnFirstThread")) {
                throw new RuntimeConfigurationWarning("Using the JVM option -XstartOnFirstThread for running SWT apps on Mac OS X is highly recommended.");
            }
            if (runProperties.isStartConsole()) {
                throw new RuntimeConfigurationWarning(OsmorcBundle.getTranslation("runconfiguration.equinox.runningWithConsole", new Object[0]));
            }
        }
    }
}

