/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.frameworkintegration.impl.equinox;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ProjectConverter;
import com.intellij.conversion.RunManagerSettings;
import com.intellij.openapi.util.WriteExternalException;
import java.util.ArrayList;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.osmorc.frameworkintegration.impl.equinox.EquinoxRunProperties;
import org.osmorc.run.OsgiRunConfiguration;
import org.osmorc.run.ui.SelectedBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquinoxRunConfigurationConverter
extends ProjectConverter {
    public ConversionProcessor<RunManagerSettings> createRunConfigurationsConverter() {
        return new ActualConverter();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ActualConverter
    extends ConversionProcessor<RunManagerSettings> {
        private static final String EQUINOX_RUN_CONFIGURATION_TYPE = "#org.osmorc.EquinoxConfigurationType";
        @NonNls
        private static final String APPLICATION_ATTRIBUTE = "application";
        @NonNls
        private static final String PRODUCT_ATTRIBUTE = "product";
        @NonNls
        private static final String WORKING_DIR_ATTRIBUTE = "workingDir";
        @NonNls
        private static final String CONFIG_DIR_ATTRIBUTE = "configDir";
        @NonNls
        private static final String JVM_ARGS_ATTRIBUTE = "jvmArgs";
        @NonNls
        private static final String ADDITIONAL_ARGS_ATTRIBUTE = "additionalEquinoxArgs";
        @NonNls
        private static final String EQUINOX_CONSOLE = "equinoxConsole";
        @NonNls
        private static final String EQUINOX_DEBUG = "equinoxDebug";
        @NonNls
        private static final String USE_UPDATE_CONFIGURATOR = "useUpdateConfigurator";
        @NonNls
        private static final String CLEAN = "clean";

        private ActualConverter() {
        }

        public boolean isConversionNeeded(RunManagerSettings runManagerSettings) {
            for (Element element : runManagerSettings.getRunConfigurations()) {
                String confType = element.getAttributeValue("type");
                if (!EQUINOX_RUN_CONFIGURATION_TYPE.equals(confType)) continue;
                return true;
            }
            return false;
        }

        public void process(RunManagerSettings runManagerSettings) throws CannotConvertException {
            for (Element element : runManagerSettings.getRunConfigurations()) {
                String confType = element.getAttributeValue("type");
                if (!EQUINOX_RUN_CONFIGURATION_TYPE.equals(confType)) continue;
                String application = element.getAttributeValue(APPLICATION_ATTRIBUTE);
                String product = element.getAttributeValue(PRODUCT_ATTRIBUTE);
                String workingDir = element.getAttributeValue(WORKING_DIR_ATTRIBUTE);
                String configDir = element.getAttributeValue(CONFIG_DIR_ATTRIBUTE);
                String jvmArgs = element.getAttributeValue(JVM_ARGS_ATTRIBUTE);
                String additionalEquinoxArgs = element.getAttributeValue(ADDITIONAL_ARGS_ATTRIBUTE);
                boolean equinoxConsole = Boolean.valueOf(element.getAttributeValue(EQUINOX_CONSOLE, "false"));
                boolean equinoxDebug = Boolean.valueOf(element.getAttributeValue(EQUINOX_DEBUG, "false"));
                boolean clean = Boolean.valueOf(element.getAttributeValue(CLEAN, "true"));
                element.removeAttribute(APPLICATION_ATTRIBUTE);
                element.removeAttribute(PRODUCT_ATTRIBUTE);
                element.removeAttribute(WORKING_DIR_ATTRIBUTE);
                element.removeAttribute(CONFIG_DIR_ATTRIBUTE);
                element.removeAttribute(JVM_ARGS_ATTRIBUTE);
                element.removeAttribute(ADDITIONAL_ARGS_ATTRIBUTE);
                element.removeAttribute(EQUINOX_CONSOLE);
                element.removeAttribute(EQUINOX_DEBUG);
                element.removeAttribute(USE_UPDATE_CONFIGURATOR);
                element.removeAttribute(CLEAN);
                OsgiRunConfiguration osgiRunConfiguration = new OsgiRunConfiguration(null, null, null);
                osgiRunConfiguration.setWorkingDir(workingDir);
                osgiRunConfiguration.setVmParameters(jvmArgs);
                osgiRunConfiguration.setProgramParameters(additionalEquinoxArgs);
                EquinoxRunProperties runProperties = new EquinoxRunProperties(osgiRunConfiguration.getAdditionalProperties());
                runProperties.setEquinoxApplication(application);
                runProperties.setEquinoxProduct(product);
                runProperties.setStartConsole(equinoxConsole);
                runProperties.setDebugMode(equinoxDebug);
                osgiRunConfiguration.putAdditionalProperties(runProperties.getProperties());
                ArrayList<SelectedBundle> bundles = new ArrayList<SelectedBundle>();
                bundles.add(new SelectedBundle("legacyLoader", "org.osmorc.frameworkintegration.impl.equinox.LegacyEquinoxOsgiRunConfigurationLoader", SelectedBundle.BundleType.FrameworkBundle));
                osgiRunConfiguration.setBundlesToDeploy(bundles);
                element.setAttribute("type", "#org.osmorc.OsgiConfigurationType");
                element.setAttribute("factoryName", "OSGi Bundles");
                try {
                    osgiRunConfiguration.writeExternal(element);
                }
                catch (WriteExternalException e) {
                    throw new CannotConvertException("Error while converting legacy Eclipse Equinox run configuration", (Throwable)e);
                }
            }
        }
    }
}

