/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.frameworkintegration.impl.equinox;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.osmorc.frameworkintegration.FrameworkInstanceLibrarySourceFinder;
import org.osmorc.frameworkintegration.util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquinoxSourceFinder
implements FrameworkInstanceLibrarySourceFinder {
    private static final String SOURCE_JAR_NAME_SUBSTRING = ".source_";

    @Override
    public List<VirtualFile> getSourceForLibraryClasses(@NotNull VirtualFile libraryClasses) {
        String sourceFileName;
        VirtualFile source;
        String libraryFilename;
        int underscore;
        VirtualFile[] files;
        if (libraryClasses == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/impl/equinox/EquinoxSourceFinder.getSourceForLibraryClasses must not be null");
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        VirtualFile pluginDir = libraryClasses.getParent();
        assert (pluginDir != null);
        for (VirtualFile file : files = pluginDir.getChildren()) {
            VirtualFile sourceZIP;
            VirtualFile librarySourcesFolder;
            VirtualFile sourcesFolder;
            if (!file.isDirectory() || !file.getName().contains("source") || (sourcesFolder = file.findChild("src")) == null || !sourcesFolder.isDirectory() || (librarySourcesFolder = sourcesFolder.findChild(FileUtil.getNameWithoutJarSuffix(libraryClasses))) == null || !librarySourcesFolder.isDirectory() || (sourceZIP = librarySourcesFolder.findChild("src.zip")) == null) continue;
            result.add(sourceZIP);
            break;
        }
        if ((underscore = (libraryFilename = libraryClasses.getName()).indexOf(95)) > 0 && (source = pluginDir.findChild(sourceFileName = libraryFilename.substring(0, underscore) + SOURCE_JAR_NAME_SUBSTRING + libraryFilename.substring(underscore + 1))) != null) {
            result.add(source);
        }
        return result;
    }

    @Override
    public boolean containsOnlySources(@NotNull VirtualFile libraryClassesCondidate) {
        if (libraryClassesCondidate == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/impl/equinox/EquinoxSourceFinder.containsOnlySources must not be null");
        }
        return libraryClassesCondidate.getName().contains(SOURCE_JAR_NAME_SUBSTRING);
    }
}

