/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.frameworkintegration.impl.equinox;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.frameworkintegration.CachingBundleInfoProvider;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.frameworkintegration.FrameworkInstanceManager;
import org.osmorc.frameworkintegration.FrameworkIntegrator;
import org.osmorc.frameworkintegration.FrameworkIntegratorRegistry;
import org.osmorc.make.BundleCompiler;
import org.osmorc.run.LegacyOsgiRunConfigurationLoader;
import org.osmorc.run.OsgiRunConfiguration;
import org.osmorc.run.ui.SelectedBundle;
import org.osmorc.settings.ApplicationSettings;
import org.osmorc.settings.ProjectSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyEquinoxOsgiRunConfigurationLoader
implements LegacyOsgiRunConfigurationLoader {
    @Override
    public void finishAfterModulesAreAvailable(OsgiRunConfiguration osgiRunConfiguration) {
        List<SelectedBundle> bundlesToDeploy = osgiRunConfiguration.getBundlesToDeploy();
        this.addModuleBundles(bundlesToDeploy, osgiRunConfiguration.getProject());
        FrameworkInstanceDefinition frameworkInstanceDefinition = this.getFrameworkInstance(osgiRunConfiguration.getProject());
        if (frameworkInstanceDefinition != null) {
            osgiRunConfiguration.setInstanceToUse(frameworkInstanceDefinition);
            this.addFrameworkBundle(bundlesToDeploy, frameworkInstanceDefinition);
        }
    }

    @Nullable
    private FrameworkInstanceDefinition getFrameworkInstance(Project project) {
        ApplicationSettings applicationSettings = (ApplicationSettings)ServiceManager.getService(ApplicationSettings.class);
        ProjectSettings projectSettings = (ProjectSettings)ServiceManager.getService((Project)project, ProjectSettings.class);
        return applicationSettings.getFrameworkInstance(projectSettings.getFrameworkInstanceName());
    }

    private void addModuleBundles(List<SelectedBundle> bundlesToDeploy, Project project) {
        Module[] modules;
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            if (!OsmorcFacet.hasOsmorcFacet(module)) continue;
            SelectedBundle bundle = new SelectedBundle(module.getName(), null, SelectedBundle.BundleType.Module);
            bundle.setStartLevel(4);
            bundlesToDeploy.add(bundle);
        }
    }

    private void addFrameworkBundle(List<SelectedBundle> bundlesToDeploy, @NotNull FrameworkInstanceDefinition frameworkInstanceDefinition) {
        if (frameworkInstanceDefinition == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/osmorc/frameworkintegration/impl/equinox/LegacyEquinoxOsgiRunConfigurationLoader.addFrameworkBundle must not be null");
        }
        List<Library> libraries = this.getFrameworkLibraries(frameworkInstanceDefinition);
        for (Library library : libraries) {
            String[] urls;
            for (String url : urls = library.getUrls(OrderRootType.CLASSES)) {
                SelectedBundle bundle;
                if (url.contains("org.eclipse.equinox.common_")) {
                    bundle = this.createSelectedFrameworkBundle(url);
                    if (bundle == null) continue;
                    bundle.setStartLevel(2);
                    bundle.setStartAfterInstallation(true);
                    bundlesToDeploy.add(bundle);
                    continue;
                }
                if (url.contains("org.eclipse.update.configurator_")) {
                    bundle = this.createSelectedFrameworkBundle(url);
                    if (bundle == null) continue;
                    bundle.setStartLevel(3);
                    bundle.setStartAfterInstallation(true);
                    bundlesToDeploy.add(bundle);
                    continue;
                }
                if (!url.contains("org.eclipse.core.runtime_") || (bundle = this.createSelectedFrameworkBundle(url)) == null) continue;
                bundle.setStartLevel(4);
                bundle.setStartAfterInstallation(true);
                bundlesToDeploy.add(bundle);
            }
        }
    }

    @Nullable
    private SelectedBundle createSelectedFrameworkBundle(String url) {
        url = BundleCompiler.convertJarUrlToFileUrl(url);
        url = BundleCompiler.fixFileURL(url);
        String bundleName = CachingBundleInfoProvider.getBundleSymbolicName(url);
        SelectedBundle bundle = null;
        if (bundleName != null) {
            String bundleVersion = CachingBundleInfoProvider.getBundleVersions(url);
            bundle = new SelectedBundle(bundleName + " - " + bundleVersion, url, SelectedBundle.BundleType.FrameworkBundle);
        }
        return bundle;
    }

    private List<Library> getFrameworkLibraries(@NotNull FrameworkInstanceDefinition frameworkInstance) {
        if (frameworkInstance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/impl/equinox/LegacyEquinoxOsgiRunConfigurationLoader.getFrameworkLibraries must not be null");
        }
        FrameworkIntegratorRegistry registry = (FrameworkIntegratorRegistry)ServiceManager.getService(FrameworkIntegratorRegistry.class);
        FrameworkIntegrator frameworkIntegrator = registry.findIntegratorByInstanceDefinition(frameworkInstance);
        FrameworkInstanceManager frameworkInstanceManager = frameworkIntegrator.getFrameworkInstanceManager();
        return frameworkInstanceManager.getLibraries(frameworkInstance);
    }
}

