/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.frameworkintegration.impl.felix;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.text.MessageFormat;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.frameworkintegration.FrameworkInstanceManager;
import org.osmorc.frameworkintegration.LibraryHandler;
import org.osmorc.frameworkintegration.impl.felix.FelixSourceFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FelixFrameworkInstanceManager
implements FrameworkInstanceManager {
    private final LibraryHandler _libraryHandler;
    private final LocalFileSystem _fileSystem;
    private Application _application;
    private final FelixSourceFinder _felixSourceFinder;
    protected static final String FOLDER_DOES_NOT_EXIST = "The folder <strong>{0}</strong> does not exist or is not a folder. Please choose an existing Felix installation folder. It should contain the folders \"bin\" and \"bundle\"";
    protected static final String NO_BIN_FOLDER = "The base folder <strong>{0}</strong> does not contain a folder <strong>bin</strong>. The bin folder in a Felix installation contains the core bundle.";
    protected static final String NO_BUNDLE_FOLDER = "The base folder <strong>{0}</strong> does not contain a folder <strong>bundle</strong>. The bundle folder in a Felix installation contains additional bundles of the Felix framework.";

    public FelixFrameworkInstanceManager(LibraryHandler libraryHandler, LocalFileSystem fileSystem, Application application) {
        this._libraryHandler = libraryHandler;
        this._fileSystem = fileSystem;
        this._application = application;
        this._felixSourceFinder = new FelixSourceFinder();
    }

    @Override
    public void createLibraries(final FrameworkInstanceDefinition frameworkInstanceDefinition) {
        final VirtualFile installFolder = this._fileSystem.findFileByPath(frameworkInstanceDefinition.getBaseFolder());
        if (installFolder == null) {
            throw new RuntimeException("The folder " + frameworkInstanceDefinition.getBaseFolder() + " does not exist.");
        }
        if (!installFolder.isDirectory()) {
            throw new RuntimeException(frameworkInstanceDefinition.getBaseFolder() + " is not a folder");
        }
        this._application.runWriteAction(new Runnable(){

            public void run() {
                VirtualFile bundleFolder;
                installFolder.refresh(false, true);
                FelixFrameworkInstanceManager.this._libraryHandler.startLibraryChanges();
                VirtualFile binFolder = installFolder.findChild("bin");
                if (binFolder != null) {
                    FelixFrameworkInstanceManager.this._libraryHandler.createLibrariesFromBundles(binFolder, frameworkInstanceDefinition.getName(), FelixFrameworkInstanceManager.this._felixSourceFinder);
                }
                if ((bundleFolder = installFolder.findChild("bundle")) != null) {
                    FelixFrameworkInstanceManager.this._libraryHandler.createLibrariesFromBundles(bundleFolder, frameworkInstanceDefinition.getName(), FelixFrameworkInstanceManager.this._felixSourceFinder);
                }
                FelixFrameworkInstanceManager.this._libraryHandler.commitLibraryChanges();
                FelixFrameworkInstanceManager.this._libraryHandler.endLibraryChanges();
            }
        });
    }

    @Override
    public void removeLibraries(final FrameworkInstanceDefinition frameworkInstanceDefinition) {
        this._application.runWriteAction(new Runnable(){

            public void run() {
                FelixFrameworkInstanceManager.this._libraryHandler.startLibraryChanges();
                FelixFrameworkInstanceManager.this._libraryHandler.deleteLibraries(frameworkInstanceDefinition.getName());
                FelixFrameworkInstanceManager.this._libraryHandler.commitLibraryChanges();
            }
        });
    }

    @Override
    public List<Library> getLibraries(FrameworkInstanceDefinition frameworkInstanceDefinition) {
        return this._libraryHandler.getLibraries(frameworkInstanceDefinition.getName());
    }

    @Override
    public String checkValidity(@NotNull FrameworkInstanceDefinition frameworkInstanceDefinition) {
        if (frameworkInstanceDefinition == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/osmorc/frameworkintegration/impl/felix/FelixFrameworkInstanceManager.checkValidity must not be null");
        }
        if (frameworkInstanceDefinition.getName() == null || frameworkInstanceDefinition.getName().trim().length() == 0) {
            return "A name for the framework instance needs to be given.";
        }
        VirtualFile installFolder = this._fileSystem.findFileByPath(frameworkInstanceDefinition.getBaseFolder());
        if (installFolder == null || !installFolder.isDirectory()) {
            return MessageFormat.format(FOLDER_DOES_NOT_EXIST, frameworkInstanceDefinition.getBaseFolder());
        }
        VirtualFile binFolder = installFolder.findChild("bin");
        if (binFolder == null || !binFolder.isDirectory()) {
            return MessageFormat.format(NO_BIN_FOLDER, frameworkInstanceDefinition.getBaseFolder());
        }
        VirtualFile bundleFolder = installFolder.findChild("bundle");
        if (bundleFolder == null || !bundleFolder.isDirectory()) {
            return MessageFormat.format(NO_BUNDLE_FOLDER, frameworkInstanceDefinition.getBaseFolder());
        }
        return null;
    }
}

